/*-------------------------------------------
  pagemisc.c
@@ȗvvpeBy[W
@@KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnApply(HWND hDlg);
static void OnDeskcal(HWND hDlg);
static void OnSanshoDeskcal(HWND hDlg, WORD id);

static void OnStartup(HWND hDlg);
BOOL CreateLink(LPCSTR fname, LPCSTR dstpath, LPCSTR name);

/*------------------------------------------------
@ȗvy[Wp_CAOvV[W
--------------------------------------------------*/
BOOL CALLBACK PageMiscProc(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			// uvȂv
			if(id == IDC_NOCLOCK)
				SendPSChanged(hDlg);
			// ufXNgbvJ_[̎XVv
			else if(id == IDC_DESKCAL)
				OnDeskcal(hDlg);
			// `FbN{bNX
			else if(id == IDC_MCIWAVE || id == IDC_ONLYDATECHANGED ||
					id == IDC_RESUMESUSPEND || id == IDC_TONIKAKU || 
					id == IDC_WATCHWALL)
				SendPSChanged(hDlg);
			// bɊJn
			else if(id == IDC_DELAYSTART && code == EN_CHANGE)
				SendPSChanged(hDlg);
			// u...v fXNgbvJ_[̎Q
			else if(id == IDC_SANSHODESKCAL)
				OnSanshoDeskcal(hDlg, id);
			// uX^[gAbvvɃV[gJbg
			else if(id == IDC_STARTUP)
				OnStartup(hDlg);
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: OnApply(hDlg); break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 6); break;
			}
			return TRUE;
	}
	return FALSE;
}

/*------------------------------------------------
@y[W̏
--------------------------------------------------*/
void OnInit(HWND hDlg)
{
	char s[1024];
	
	CheckDlgButton(hDlg, IDC_NOCLOCK,
		GetMyRegLong("", "NoClock", FALSE));
	
	CheckDlgButton(hDlg, IDC_MCIWAVE,
		GetMyRegLong("", "MCIWave", FALSE));

	SendDlgItemMessage(hDlg, IDC_SPINDELAYSTART, UDM_SETRANGE, 0,
		MAKELONG(600, 0));
	SendDlgItemMessage(hDlg, IDC_SPINDELAYSTART, UDM_SETPOS, 0,
		(int)(short)GetMyRegLong("", "DelayStart", 0));
	
	CheckDlgButton(hDlg, IDC_DESKCAL,
		GetMyRegLong("", "Deskcal", FALSE));
	
	if(GetRegStr(HKEY_CURRENT_USER, "Software\\Shinonon\\Deskcal",
		"ExeFileName", s, 1024, "") == 0)
	{
		GetMyRegStr("", "DeskcalCommand", s, 1024, "");
	}
	SetDlgItemText(hDlg, IDC_COMDESKCAL, s);
	
	CheckDlgButton(hDlg, IDC_ONLYDATECHANGED,
		GetMyRegLong("", "DeskcalOnlyDate", FALSE));
	CheckDlgButton(hDlg, IDC_RESUMESUSPEND,
		GetMyRegLong("", "DeskcalResumeSuspend", FALSE));
	CheckDlgButton(hDlg, IDC_TONIKAKU,
		GetMyRegLong("", "DeskcalTonikaku", FALSE));
	CheckDlgButton(hDlg, IDC_WATCHWALL,
		GetMyRegLong("", "WatchWallpaper", FALSE));
	
	OnDeskcal(hDlg);
}

/*------------------------------------------------
@XV
--------------------------------------------------*/
void OnApply(HWND hDlg)
{
	char s[1024];

	SetMyRegLong("", "NoClock", IsDlgButtonChecked(hDlg, IDC_NOCLOCK));
	
	SetMyRegLong("", "MCIWave", IsDlgButtonChecked(hDlg, IDC_MCIWAVE));
	
	SetMyRegLong("", "DelayStart",
		SendDlgItemMessage(hDlg, IDC_SPINDELAYSTART, UDM_GETPOS, 0, 0));
	
	SetMyRegLong("", "Deskcal", IsDlgButtonChecked(hDlg, IDC_DESKCAL));
	
	GetDlgItemText(hDlg, IDC_COMDESKCAL, s, 1024);
	SetMyRegStr("", "DeskcalCommand", s);

	SetMyRegLong("", "DeskcalOnlyDate",
		IsDlgButtonChecked(hDlg, IDC_ONLYDATECHANGED));

	SetMyRegLong("", "DeskcalResumeSuspend",
		IsDlgButtonChecked(hDlg, IDC_RESUMESUSPEND));

	SetMyRegLong("", "DeskcalTonikaku",
		IsDlgButtonChecked(hDlg, IDC_TONIKAKU));
	SetMyRegLong("", "WatchWallpaper",
		IsDlgButtonChecked(hDlg, IDC_WATCHWALL));
}

/*------------------------------------------------
@ufXNgbvJ_[v̎XV
--------------------------------------------------*/
void OnDeskcal(HWND hDlg)
{
	BOOL b;
	int i;
	
	b = IsDlgButtonChecked(hDlg, IDC_DESKCAL);
	for(i = IDC_LABDESKCAL; i <= IDC_WATCHWALL; i++)
		EnableDlgItem(hDlg, i, b);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@u...v@fXNgbvJ_[̎Q
--------------------------------------------------*/
void OnSanshoDeskcal(HWND hDlg, WORD id)
{
	OPENFILENAME ofn;
	char filter[] = "Deskcal.exe\0Deskcal.exe\0";
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	char s[MAX_PATH];
	HFILE hf = HFILE_ERROR;
	
	initdir[0] = 0;
	GetDlgItemText(hDlg, id - 1, initdir, MAX_PATH);
	if(initdir[0]) del_title(initdir);
	else
	{
		strcpy(initdir, mydir); del_title(initdir);
	}
	
	fname[0] = 0;
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER|
		OFN_FILEMUSTEXIST;
	
	if(!GetOpenFileName(&ofn)) return;
	
	strcpy(s, fname);
	strcat(s, " -OnlyDraw");
	SetDlgItemText(hDlg, id - 1, s);
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@uX^[gAbvvɃV[gJbg
--------------------------------------------------*/
void OnStartup(HWND hDlg)
{
	LPITEMIDLIST pidl;
	char dstpath[MAX_PATH], myexe[MAX_PATH];

	if(SHGetSpecialFolderLocation(hDlg, CSIDL_STARTUP, &pidl) == NOERROR &&
		SHGetPathFromIDList(pidl, dstpath) == TRUE)
		;
	else return;
	
	if(MyMessageBox(hDlg, MyString(IDS_STARTUPLINK1),
		"TClock", MB_YESNO, MB_ICONQUESTION) != IDYES) return;

	GetModuleFileName(hInst, myexe, MAX_PATH);
	CreateLink(myexe, dstpath, "TClock");
}

/*------------------------------------------------
@V[gJbg̍쐬
--------------------------------------------------*/
BOOL CreateLink(LPCSTR fname, LPCSTR dstpath, LPCSTR name) 
{
	HRESULT hres;
	IShellLink* psl;
	
	CoInitialize(NULL);
	
	hres = CoCreateInstance(&CLSID_ShellLink, NULL, 
		CLSCTX_INPROC_SERVER, &IID_IShellLink, &psl); 
	if(SUCCEEDED(hres))
	{
		IPersistFile* ppf;
		char path[MAX_PATH];
		
/*		path[0] = '\"';
		strcpy(path+1, fname);
		strcat(path, "\"");*/
		psl->lpVtbl->SetPath(psl, fname);
		psl->lpVtbl->SetDescription(psl, name);
		strcpy(path, fname);
		del_title(path);
		psl->lpVtbl->SetWorkingDirectory(psl, path);
		
		hres = psl->lpVtbl->QueryInterface(psl, &IID_IPersistFile,
			&ppf);
		
		if(SUCCEEDED(hres))
		{
			WORD wsz[MAX_PATH]; 
			char lnkfile[MAX_PATH];
			strcpy(lnkfile, dstpath);
			add_title(lnkfile, (char*)name);
			strcat(lnkfile, ".lnk");
			
			MultiByteToWideChar(CP_ACP, 0, lnkfile, -1,
				wsz, MAX_PATH);
			
			hres = ppf->lpVtbl->Save(ppf, wsz, TRUE);
			ppf->lpVtbl->Release(ppf);
		}
		psl->lpVtbl->Release(psl);
	}
	CoUninitialize();
	
	if(SUCCEEDED(hres)) return TRUE;
	else return FALSE;
}
