/*-------------------------------------------
    pagetaskbar.c
    u^XNo[vvpeBy[W
    KAZUBON 1997-1999
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnApply(HWND hDlg);
static void OnStartBtn(HWND hDlg);
static void OnSansho(HWND hDlg, WORD id);
static void OnSanshoMenu(HWND hDlg, WORD id);
static void OnStartBtnHide(HWND hDlg);
static void OnStartMenu(HWND hDlg);
static void InitColor(HWND hDlg);
static void OnMeasureItemColorCombo(LPARAM lParam);
static void OnDrawItemColorCombo(LPARAM lParam);
static void OnChooseColor(HWND hDlg, WORD id);
static void SetColorFromBmp(HWND hDlg, int idCombo, char* fname);
static BOOL SelectIconInDLL(HWND hDlg, char* fname);
static int nFilterIndex = 1;

BOOL IsIE4(void);

//void OnStartMore(HWND hwnd);

/*------------------------------------------------
@uްvy[Wp_CAOvV[W
--------------------------------------------------*/
BOOL CALLBACK PageTaskbarProc(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_MEASUREITEM:
			OnMeasureItemColorCombo(lParam);
			return TRUE;
		case WM_DRAWITEM:
			OnDrawItemColorCombo(lParam);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			// uX^[g{^v
			if(id == IDC_STARTBTN)
				OnStartBtn(hDlg);
			// urbg}bvvuLvVveLXg{bNX
			else if((id == IDC_FILESTART || id == IDC_CAPTIONSTART ||
				id == IDC_FILEMENU)
				&& code == EN_CHANGE)
				SendPSChanged(hDlg);
			// u...v X^[gj[̃ACRQ
			else if(id == IDC_SANSHOSTART)
				OnSansho(hDlg, id);
			// u...v X^[gj[̃rbg}bvQ
			else if(id == IDC_SANSHOMENU)
				OnSanshoMenu(hDlg, id);
			// uX^[g{^BvuvɃX^[gj[v
			else if(id == IDC_STARTBTNHIDE ||
				id == IDC_STARTMENUCLOCK)
				OnStartBtnHide(hDlg);
			// Flat Start button
			else if(id == IDC_STARTBTNFLAT || id == IDC_TASKSWITCHFLAT)
				SendPSChanged(hDlg);
			// uX^[gj[v
			else if(id == IDC_STARTMENU)
				OnStartMenu(hDlg);
			// R{{bNX
			else if(id == IDC_COLMENU && code == CBN_SELCHANGE)
				SendPSChanged(hDlg);
			//u...vF̑I
			else if(id == IDC_CHOOSECOLMENU)
				OnChooseColor(hDlg, id);
			else if(id == IDC_TILEMENU) // uׂv
				SendPSChanged(hDlg);
			//else if(id == IDC_STARTMORE)
			//	OnStartMore(hDlg);
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: OnApply(hDlg); break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 5); break;
			}
			return TRUE;
	}
	return FALSE;
}

/*------------------------------------------------
@y[W̏
--------------------------------------------------*/
void OnInit(HWND hDlg)
{
	char s[1024];
	HFONT hfont;
	
	CheckDlgButton(hDlg, IDC_STARTBTN,
		GetMyRegLong("", "StartButton", FALSE));
	
	GetMyRegStr("", "StartButtonIcon", s, 1024, "");
	SetDlgItemText(hDlg, IDC_FILESTART, s);
	
	hfont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	if(hfont)
		SendDlgItemMessage(hDlg, IDC_CAPTIONSTART,
			WM_SETFONT, (WPARAM)hfont, 0);
	
	GetMyRegStr("", "StartButtonCaption", s, 80, MyString(IDS_START));
	SetDlgItemText(hDlg, IDC_CAPTIONSTART, s);
	
	OnStartBtn(hDlg);
	
	CheckDlgButton(hDlg, IDC_STARTBTNHIDE,
		GetMyRegLong("", "StartButtonHide", FALSE));
	CheckDlgButton(hDlg, IDC_STARTMENUCLOCK,
		GetMyRegLong("", "StartMenuClock", FALSE));
	OnStartBtnHide(hDlg);
	
	CheckDlgButton(hDlg, IDC_STARTBTNFLAT,
		GetMyRegLong("", "StartButtonFlat", FALSE));
	
	CheckDlgButton(hDlg, IDC_TASKSWITCHFLAT,
		GetMyRegLong("", "TaskSwitchFlat", FALSE));
	EnableDlgItem(hDlg, IDC_TASKSWITCHFLAT, IsIE4());
	
	CheckDlgButton(hDlg, IDC_STARTMENU,
		GetMyRegLong("", "StartMenu", FALSE));
	
	GetMyRegStr("", "StartMenuBmp", s, 1024, "");
	SetDlgItemText(hDlg, IDC_FILEMENU, s);
	
	CheckDlgButton(hDlg, IDC_TILEMENU,
		GetMyRegLong("", "StartMenuTile", FALSE));
	
	InitColor(hDlg);
	OnStartMenu(hDlg);
}

/*------------------------------------------------
@XV
--------------------------------------------------*/
void OnApply(HWND hDlg)
{
	char s[1024];
	DWORD dw;

	SetMyRegLong("", "StartButton", IsDlgButtonChecked(hDlg, IDC_STARTBTN));
	
	GetDlgItemText(hDlg, IDC_FILESTART, s, 1024);
	SetMyRegStr("", "StartButtonIcon", s);
	
	GetDlgItemText(hDlg, IDC_CAPTIONSTART, s, 80);
	SetMyRegStr("", "StartButtonCaption", s);

	SetMyRegLong("", "StartButtonHide",
		IsDlgButtonChecked(hDlg, IDC_STARTBTNHIDE));
	SetMyRegLong("", "StartMenuClock",
		IsDlgButtonChecked(hDlg, IDC_STARTMENUCLOCK));

	SetMyRegLong("", "StartButtonFlat",
		IsDlgButtonChecked(hDlg, IDC_STARTBTNFLAT));
	
	SetMyRegLong("", "TaskSwitchFlat",
		IsDlgButtonChecked(hDlg, IDC_TASKSWITCHFLAT));

	SetMyRegLong("", "StartMenu", IsDlgButtonChecked(hDlg, IDC_STARTMENU));
	
	GetDlgItemText(hDlg, IDC_FILEMENU, s, 1024);
	SetMyRegStr("", "StartMenuBmp", s);

	dw = CBGetItemData(hDlg, IDC_COLMENU, CBGetCurSel(hDlg, IDC_COLMENU));
	SetMyRegLong("", "StartMenuCol", dw);

	SetMyRegLong("", "StartMenuTile",
		IsDlgButtonChecked(hDlg, IDC_TILEMENU));
}

/*------------------------------------------------
@uX^[g{^v
--------------------------------------------------*/
void OnStartBtn(HWND hDlg)
{
	BOOL b;
	int i;
	
	b = IsDlgButtonChecked(hDlg, IDC_STARTBTN);
	for(i = IDC_LABFILESTART; i <= IDC_CAPTIONSTART; i++)
		EnableDlgItem(hDlg, i, b);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@uX^[g{^Bv
--------------------------------------------------*/
void OnStartBtnHide(HWND hDlg)
{
	BOOL b;
	HWND hDlgPage;
	int i;

	b = IsDlgButtonChecked(hDlg, IDC_STARTBTNHIDE);
	EnableDlgItem(hDlg, IDC_STARTMENUCLOCK, b);
	SendPSChanged(hDlg);

	if(b) b = IsDlgButtonChecked(hDlg, IDC_STARTMENUCLOCK);
	
	// u}EXvy[Ẃu{^v֘A
	// L/
	hDlgPage = GetTopWindow(GetParent(hDlg));
	while(hDlgPage)
	{
		if(GetDlgItem(hDlgPage, IDC_LABLCLK))
		{
			for(i = IDC_LABLCLK; i <= IDC_LCLKFILESANSHO; i++)
			{
				EnableDlgItem(hDlgPage, i, !b);
			}
			break;
		}
		hDlgPage = GetNextWindow(hDlgPage, GW_HWNDNEXT);
	}
}

/*------------------------------------------------
@u...v@X^[g{^̃ACRQ
--------------------------------------------------*/
void OnSansho(HWND hDlg, WORD id)
{
	OPENFILENAME ofn;
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	char filter[160];
	char s[MAX_PATH+10], num[10];
	HFILE hf = HFILE_ERROR; char head[2];
	
	filter[0] = filter[1] = 0;
	str0cat(filter, MyString(IDS_BMPFILE)); str0cat(filter, "*.bmp");
	str0cat(filter, MyString(IDS_ICONFILE)); str0cat(filter, "*.ico");
	str0cat(filter, MyString(IDS_EXEDLLFILE)); str0cat(filter, "*.exe;*.dll");
	str0cat(filter, MyString(IDS_ALLFILE)); str0cat(filter, "*.*");

	strcpy(initdir, mydir);
	GetDlgItemText(hDlg, id - 1, s, MAX_PATH);
	if(s[0])
	{
		parse(fname, s, 0);
		parse(num, s, 1);
		hf = _lopen(fname, OF_READ);
	}
	if(hf != HFILE_ERROR)
	{
		_lread(hf, head, 2);
		_lclose(hf);
		
		strcpy(initdir, fname);
		del_title(initdir);

		if(head[0] == 'M' && head[1] == 'Z') //st@C
		{
			// uACȒIv_CAO
			if(SelectIconInDLL(hDlg, s))
			{
				SetDlgItemText(hDlg, id - 1, s);
				PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
				SendPSChanged(hDlg);
			}
			return;
		}
	}
	
	fname[0] = 0;
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.nFilterIndex = nFilterIndex;
	
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER;
	
	if(!GetOpenFileName(&ofn)) return;
	
	nFilterIndex = ofn.nFilterIndex;
	
	hf = _lopen(fname, OF_READ);
	if(hf == HFILE_ERROR) return;
	_lread(hf, head, 2);
	_lclose(hf);
	if(head[0] == 'M' && head[1] == 'Z') //st@C
	{
		// uACȒIv_CAO
		if(!SelectIconInDLL(hDlg, fname)) return;
	}
	
	SetDlgItemText(hDlg, id - 1, fname);
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@u...v@X^[gj[̃rbg}bvQ
--------------------------------------------------*/
void OnSanshoMenu(HWND hDlg, WORD id)
{
	OPENFILENAME ofn;
	char filter[80];
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	HFILE hf;
	
	filter[0] = filter[1] = 0;
	str0cat(filter, MyString(IDS_BMPFILE)); str0cat(filter, "*.bmp");
	str0cat(filter, MyString(IDS_ALLFILE)); str0cat(filter, "*.*");

	GetDlgItemText(hDlg, id - 1, initdir, MAX_PATH);
	hf = _lopen(initdir, OF_READ);
	if(hf != HFILE_ERROR)
	{
		_lclose(hf);
		del_title(initdir);
	}
	else strcpy(initdir, mydir);
	
	fname[0] = 0;
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.nFilterIndex = 1;
	
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER;
	
	if(!GetOpenFileName(&ofn)) return;
	
	SetColorFromBmp(hDlg, IDC_COLMENU, fname);
	
	SetDlgItemText(hDlg, id - 1, fname);
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@uFvR{{bNX̏
--------------------------------------------------*/
void InitColor(HWND hDlg)
{
	COLORREF col;
	int i;
	//WindowsftHg16F
	int rgb[16][3] = {{0,0,0}, {128,0,0}, {0,128,0}, {128,128,0},
		{0,0,128}, {128,0,128}, {0,128,128}, {192,192,192},
		{128,128,128}, {255,0,0}, {0,255,0}, {255,255,0},
		{0,0,255},{255,0,255}, {0,255,255}, {255,255,255}};
	
	for(i = 0; i < 16; i++) //{16F
		CBAddString(hDlg, IDC_COLMENU,
			RGB(rgb[i][0], rgb[i][1], rgb[i][2]));
	
	col = GetMyRegLong("", "StartMenuCol", RGB(128, 128, 128));
	
	for(i = 0; i < 16; i++)
	{
		if(col == (COLORREF)CBGetItemData(hDlg, IDC_COLMENU, i))
			break;
	}
	if(i == 16) //16FɂȂƂ
		CBAddString(hDlg, IDC_COLMENU, col);
	CBSetCurSel(hDlg, IDC_COLMENU, i);
}

/*------------------------------------------------
@uX^[gj[v
--------------------------------------------------*/
void OnStartMenu(HWND hDlg)
{
	BOOL b;
	int i;
	HDC hdc;

	b = IsDlgButtonChecked(hDlg, IDC_STARTMENU);
	for(i = IDC_LABFILEMENU; i <= IDC_TILEMENU; i++)
		EnableDlgItem(hDlg, i, b);
	SendPSChanged(hDlg);
	
	//256Fȉ̂Ƃ́AF̑I𖳌
	hdc = CreateIC("DISPLAY", NULL, NULL, NULL);
	if(GetDeviceCaps(hdc, BITSPIXEL) <= 8)
		EnableDlgItem(hDlg, IDC_CHOOSECOLMENU, FALSE);
	DeleteDC(hdc);
}

/*------------------------------------------------
@uFvR{{bNX̍̐ݒ
--------------------------------------------------*/
void OnMeasureItemColorCombo(LPARAM lParam)
{
	LPMEASUREITEMSTRUCT pmis;
	
	pmis = (LPMEASUREITEMSTRUCT)lParam;
	pmis->itemHeight = 7 * HIWORD(GetDialogBaseUnits()) / 8;
}

/*------------------------------------------------
@uFvR{{bNX̃I[i[h[
--------------------------------------------------*/
void OnDrawItemColorCombo(LPARAM lParam)
{
	LPDRAWITEMSTRUCT pdis;
	HBRUSH hbr;
	COLORREF col;
	
	pdis = (LPDRAWITEMSTRUCT)lParam;
	
	col = pdis->itemData;
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);

	switch(pdis->itemAction)
	{
		case ODA_DRAWENTIRE:
		case ODA_SELECT:
		{
			hbr = CreateSolidBrush(col);
			FillRect(pdis->hDC, &pdis->rcItem, hbr);
			DeleteObject(hbr);
			if(!(pdis->itemState & ODS_FOCUS)) break;
		}
		case ODA_FOCUS:
		{
			if(pdis->itemState & ODS_FOCUS)
				hbr = CreateSolidBrush(0);
			else
				hbr = CreateSolidBrush(col);
			FrameRect(pdis->hDC, &pdis->rcItem, hbr);
			DeleteObject(hbr);
			break;
		}
	}
}

/*------------------------------------------------
@F̑I u...v{^
--------------------------------------------------*/
void OnChooseColor(HWND hDlg, WORD id)
{
	CHOOSECOLOR cc;
	COLORREF col, colarray[16];
	WORD idCombo;
	int i;
	
	idCombo = id - 1;
	
	//ŏɑI΂ĂF
	col = CBGetItemData(hDlg, idCombo, CBGetCurSel(hDlg, idCombo));
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
	
	for(i = 0; i < 16; i++) colarray[i] = RGB(255,255,255);
	
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner = hDlg;
	cc.hInstance = hInst;
	cc.rgbResult = col;
	cc.lpCustColors = colarray;
	cc.Flags = CC_FULLOPEN | CC_RGBINIT;
	
	if(!ChooseColor(&cc)) return;
	
	for(i = 0; i < 16; i++)
	{
		if(cc.rgbResult == (COLORREF)CBGetItemData(hDlg, idCombo, i))
			break;
	}
	if(i == 16) //{16Fł͂ȂƂ
	{
		if(CBGetCount(hDlg, idCombo) == 16)
			CBAddString(hDlg, idCombo, cc.rgbResult);
		else
			CBSetItemData(hDlg, idCombo, 16, cc.rgbResult);
		i = 16;
	}
	CBSetCurSel(hDlg, idCombo, i);
	
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
   Select "Color" combo box automatically.
--------------------------------------------------*/
#define WIDTHBYTES(i) ((i+31)/32*4)

void SetColorFromBmp(HWND hDlg, int idCombo, char* fname)
{
	HFILE hf;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	int numColors;
	BYTE pixel[3];
	COLORREF col;
	int i, index;
	HDC hdc;
	
	hf = _lopen(fname, OF_READ);
	if(hf == HFILE_ERROR) return;
	
	if(_lread(hf, &bmfh, sizeof(bmfh)) != sizeof(bmfh) ||
		bmfh.bfType != *(WORD*)"BM" ||
		_lread(hf, &bmih, sizeof(bmih)) != sizeof(bmih) ||
		bmih.biSize != sizeof(bmih) ||
		bmih.biCompression != BI_RGB ||
		!(bmih.biBitCount <= 8 || bmih.biBitCount == 24))
	{
		_lclose(hf); return;
	}
	numColors = bmih.biClrUsed;
	if(numColors == 0)
	{
		if(bmih.biBitCount <= 8) numColors = 1 << bmih.biBitCount;
		else numColors = 0;
	}
	if(numColors > 0 &&
		_llseek(hf, sizeof(RGBQUAD)*numColors, FILE_CURRENT) == HFILE_ERROR)
	{
		_lclose(hf); return;
	}
	if(_llseek(hf,
			WIDTHBYTES(bmih.biWidth*bmih.biBitCount)*(bmih.biHeight-1),
			FILE_CURRENT) == HFILE_ERROR ||
		_lread(hf, pixel, sizeof(pixel)) != sizeof(pixel))
	{
		_lclose(hf); return;
	}
	if(bmih.biBitCount < 24)
	{
		index = -1;
		if(bmih.biBitCount == 8) index = pixel[0];
		else if(bmih.biBitCount == 4)
			index = (pixel[0] & 0xF0) >> 4;
		else if(bmih.biBitCount == 1)
			index = (pixel[0] & 0x80) >> 7;
		if(_llseek(hf, sizeof(bmfh)+sizeof(bmih)+sizeof(RGBQUAD)*index,
			FILE_BEGIN) == HFILE_ERROR ||
			_lread(hf, pixel, sizeof(pixel)) != sizeof(pixel))
		{
			index = -1;
		}
	}
	_lclose(hf);
	if(index == -1) return;
	col = RGB(pixel[2], pixel[1], pixel[0]);
	
	for(i = 0; i < 16; i++)
	{
		if(col == (COLORREF)CBGetItemData(hDlg, idCombo, i)) break;
	}
	if(i == 16)
	{
		int screencolor;
		hdc = CreateIC("DISPLAY", NULL, NULL, NULL);
		screencolor = GetDeviceCaps(hdc, BITSPIXEL);
		DeleteDC(hdc);
		if(screencolor <= 8) return;
		
		if(CBGetCount(hDlg, idCombo) == 16)
			CBAddString(hDlg, idCombo, col);
		else CBSetItemData(hDlg, idCombo, 16, col);
	}
	CBSetCurSel(hDlg, idCombo, i);
}

//------------------------------------------------------------------
// ȉAACRI_CAO

BOOL CALLBACK DlgProcSelectIcon(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam);
char* fname_SelectIcon;

/*-----------------------------------------------------------------
@ACȒI
@fnaméA
@@st@ĈƂA"A:\WINDOWS\SYSTEM\SHELL32.DLL,8"
	ȊÔƂA@@"C:\MY PROGRAM\TCLOCK\NIKO.BMP" ȂǂƂȂ
-------------------------------------------------------------------*/
BOOL SelectIconInDLL(HWND hDlg, char* fname)
{
	fname_SelectIcon = fname;
	if(DialogBox(hInst, MAKEINTRESOURCE(IDD_SELECTICON),
		hDlg, DlgProcSelectIcon) != IDOK) return FALSE;
	return TRUE;
}

static BOOL InitSelectIcon(HWND hDlg);
static void EndSelectIcon(HWND hDlg);
static void OnOKSelectIcon(HWND hDlg);
static void OnMeasureItemListSelectIcon(HWND hDlg, LPARAM lParam);
static void OnDrawItemListSelectIcon(LPARAM lParam);
static void OnSanshoSelectIcon(HWND hDlg);

/*------------------------------------------------
@ACRI_CAOvV[W
--------------------------------------------------*/
BOOL CALLBACK DlgProcSelectIcon(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			if(!InitSelectIcon(hDlg))
				EndDialog(hDlg, IDCANCEL);
			return TRUE;
		case WM_MEASUREITEM:
			OnMeasureItemListSelectIcon(hDlg, lParam);
			return TRUE;
		case WM_DRAWITEM:
			OnDrawItemListSelectIcon(lParam);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			if(id == IDC_SANSHOICON) OnSanshoSelectIcon(hDlg);
			else if(id == IDOK || id == IDCANCEL)
			{
				if(id == IDOK) OnOKSelectIcon(hDlg);
				EndSelectIcon(hDlg);
				EndDialog(hDlg, id);
			}
			return TRUE;
		}
	}
	return FALSE;
}

/*------------------------------------------------
@ACRI_CAȌ
--------------------------------------------------*/
BOOL InitSelectIcon(HWND hDlg)
{
	int i, count, index;
	HICON hicon, hiconl;
	char msg[MAX_PATH];
	char fname[MAX_PATH], num[10];
	
	parse(fname, fname_SelectIcon, 0);
	parse(num, fname_SelectIcon, 1);
	if(num[0] == 0) index = 0;
	else index = atoi(num);
	
	count = (int)ExtractIcon(hInst, fname, (UINT)-1);
	if(count == 0)
	{
		strcpy(msg, MyString(IDS_NOICON));
		strcat(msg, "\n");
		strcat(msg, fname);
		MyMessageBox(hDlg, msg, "TClock", MB_OK, MB_ICONEXCLAMATION);
		return FALSE;
	}
	
	EndSelectIcon(hDlg);
	SendDlgItemMessage(hDlg, IDC_LISTICON, LB_RESETCONTENT, 0, 0);
	
	for(i = 0; i < count; i++)
	{
		hiconl = NULL; hicon = NULL;
		ExtractIconEx(fname, i, &hiconl, &hicon, 1);
		if(hiconl) DestroyIcon(hiconl);
		SendDlgItemMessage(hDlg, IDC_LISTICON, LB_ADDSTRING, 0,
			(LPARAM)hicon);
	}
	SetDlgItemText(hDlg, IDC_FNAMEICON, fname);
	SendDlgItemMessage(hDlg, IDC_LISTICON, LB_SETCURSEL,
		index, 0);
	strcpy(fname_SelectIcon, fname);
	return TRUE;
}

/*------------------------------------------------
@ACRI_CAǑn
--------------------------------------------------*/
void EndSelectIcon(HWND hDlg)
{
	int i, count;
	HICON hicon;
	count = SendDlgItemMessage(hDlg, IDC_LISTICON, LB_GETCOUNT, 0, 0);
	for(i = 0; i < count; i++)
	{
		hicon = (HICON)SendDlgItemMessage(hDlg, IDC_LISTICON,
			LB_GETITEMDATA, i, 0);
		if(hicon) DestroyIcon(hicon);
	}
}

/*------------------------------------------------
@ACRI_CAÓuOKv
--------------------------------------------------*/
void OnOKSelectIcon(HWND hDlg)
{
	char num[10];
	int index;
	
	GetDlgItemText(hDlg, IDC_FNAMEICON, fname_SelectIcon, MAX_PATH);
	index = SendDlgItemMessage(hDlg, IDC_LISTICON, LB_GETCURSEL, 0, 0);
	wsprintf(num, ",%d", index);
	strcat(fname_SelectIcon, num);
}

/*------------------------------------------------
@ACRXg̃TCY߂
--------------------------------------------------*/
void OnMeasureItemListSelectIcon(HWND hDlg, LPARAM lParam)
{
	LPMEASUREITEMSTRUCT pMis;
	RECT rc;

	pMis = (LPMEASUREITEMSTRUCT)lParam;
	GetClientRect(GetDlgItem(hDlg, pMis->CtlID), &rc);
	pMis->itemHeight = rc.bottom;
	pMis->itemWidth = 32;
}

/*------------------------------------------------
@ACRXg̕`
--------------------------------------------------*/
void OnDrawItemListSelectIcon(LPARAM lParam)
{
	LPDRAWITEMSTRUCT pDis;
	HBRUSH hbr;
	COLORREF col;
	RECT rc;
	int cxicon, cyicon;

	pDis = (LPDRAWITEMSTRUCT)lParam;
	
	switch(pDis->itemAction)
	{
		case ODA_DRAWENTIRE:
		case ODA_SELECT:
		{
			if(pDis->itemState & ODS_SELECTED)
				col = GetSysColor(COLOR_HIGHLIGHT);
			else col = GetSysColor(COLOR_WINDOW);
			hbr = CreateSolidBrush(col);
			FillRect(pDis->hDC, &pDis->rcItem, hbr);
			DeleteObject(hbr);
			if(!(pDis->itemState & ODS_FOCUS)) break;
		}
		case ODA_FOCUS:
		{
			if(pDis->itemState & ODS_FOCUS)
				col = GetSysColor(COLOR_WINDOWTEXT);
			else
				col = GetSysColor(COLOR_WINDOW);
			hbr = CreateSolidBrush(col);
			FrameRect(pDis->hDC, &pDis->rcItem, hbr);
			DeleteObject(hbr);
			break;
		}
	}
	
	if(pDis->itemData == 0) return;
	
	cxicon = GetSystemMetrics(SM_CXSMICON);
	cyicon = GetSystemMetrics(SM_CYSMICON);

	CopyRect(&rc, &(pDis->rcItem));
	DrawIconEx(pDis->hDC,
		rc.left + (rc.right - rc.left - cxicon)/2,
		rc.top + (rc.bottom - rc.top - cyicon)/2,
		(HICON)pDis->itemData,
		cxicon, cyicon, 0, NULL, DI_NORMAL);
}

/*------------------------------------------------
@ACȒI̒̃t@C̎Q
--------------------------------------------------*/
void OnSanshoSelectIcon(HWND hDlg)
{
	OPENFILENAME ofn;
	char filter[160];
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	HFILE hf = HFILE_ERROR; char head[2];
	
	filter[0] = filter[1] = 0;
	str0cat(filter, MyString(IDS_BMPFILE)); str0cat(filter, "*.bmp");
	str0cat(filter, MyString(IDS_ICONFILE)); str0cat(filter, "*.ico");
	str0cat(filter, MyString(IDS_EXEDLLFILE)); str0cat(filter, "*.exe;*.dll");
	str0cat(filter, MyString(IDS_ALLFILE)); str0cat(filter, "*.*");

	GetDlgItemText(hDlg, IDC_FNAMEICON, initdir, MAX_PATH);
	del_title(initdir);
	
	fname[0] = 0;
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER;
	ofn.nFilterIndex = 3;
	
	if(!GetOpenFileName(&ofn)) return;
	
	nFilterIndex = ofn.nFilterIndex;
	
	hf = _lopen(fname, OF_READ);
	if(hf == HFILE_ERROR) return;
	_lread(hf, head, 2);
	_lclose(hf);
	strcpy(fname_SelectIcon, fname);
	
	if(head[0] == 'M' && head[1] == 'Z') //st@C
	{
		if(InitSelectIcon(hDlg))
			PostMessage(hDlg, WM_NEXTDLGCTL,
				(WPARAM)GetDlgItem(hDlg, IDC_LISTICON), TRUE);
	}
	else
	{
		EndSelectIcon(hDlg);
		EndDialog(hDlg, IDOK);
	}
}

/*------------------------------------------------
@IE4ǂ
--------------------------------------------------*/
BOOL IsIE4(void)
{
	HWND hwnd;
	char classname[80];
	DWORD dw;
	
	dw = GetRegLong(HKEY_CURRENT_USER,
		"Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer",
		"ClassicShell", 0);
	if(dw) return TRUE;
	
	hwnd = FindWindow("Shell_TrayWnd", NULL);
	if(hwnd == NULL) return FALSE;
	hwnd = GetWindow(hwnd, GW_CHILD);
	while(hwnd)
	{
		GetClassName(hwnd, classname, 80);
		if(lstrcmpi(classname, "ReBarWindow32") == 0)
			return TRUE;
		hwnd = GetWindow(hwnd, GW_HWNDNEXT);
	}
	return FALSE;
}
