/*-------------------------------------------
  utl.c
    ̑̊֐
    KAZUBON 1997-1998
---------------------------------------------*/

#include <windows.h>
#include <windowsx.h>

extern HINSTANCE hInst;

/*-------------------------------------------
  ^C֐̑p
---------------------------------------------*/
int atoi(const char *p)
{
	int r = 0;
	while(*p)
	{
		if('0' <= *p && *p <= '9')
			r = r * 10 + *p - '0';
		p++;

	}
	return r;
}

int atox(const char *p)
{
	int r = 0;
	while(*p)
	{
		if('0' <= *p && *p <= '9')
			r = r * 16 + *p - '0';
		else if('A' <= *p && *p <= 'F')
			r = r * 16 + *p - 'A' + 10;
		else if('a' <= *p && *p <= 'f')
			r = r * 16 + *p - 'a' + 10;
		p++;

	}
	return r;
}

__inline int toupper(int c)
{
	if('a' <= c && c <= 'z')
		c -= 'a' - 'A';
	return c;
}

int _strnicmp(const char* d, const char* s, size_t n)
{
	int c1, c2;
	unsigned int i;
	for(i = 0; i < n; i++)
	{
		if(*s == 0 && *d == 0) break;
		c1 = toupper(*d); c2 = toupper(*s);
		if(c1 != c2) return (c1 - c2);
		d++; s++;
	}
	return 0;
}

int _stricmp(const char* d, const char* s)
{
	int c1, c2;
	unsigned int i;
	while(1)
	{
		if(*s == 0 && *d == 0) break;
		c1 = toupper(*d); c2 = toupper(*s);
		if(c1 != c2) return (c1 - c2);
		d++; s++;
	}
	return 0;
}

/*-------------------------------------------
@pXɃt@C
---------------------------------------------*/
void add_title(char *path, char *title)
{
	char *p;
	
	p = path;

	if(*title && *(title + 1) == ':') ;
	else if(*title == '\\')
	{
		if(*p && *(p + 1) == ':') p += 2;
	}
	else
	{
		while(*p)
		{
			if((*p == '\\' || *p == '/') && *(p + 1) == 0)
			{
				break;
			}
			p = CharNext(p);
		}
		*p++ = '\\';
	}
	while(*title) *p++ = *title++;
	*p = 0;
}

/*-------------------------------------------
@pXt@CƂ̂
---------------------------------------------*/
void del_title(char *path)
{
	char *p, *ep;

	p = ep = path;
	while(*p)
	{
		if(*p == '\\' || *p == '/')
		{
			if(p > path && *(p - 1) == ':') ep = p + 1;
			else ep = p;
		}
		p = CharNext(p);
	}
	*ep = 0;
}

/*------------------------------------------------
@t@C̊gq̔r
--------------------------------------------------*/
int ext_cmp(char *fname, char *ext)
{
	char* p, *sp;
	
	sp = NULL; p = fname;
	while(*p)
	{
		if(*p == '.') sp = p;
		else if(*p == '\\' || *p == '/') sp = NULL;
		p = CharNext(p);
	}
	
	if(sp == NULL) sp = p;
	if(*sp == '.') sp++;
	
	while(1)
	{
		if(*sp == 0 && *ext == 0) return 0;
		if(toupper(*sp) != toupper(*ext))
			return (toupper(*sp) - toupper(*ext));
		sp++; ext++;
	}
	return 0;
}

/*------------------------------------------------
	J}ŋ؂ꂽo
--------------------------------------------------*/
void parse(char *dst, char *src, int n)
{
	char *dp;
	int i;

	for(i = 0; i < n; i++)
	{
		while(*src && *src != ',') src++;
		if(*src == ',') src++;
	}
	if(*src == 0) 
	{
		*dst = 0; return;
	}
	
	while(*src == ' ') src++;
	
	dp = dst;
	while(*src && *src != ',') *dst++ = *src++;
	*dst = 0;
	
	while(dst != dp)
	{
		dst--;
		if(*dst == ' ') *dst = 0;
		else break;
	}
}

/*------------------------------------------------
	ŋ؂ꂽo
--------------------------------------------------*/
void parsechar(char *dst, char *src, char ch, int n)
{
	char *dp;
	int i;

	for(i = 0; i < n; i++)
	{
		while(*src && *src != ch) src++;
		if(*src == ch) src++;
	}
	if(*src == 0) 
	{
		*dst = 0; return;
	}
	
	while(*src == ' ') src++;
	
	dp = dst;
	while(*src && *src != ch) *dst++ = *src++;
	*dst = 0;
	
	while(dst != dp)
	{
		dst--;
		if(*dst == ' ') *dst = 0;
		else break;
	}
}

/*------------------------------------------------
@'\0'ŏI镶ǉ
@Ō"\0\0"ŏI
--------------------------------------------------*/
void str0cat(char* dst, const char* src)
{
	char* p;
	p = dst;
	while(*p) { while(*p) p++; p++; }
	strcpy(p, src);
	while(*p) p++; p++; *p = 0;
}

/*-------------------------------------------
  returns a resource string
---------------------------------------------*/
char* MyString(UINT id)
{
	static char buf[80];
	
	if(LoadString(hInst, id, buf, 80) == 0)
		buf[0] = 0;
	
	return buf;
}

/*-------------------------------------------
  ACRbZ[W{bNX
---------------------------------------------*/
int MyMessageBox(HWND hwnd, char* msg, char* title, UINT uType, UINT uBeep)
{
	MSGBOXPARAMS mbp;
	
	memset(&mbp, 0, sizeof(MSGBOXPARAMS));
	mbp.cbSize = sizeof(MSGBOXPARAMS);
	mbp.hwndOwner = hwnd;
	mbp.hInstance = hInst;
	mbp.lpszText = msg;
	mbp.lpszCaption = title;
	mbp.dwStyle = MB_USERICON | uType;
	mbp.lpszIcon = MAKEINTRESOURCE(101);
	mbp.dwLanguageId = MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT);
	if(uBeep != 0xFFFFFFFF)
		MessageBeep(uBeep);
	return MessageBoxIndirect(&mbp);
}

/*------------------------------------------------
  get locale info for 95/NT
--------------------------------------------------*/
int GetLocaleInfoWA(int ilang, LCTYPE LCType, char* dst, int n)
{
	int r;
	LCID Locale;
	
	*dst = 0;
	Locale = MAKELCID((WORD)ilang, SORT_DEFAULT);
	if(GetVersion() & 0x80000000) // 95
		r = GetLocaleInfoA(Locale, LCType, dst, n);
	else  // NT
	{
		WCHAR* pw;
		pw = (WCHAR*)GlobalAllocPtr(GHND, sizeof(WCHAR)*(n+1));
		r = GetLocaleInfoW(Locale, LCType, pw, n);
		if(r)
			WideCharToMultiByte(CP_ACP, 0, pw, -1, dst, n,
				NULL, NULL);
		GlobalFreePtr(pw);
	}
	return r;
}

/*-------------------------------------------
  32bit x 32bit = 64bit
---------------------------------------------*/
DWORDLONG M32x32to64(DWORD a, DWORD b)
{
	ULARGE_INTEGER r;
	DWORD *p1, *p2, *p3;
	memset(&r, 0, 8);
	p1 = &r.LowPart;
	p2 = (DWORD*)((BYTE*)p1 + 2);
	p3 = (DWORD*)((BYTE*)p2 + 2);
	*p1 = LOWORD(a) * LOWORD(b);
	*p2 += LOWORD(a) * HIWORD(b) + HIWORD(a) * LOWORD(b);
	*p3 += HIWORD(a) * HIWORD(b);
	return *(DWORDLONG*)(&r);
}

void WriteDebug(char* s);

/*-------------------------------------------
  SetForegroundWindow for Windows98
---------------------------------------------*/
void SetForegroundWindow98(HWND hwnd)
{
	DWORD dwVer;
	
	dwVer = GetVersion();
	if((dwVer & 0x80000000) && HIBYTE(LOWORD(dwVer)) >= 10) // Win98
	{
		DWORD thread1, thread2;
		DWORD pid;
		thread1 = GetWindowThreadProcessId(
			GetForegroundWindow(), &pid);
		thread2 = GetCurrentThreadId();
		AttachThreadInput(thread2, thread1, TRUE);
		SetForegroundWindow(hwnd);
		AttachThreadInput(thread2, thread1, FALSE);
		BringWindowToTop(hwnd);
	}
	else  // Win95/NT
		SetForegroundWindow(hwnd);
}

/*-------------------------------------------
  for debugging
---------------------------------------------*/
void WriteDebug(char* s)
{
	HFILE hf;
	char fname[] = "DEBUG.TXT";
	
	hf = _lopen(fname, OF_WRITE);
	if(hf == HFILE_ERROR)
		hf = _lcreat(fname, 0);
	if(hf == HFILE_ERROR) return;
	_llseek(hf, 0, 2);
	_lwrite(hf, s, lstrlen(s));
	_lwrite(hf, "\x0d\x0a", 2);
	_lclose(hf);
}

//TClockp̃WXg̃L[
char mykey[] = "Software\\Kazubon\\TClock";

/*------------------------------------------------
@̃WXg當𓾂
--------------------------------------------------*/
int GetMyRegStr(char* section, char* entry, char* val, int cbData,
	char* defval)
{
	char keystr[80];
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	strcpy(keystr, mykey);
	if(section && *section)
	{
		strcat(keystr, "\\"); strcat(keystr, section);
	}
	b = FALSE;
	if(RegOpenKey(HKEY_CURRENT_USER, keystr, &hkey) == 0)
	{
		size = cbData;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)val, &size) == 0)
		{
			if(size == 0) *val = 0;
			r = size;
			b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE)
	{
		strcpy(val, defval);
		r = strlen(defval);
	}
	return r;
}

/*------------------------------------------------
@̃WXgLONGl𓾂
--------------------------------------------------*/
LONG GetMyRegLong(char* section, char* entry, LONG defval)
{
	char keystr[80];
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	LONG r;

	strcpy(keystr, mykey);
	if(section && *section)
	{
		strcat(keystr, "\\"); strcat(keystr, section);
	}
	b = FALSE;
	if(RegOpenKey(HKEY_CURRENT_USER, keystr, &hkey) == 0)
	{
		size = 4;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)&r, &size) == 0)
		{
			if(size == 4) b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE) r = defval;
	return r;
}

/*------------------------------------------------
  get DWORD value from registry
--------------------------------------------------*/
LONG GetRegLong(HKEY rootkey, char*subkey, char* entry, LONG defval)
{
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	b = FALSE;
	if(RegOpenKey(rootkey, subkey, &hkey) == 0)
	{
		size = 4;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)&r, &size) == 0)
		{
			if(size == 4) b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE) r = defval;
	return r;
}

/*------------------------------------------------
@WXg當𓾂
--------------------------------------------------*/
int GetRegStr(HKEY rootkey, char*subkey, char* entry,
	char* val, int cbData, char* defval)
{
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	b = FALSE;
	if(RegOpenKey(rootkey, subkey, &hkey) == 0)
	{
		size = cbData;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)val, &size) == 0)
		{
			if(size == 0) *val = 0;
			b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE)
	{
		strcpy(val, defval);
		r = strlen(defval);
	}
	return r;
}

/*-------------------------------------------
@WXgɕ
---------------------------------------------*/
BOOL SetMyRegStr(char* subkey, char* entry, char* val)
{
	HKEY hkey;
	BOOL r;
	char key[80];
	
	strcpy(key, mykey);
	if(*subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegCreateKey(HKEY_CURRENT_USER, key, &hkey) == 0)
	{
		if(RegSetValueEx(hkey, entry, 0, REG_SZ,
			(CONST BYTE*)val, strlen(val)) == 0)
		{
			r = TRUE;
		}
		RegCloseKey(hkey);
	}
	return r;
}

/*-------------------------------------------
@WXgɕ
---------------------------------------------*/
BOOL SetRegStr(HKEY rootkey, char* subkey, char* entry, char* val)
{
	HKEY hkey;
	BOOL r;

	if(RegCreateKey(rootkey, subkey, &hkey) == 0)
	{
		if(RegSetValueEx(hkey, entry, 0, REG_SZ,
			(CONST BYTE*)val, strlen(val)) == 0)
		{
			r = TRUE;
		}
		RegCloseKey(hkey);
	}
	return r;
}

/*-------------------------------------------
@WXgDWORDl
---------------------------------------------*/
BOOL SetMyRegLong(char* subkey, char* entry, DWORD val)
{
	HKEY hkey;
	BOOL r;
	char key[80];
	
	strcpy(key, mykey);
	if(*subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegCreateKey(HKEY_CURRENT_USER, key, &hkey) == 0)
	{
		if(RegSetValueEx(hkey, entry, 0, REG_DWORD,
			(CONST BYTE*)&val, 4) == 0)
		{
			r = TRUE;
		}
		RegCloseKey(hkey);
	}
	return r;
}


/*-------------------------------------------
@WXg̒l폜
---------------------------------------------*/
BOOL DelMyReg(char* subkey, char* entry)
{
	BOOL r;
	char key[80];
	HKEY hkey;
	
	strcpy(key, mykey);
	if(*subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegOpenKey(HKEY_CURRENT_USER, key, &hkey) == 0)
	{
		if(RegDeleteValue(hkey, entry) == 0)
			r = TRUE;
		RegCloseKey(hkey);
	}
	return r;
}

/*-------------------------------------------
@WXg̃L[폜
---------------------------------------------*/
BOOL DelMyRegKey(char* subkey)
{
	BOOL r;
	char key[80];
	
	strcpy(key, mykey);
	if(subkey && *subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegDeleteKey(HKEY_CURRENT_USER, key) == 0)
		r = TRUE;
	return r;
}
