/********************************************************************/
/********************************************************************/

'@echo off'
say ''
'echo USE: "uninstal clean" to remove all MGA drivers from hard disk"'
say ''
'echo Press Ctrl+C to abort'
'pause'

CurDir=directory()

/********************************************************************/
/* Search for OS2 system path in PATH environement                  */
/********************************************************************/

env = 'OS2ENVIRONMENT'
Path = value('PATH',,env)
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

Dstdrv=substr(Path, ntmp-1,2)

/*********************************************************************/
/* remove any MGA statement from CONFIG.SYS                          */
/*********************************************************************/

NewDir=directory(Dstdrv'\')             /* go to root off OS/2 drive */
InnF=Dstdrv'\CONFIG.MGA'
OutF=Dstdrv'\CONFIG.SYS'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

do until lines(InnF) = 0
    InStr = linein(InnF)
    select
        when pos('MGAKRNL.SYS', InStr) > 0  then nop    /* Terminator       */
        when pos('MGA=', InStr) > 0         then nop    /* Termin / Millen  */
        when pos('MGARES=', InStr) > 0      then nop    /* Terminator < 2.0 */
        when pos('VIO_MGA', InStr) > 0      then nop    /* Termin / Millen  */
        when pos('RAMBIOS.SYS', InStr) > 0  then nop    /* Terminator < 2.0 */
        when pos('VMGA.SYS', InStr) > 0     then nop    /* Terminator       */
        when pos('KMGAX64.SYS', InStr) > 0  then nop    /* Millennium       */
        when pos('VMGAX64.SYS', InStr) > 0  then nop    /* Millennium       */
        otherwise
        do
            if pos('LIBPATH=', InStr) > 0   then        do
                itmp = pos(':\MGA\OS', InStr)
                if itmp > 0 then stmp=delstr(InStr, itmp-1, 11)
                else stmp=InStr
                call lineout OutF, stmp
            end
            else do
                itmp = pos(':\MGA\OS2', InStr)
                if itmp = 0 then  call lineout OutF, InStr
                end
        end
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'
'del 'InnF

/**********************************/
/* remove MGAs from  AUTOEXEC.BAT */
/**********************************/

'call 'Dstdrv'\MGA\OS2\FIXAUTO.CMD 'Dstdrv' OFF'

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
ver = SysOS2Ver()

/************************************/
/* remove MGAHK from Startup folder */
/************************************/

Result = SysDestroyObject('<MGAHK>')

/********************************************************************/
/* Get arguments if any                                             */
/********************************************************************/

Parse Arg all
If words(all) = 1 then OPTION = translate(word(all,1))
if OPTION \= 'CLEAN' then signal Finished

/********************************************************************/
/* Search for WinOS2 path in OS2.INI                                */
/********************************************************************/

Windrv=Dstdrv                           /* default value */
WinDir=Windrv'\OS2\MDOS\WINOS2'         /* default value */
FoundWindir=0                           /* not found yet */

IniFile='USER'
Apps='PM_INSTALL'
AppsKeys='WINOS2_LOCATION'

call SysIni IniFile, Apps, AppsKeys
if Result \= 'ERROR:' then
do
    val = SysIni(IniFile, Apps, AppsKeys)
    NewDir=directory(val)
    if NewDir\= '' then do
        WinDir=NewDir
        Windrv=Left(WinDir,2)
        FoundWindir=1                       /* found it     */
    end
end

NewDir=directory(Dstdrv'\MGA\OS2')
'if exist syslevel.mga del syslevel.mga'
'if exist uninstal.cmd del uninstal.cmd'
'if exist mgaconf.cmd  del mgaconf.cmd'
'if exist fixauto.cmd  del fixauto.cmd'
'if exist mgax64s.dsp  del mgax64s.dsp'
'if exist rambios.sys  del rambios.sys'
'if exist KMGAX64.SYS  del KMGAX64.SYS'
'if exist mgaset.exe   del mgaset.exe'
'if exist mgaset.hlp   del mgaset.hlp'
'if exist mgahk.exe    del mgahk.exe'
'if exist vvga.sys     del vvga.sys'
'if exist readme.os2   del readme.os2'
'if exist mga.mon      del mga.mon'
'if exist mgaobj.cmd   del mgaobj.cmd'
'if exist mga.inf      del mga.inf'
'if exist mga.ddc      del mga.ddc'

NewDir = directory(Dstdrv'..')
'rd os2 2>nul'
NewDir = directory(Dstdrv'..')
'rd mga 2>nul'

Result = SysDestroyObject('<MGASET>')

Result = SysIni('USER', 'MGA32',                      'DELETE:')
Result = SysIni('USER', 'WIN_RES_MGAX64_SMALL',       'DELETE:')
Result = SysIni('USER', 'WIN_RES_MGAX64_LARGE',       'DELETE:')
Result = SysIni('USER', 'WIN_RES_UNKNOWN',            'DELETE:')
Result = SysIni('USER', 'WIN_RES_640x480x256',        'DELETE:')
Result = SysIni('USER', 'WIN_RES_640x480x65536',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_640x480x16777216',   'DELETE:')
Result = SysIni('USER', 'WIN_RES_800x600x256',        'DELETE:')
Result = SysIni('USER', 'WIN_RES_800x600x65536',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_800x600x16777216',   'DELETE:')
Result = SysIni('USER', 'WIN_RES_1024x768x256',       'DELETE:')
Result = SysIni('USER', 'WIN_RES_1024x768x65536',     'DELETE:')
Result = SysIni('USER', 'WIN_RES_1024x768x16777216',  'DELETE:')
Result = SysIni('USER', 'WIN_RES_1152x864x256',       'DELETE:')
Result = SysIni('USER', 'WIN_RES_1152x864x65536',     'DELETE:')
Result = SysIni('USER', 'WIN_RES_1152x864x16777216',  'DELETE:')
Result = SysIni('USER', 'WIN_RES_1280x1024x256',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_1280x1024x65536',    'DELETE:')
Result = SysIni('USER', 'WIN_RES_1280x1024x16777216', 'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1200x256',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1200x65536',    'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1200x16777216', 'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1280x256',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1280x65536',    'DELETE:')
Result = SysIni('USER', 'WIN_RES_1600x1280x16777216', 'DELETE:')
Result = SysIni('USER', 'WIN_RES_1800x1440x256',      'DELETE:')
Result = SysIni('USER', 'WIN_RES_1800x1440x65536',    'DELETE:')
Result = SysIni('USER', 'WIN_RES_1800x1440x16777216', 'DELETE:')
Result = SysIni('USER', 'PM_DISPLAYDRIVERS', 'DEFAULTDRIVER',           'DELETE:')
Result = SysIni('USER', 'PM_DISPLAYDRIVERS', 'DEFAULTSYSTEMRESOLUTION', 'DELETE:')
Result = SysIni('USER', 'PM_DISPLAYDRIVERS', 'PMGAX64',                 'DELETE:')
Result = SysIni('USER', 'PM_DISPLAYDRIVERS', 'RESOLUTION_CHANGED',      'DELETE:')

NewDir=directory(Dstdrv'\OS2\DLL')
'if exist pmgax64.dll  del pmgax64.dll'
'if exist bmgax64.dll  del bmgax64.dll'
NewDir=directory(Dstdrv'\OS2\MDOS')
'if exist vmga.sys del VMGAX64.SYS'

if FoundWindir=0 then signal Finished

NewDir=directory(WinDir'\SYSTEM')
'if exist smgax64.drv  del smgax64.drv'
'if exist mgax64.dll   del mgax64.dll'
/* NewDir=directory(Dstdrv'\OS2\MDOS\WINJOS2\SYSTEM') */
'if exist 'Dstdrv'\os2\mdos\winjos2 cd \os2\mdos\winjos2\system'
'if exist smgax64.drv  del smgax64.drv'
'if exist mgax64.dll   del mgax64.dll'

Finished:
call directory CurDir

say ''
say 'MGA driver uninstalled.'
say ''
/* say 'RUN DSPINSTL?' */
'echo Press Ctrl+C to end or another key to run DSPINSTL.'
'pause'
NewDir=directory(Dstdrv'\OS2\INSTALL')      /* go to root off OS/2 drive    */
'DSPINSTL.EXE'                              /* install other display driver */

call directory CurDir
exit

ENDSEARCH:
say 'Cannot locate OS/2 System drive'
