/***************************************************************************
*
*     filename :  lcxiload.c
*
* COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
* All Rights Reserved
*
***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <ctype.h>


#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#ifdef I_MS_DOS
#include <sys\types.h>
#include <sys\timeb.h>
#include <time.h>
#endif


#include "i_head.h"
#ifdef I_OS2
#include <stdlib.h>	/* required in compilation for OS/2 for function prototyping */
#endif

#ifdef I_ATnTUNIX
#include <unistd.h> 	/* required for fseek funtion */
#endif
extern I_IMGLOB i_glob;

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#define KEYWORD "data:"
#define IDKEYWORD "File "


/* handle to IM1280 */
static int fd;

/* prototype */
#ifdef ANSI
static short lcxiload(char _I_PTYPE *filename, unsigned short no_mute_flag);
static void terminate(void);
static void host_wait(void);
static FILE _I_PTYPE *path_fopen ( char _I_PTYPE *name, char _I_PTYPE *path,
char _I_PTYPE *type );
static short gsp_halt(unsigned short no_mute_flag);
static unsigned short search ( FILE _I_PTYPE  *stream, char _I_PTYPE  *string );
#else
static short lcxiload();
static terminate();
static host_wait();
static FILE _I_PTYPE *path_fopen();
static short gsp_halt();
static unsigned short search();
#endif
/****************/
#define DELAY 100L
/****************/

/***************************************************************************
*
*   Function: iolcxiload()
*   Date:     92.03.03
*   Parameters: char *filename : name of shell file to download
*               short flags : download options specified by ANDing
*                             the following values:
*
*                 I_LOADSHELL_A: Alternate address: board is located at CC000H
*                                instead of C4000H (strap 12 is installed)
*                 I_LOADSHELL_2: Register Area 2 is used instead of Register
*                                Area 1  (strap 4 is not installed)
*
*						I_LOADSHELL_M: Mute all print messages
*
*   Description: Downloads specified FPGA file to the XILINX
*   Returns: 
*           0: No errors
*           1: Unable to open device or memory channel 
*			   2: Unable to open file
*			   4: Invalid configuration file
*			   5: GSP not halted
*
***************************************************************************/


#ifdef ANSI
short FTYPE iolcxiload (char _I_PTYPE *filename,short flags)
#else
short FTYPE iolcxiload (filename, flags)
char _I_PTYPE *filename;
short flags;
#endif
{
    unsigned long device;
    short lmapswap = 0;
    short adapt2 = 1;
	 short ret_val = 0;
	 unsigned short no_mute = 1;

    if (flags & I_LOADSHELL_A)
        lmapswap = 1;
    if (flags & I_LOADSHELL_2)
        adapt2 = 0;
    if (flags & I_LOADSHELL_M)		/* Mute all */
		 no_mute = 0;

	 if (!adapt2 && !lmapswap) device = I_LOUT_AOUT_LOW;
       else if (adapt2 && !lmapswap) device = I_LOUT_AIN_LOW;
            else if (!adapt2 && lmapswap) device = I_LIN_AOUT_LOW;
                 else device = I_LIN_AIN_LOW;

    if (( fd = ioopdevice ( device,0 )) == -1 ) {
        if (no_mute)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
            printf( "\nIM-Series: iolcxiload(), cannot open device.\n"); 
# else
            fprintf( stderr, "\nIM-Series: iolcxiload(), cannot open device.\n"); 
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		      ;
#endif  /* I_NOPRINTF */
        return ( 1 );
        }

    iosldevice ( fd );

	 iorsdevice ( fd, I_COLD );

	 if ( ioslmemdevice ( fd ) == -1 )
	    {
        if (no_mute)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
		     printf ( "Error : memory communication channel not available\n" );
# else
		     fprintf ( stderr, "Error : memory communication channel not available\n" );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		     ;
#endif  /* I_NOPRINTF */
		 return (1);
		 }

	 ret_val = lcxiload ( filename, no_mute );
	 terminate ();		 
	 return ( ret_val );

}



#ifdef ANSI
static short lcxiload (char _I_PTYPE *filename, unsigned short no_mute_flag)
#else
static short lcxiload (filename, no_mute_flag)
char _I_PTYPE *filename;
unsigned short no_mute_flag;
#endif
{
	static char *info[3] = {
	                       "sequencer FPGA configuration file   : ",
	                       "acquisition FPGA configuration file : ",
	                       "GSP FPGA configuration file         : ",
	                       };
	unsigned char dummy;
	unsigned char val;
	short i, j;

   /* SHey 94/03/08 Changed hra for WATCOM compiler support */
   /* It was defined as _I_PTYPE before */
	IMGHRA *hra;

	FILE _I_PTYPE *xstream;
	unsigned char buf [ 3 ];

	hra = i_glob.vramhra;

/* Replaced simple fopen() of fpga file with complete fopen() with
   shell path default...
	if (( xstream = fopen ( filename, "rb" )) == NULL )
		{
*/

	/* open configuration file */
   if (( xstream = fopen ( filename, "rb")) == NULL )
#ifndef I_OS2
      if (( xstream = path_fopen ( filename, (char _I_PTYPE *) getenv ( SHELLPATHENVAR ), "rb" )) == NULL )
         if (( xstream = path_fopen ( filename, SHELLPATHDEFAULT, "rb" )) == NULL )
#endif /* I_OS2 */
            {
            if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
               printf ( "cannot open file %s\n", filename );
# else
               fprintf ( stderr, "cannot open file %s\n", filename );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		         ;
#endif  /* I_NOPRINTF */
		      return ( 2 );
		      }


	/* print configuration files identification */
	for ( i = 0; i < 3; i++ )
		if ( search ( xstream, IDKEYWORD ))
			{
			if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
			   printf ( info[i] );
# else
			   fprintf ( stderr, info[i] );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		      info[i] = info[i];         /* Avoid not used warning */
#endif  /* I_NOPRINTF */

			fseek ( xstream, (long) strlen ( IDKEYWORD ), SEEK_CUR );

			while ( (val = (unsigned char) getc ( xstream )) != 0 )
            {
            if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
			      printf ( "%c", val );
# else
			      fprintf ( stderr, "%c", val );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		         ;
#endif  /* I_NOPRINTF */
            }


         if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
            printf ( "%c", ' ' );
# else
            fprintf ( stderr, "%c", ' ' );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		      ;
#endif  /* I_NOPRINTF */

		   while ( (val = (unsigned char) getc ( xstream )) != 0 )
            {
            if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
   		      printf ( "%c", val );
# else
   		      fprintf ( stderr, "%c", val );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		         ;
#endif  /* I_NOPRINTF */
            }

        if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
   	  	   printf ( "%c", '\n' );
# else
   	  	   fprintf ( stderr, "%c", '\n' );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		      ;
#endif  /* I_NOPRINTF */
			}


	/* search keyword identifying data starting point */
	if ( !search ( xstream, KEYWORD ))
	   {
      if (no_mute_flag)
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
     	   printf ( "invalid configuration file %s\n", filename );
# else
     	   fprintf ( stderr, "invalid configuration file %s\n", filename );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
	   
		return ( 4 );
		}


	/* and step over that keyword */
	fseek ( xstream, (long)strlen ( KEYWORD ), SEEK_CUR );

	/* precondition : board reset */
	/* -> prototype switch on : xilrst active, xilreprog active */
	/* -> prototype switch off : no effect if already loaded */
	/* 							 xilrst active after power cycle */

	/* halt gsp */
   if (gsp_halt(no_mute_flag))
	   return ( 5 );

   /* enable FPGA configuration */

   /** second : four dummy access in gcdapr */
	/** pulses xilclk */
	/** ignored if already loaded */
   for ( i = 0; i < 4; i++ )
      {
      hra -> gcdapr = 0;
      ioFlushIndexInADR((short _I_HRDWTYPE *)&(hra -> gcdapr));
      }

   /** first : 1 access (must be read) in optional space */
	/** xilrst inactive, xilreprog inactive */
   
   /*** set gcdapr to point there */
   hra -> gcdapr = 0;
   ioFlushIndexInADR((short _I_HRDWTYPE *)&(hra -> gcdapr));
   /*** enable access to gsp code download area */
   hra -> hctrl |= 0x60;
   /*** dummy read */
   dummy = (unsigned char) *(( i_glob.vrammap ) -> haa.cda );
   dummy = dummy;          /* Avoid not used warning */

   /** fourth : load FPGAs */
   /*** write anywhere ( here : gcdapr ) */
   /*** byte access : bit 0 : sequencer, bit 1 : acquisition, bit 2 : GSP */
   /*** all other bits : X ( don't care ) */
   while ( fread ( buf, 1, 3, xstream ) == 3 )
        for ( i = 0; i < 8; i++ )
            {
            val = 0;
            /* build configuration byte */
            for ( j = 0; j < 3; j++ )
                {
                val |= buf[j] & 0x80;
                val >>= 1;
                buf[j] <<= 1;
                }

            /* write */
            /* hra -> gcdapr = val >> 4; */

			   val >>= 4;
			   *(unsigned char FAR *)(&(hra->gcdapr)) = val;
            ioFlushIndexInADR((short _I_HRDWTYPE *)&(hra -> gcdapr));
			   }

	/* dummy write */
	hra -> gcdapr = val >> 4;
   ioFlushIndexInADR((short _I_HRDWTYPE *)&(hra -> gcdapr));

   return(0);

} /* lcxiload () */
/* -------------------------------------------------------------------- */

#ifdef ANSI
unsigned short search ( FILE _I_PTYPE *stream, char _I_PTYPE *string )
#else
unsigned short search ( stream, string )
FILE _I_PTYPE *stream;
char _I_PTYPE *string;
#endif
{
	char _I_PTYPE *ptr;
	unsigned short found = FALSE;

	while ( !found )
		{
		ptr = string;
		/* search first char	*/
		while ( getc ( stream ) != *string )
			if ( feof( stream ) ) return ( FALSE );

		found = TRUE;
		while ( *(++ptr) != '\0' )
			if ( feof( stream ) || ( getc( stream ) != *ptr ))
				{
				found = FALSE;
				break;
				}
		}

	fseek ( stream, - ( (long)strlen ( string )), SEEK_CUR );

	return ( TRUE );

}



/* --------------------- code copied from ldshell.c ---------------------- */

#ifdef ANSI
static short gsp_halt(unsigned short no_mute_flag)
#else
static short gsp_halt(no_mute_flag)
unsigned short no_mute_flag;
#endif
{
    /* halt and flush cache */
    i_glob.vramhra -> hstctlh = HALT_HSTCTLH;

    /* wait for halt acknowledge */

#ifdef  I_MS_DOS
    host_wait();
#endif

#ifdef  I_UNIX
    sleep(1);
#endif

#ifdef  I_OS2
    DosSleep(500L);
#endif

    if ( i_glob.vramhra -> hstctlh != HALT_CHECK)
       {
       if (no_mute_flag)
		    {
          /* all 386 unixes tried have problems with fprintf and -Zp1 compilation flag */
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
		    printf( "GSP does not send an halt acknowledge.  " );
		    printf( "Download aborted.\n" );
# else
		    fprintf( stderr, "GSP does not send an halt acknowledge.  " );
		    fprintf( stderr, "Download aborted.\n" );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		    ;
#endif  /* I_NOPRINTF */
			 }
		 terminate();   /* old call terminate(3); */
       return ( 1 );
       }
    return ( 0 );

} /* gsp_halt() */

#ifdef ANSI
static FILE _I_PTYPE *path_fopen ( char _I_PTYPE *name, char _I_PTYPE *path,
 char _I_PTYPE *type )
#else
static FILE _I_PTYPE *path_fopen (name, path, type)
char _I_PTYPE *name;
char _I_PTYPE *path;
char _I_PTYPE *type;
#endif
{
	char    _I_PTYPE *p, pathname[256];
	FILE    _I_PTYPE *fp;

	if ( path == NULL )
		return ( NULL );

	/* check name is specified with an absolute path */
#ifdef I_UNIX
	if (( *name == '.' ) || ( *name == '/' ) || ( *name == '~' ))
#else
	if (( *name == '.' ) || ( *name == '\\' ) || ( name[1] == ':' ))
#endif
		return ( NULL );

	/* check for an environment variable for the search path */
	while ( *path  != 0 )
		{
		/* skip all separtors */
		while ( *path == PATHSEPARATOR )
			path++;

		p = pathname;
		while (( *path != 0 ) && ( *path != PATHSEPARATOR ))
			*p++ = *path++;

#ifdef  I_UNIX
		if ( *( p - 1 ) != '/' )
			*p++ = '/';
#else
		if ( *( p - 1 ) != '\\' )
			*p++ = '\\';
#endif

		strcpy ( p, name );

		if ((( fp = fopen ( pathname, type )) != NULL ))
            return ( fp );
        }

    /* when every thing else failed... */
    return ( NULL );

} /* path_fopen () */

#ifdef ANSI
static void terminate(void)
#else
static terminate()
#endif
{

	iorlmemdevice(fd);
	iocldevice(fd);

} /* terminate() */

#ifdef  I_MS_DOS
static void host_wait(void)
{
   struct timeb		   time_loop0;
   struct timeb   		time_loop1;
   signed long 			difference;

   ftime(&time_loop0);
   do
     {
	  ftime(&time_loop1);
     difference  = ((signed long) time_loop1.time) - ((signed long)time_loop0.time);
     difference *= (signed long)1000L;
     difference += ((signed long) time_loop1.millitm) - ((signed long)time_loop0.millitm);
	  }while (difference <= (signed long)DELAY);  /* 18.2 =  1 seconde */

} /* host_wait() */
#endif /* I_MS_DOS */

