/*
    filename :  wrfbarea.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"
#include "i_head.h"

extern  I_IMGLOB    i_glob;

extern unsigned short i_v_adrtable [ I_N_OF_FBORGS ][ I_N_OF_FBS ];
extern unsigned short i_v_factable [ I_N_OF_FBORGS ];
extern unsigned short i_v_sizetable [ I_N_OF_FBORGS ];

#ifndef PHAR_LAP
extern unsigned long i_v_base_address_table [ I_N_OF_FBORGS ][ I_N_OF_FBS ];

/* use for dummy read */
static short dummy;
#endif

/*------------*/
/* PROTOTYPES */
/*------------*/

#ifdef PHAR_LAP
_far unsigned long *AllocSegment ( unsigned long, unsigned long );
_far unsigned long OpenHighFBWindow ( unsigned short window_sel,unsigned long fb );
void FTYPE movsdw ( void _far *sbuf, void _far *dbuf, unsigned short count );
#else
#ifdef I_USE_ASM
#ifdef ANSI
void FTYPE movsdw ( void far *sbuf, void far *dbuf, unsigned short count );
void FTYPE _i_s_movmem286 ( void far *, void far *, unsigned short,
 unsigned short );
void FTYPE _i_movmem386 ( void far *, void far *, unsigned long , long );
#else
FTYPE movsdw ();
FTYPE _i_s_movmem286 ();
FTYPE _i_movmem386 ();
#endif
#endif
#endif


/*/     Function:   iowrfbarea ()
*       Synopsis:   write frame buffer wintow from host ram
*
*       Date:       March 6, 1990
*
*       Parameter:  short fb : destination frame buffer
*                   short xstart, ysrtart, xend, yend : frame buffer area
*                   coordinates
*                   void *buf : pointer to host ram buffer.
*
*       Return value:   1 if operation succeeded, 0 otherwise;
**/

#ifdef  ANSI
short FTYPE iowrfbarea ( short fb, short xstart, short ystart, short xend,
short yend, void _I_PTYPE *buf )
#else
short FTYPE iowrfbarea ( fb, xstart, ystart, xend, yend, buf )
short fb;
short xstart;
short ystart;
short xend;
short yend;
void _I_PTYPE *buf;
#endif
{
    I_TYPE_PTR          nptr;
    I_TYPE_FPTR         host_ptr;
    unsigned short      base, sizefactor;
    unsigned long       height, width, long_pitch, byte_width;
    unsigned short      mlb, mlbinc;
    short               fborg, surfn;
    unsigned short      offset;

#ifndef I_USE_ASM

    unsigned long       i,j;

#endif

#ifdef PHAR_LAP

    _far unsigned long  *start;

#else

    unsigned short      count, regval;
    unsigned long       bit_pitch, byte_pitch, gsp_address, nleft;
    I_TYPE_FPTR         ptr;

#endif /* PHAR_LAP */

#if (!defined ( I_USE_ASM )) || defined ( PHAR_LAP )

    unsigned short      longs_per_line;
    unsigned long       first_bytes, remaining_bytes;

#endif

    /* new pointer use for byte, word or longword access */
    nptr.vptr = buf;

    /* use iowrline if width = 1 */
    if ( xstart == xend )
        return ( iowrline ( fb, I_VERT, xstart, ystart, ( yend - ystart + 1 ),
         nptr.vptr ));

    /* mask surface parameter to get only surface number */
    surfn = fb & 0x07;

    /* get frame buffer organisation */
    if ( fb == I_OVL_SURF )
        fborg = I_OVL_2KX1K;
    else
        fborg = i_glob.vramhra->tappt & I_TAPPT_FBORG_MSK;

    height = yend - ystart + 1;
    width = xend - xstart + 1;

    long_pitch = i_v_factable [ fborg ] * 256;
    if (!long_pitch ) { /* fb width in long words */
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
        printf("\nIM-Series: iowrfbarea(), Bad frame buffer org.\n");
# else
        fprintf( stderr, "\nIM-Series: iowrfbarea(), Bad frame buffer org.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        i_glob.ioerror = I_IOERR_FBORG;
        return (0);
        }

    /* conversion factor */
    sizefactor = i_v_sizetable [ fborg ];

    /* area width in bytes */
    byte_width = width << sizefactor;

    /* get gsp bit address */
    gsp_address = i_v_base_address_table [ fborg ][ surfn ];

#ifndef PHAR_LAP

    nleft = ( unsigned long )height * ( unsigned long )width;

#endif

#ifndef PHAR_LAP

   byte_pitch = long_pitch << 2;  /* fb width in bytes */
   bit_pitch = long_pitch << 5;   /* fb width in bits */

#endif

#ifdef PHAR_LAP

   /* get number of 32-bit accesses in each line */
   longs_per_line = byte_width >> 2;

   OpenHighFBWindow ( 1, surfn );

   host_ptr.lptr = AllocSegment ( i_glob.high_map, 0x200 );

   /* initialise host pointer */
   host_ptr.lptr += ystart * long_pitch + (( xstart << sizefactor ) >> 2 );

   for ( j = 0; j < height; j++)
      {

      start = host_ptr.lptr;

#ifdef I_USE_ASM

      movsdw ( (_far long *)nptr.lptr, host_ptr.vptr, longs_per_line );
      *nptr.lptr += longs_per_line;

#else

      for ( i = 0; i < longs_per_line; i++)
         *host_ptr.lptr++ = *nptr.lptr++;

#endif

      host_ptr.lptr = start + long_pitch; /* go to next line */
      }

#else

#ifndef I_UNIX  /* test always true for unix */

    if ( i_glob.host_cpu_type >= CPU_80386)
        {

#endif

#ifndef I_USE_ASM

        /* test width in bytes */
        if ( byte_width >= 4 )
            {

            first_bytes = ( xstart << sizefactor ) % 4;
            if ( first_bytes )
                first_bytes = 4 - first_bytes;

            /* find how many bytes remain in a line     */
            /* after reading all complete long words    */
            remaining_bytes = (( xend + 1 ) << sizefactor ) % 4;

            /* get number of long word aligned 32-bit accesses in each line */
            longs_per_line = ( byte_width - first_bytes + remaining_bytes )
             >> 2;
            }
        else /* column less than 4 bytes wide */
            {
            first_bytes = byte_width;
            remaining_bytes = 0;
            longs_per_line = 0;
            }

#endif

        /* enable main MLB1 and MLB2 access */
        i_glob.vramhra->hctrl = ( char )(( i_glob.vramhra->hctrl
         & I_SA_EN_MASK ) | MLB12_EN_MASK );

        gsp_address += ( unsigned long )ystart * bit_pitch;
        gsp_address += ( (unsigned long)xstart << sizefactor ) << 3;

        offset = ( unsigned short )(( ystart * byte_pitch )
         + ( xstart << sizefactor )) % (unsigned short) MLB_SIZE;

        if ( fborg == 7) /* if accessing overlay */
            mlb = ( short )( gsp_address >> 12);
        else
            mlb = ( short )( FBSEL_MASK | ( gsp_address >> 12));

        mlbinc = (unsigned short) (bit_pitch >> 12);

        if (( byte_pitch > MLB_SIZE ) && ( offset + byte_width > MLB_SIZE ))
            {

            unsigned short first_chunk = (unsigned short) (MLB_SIZE - ( xstart << sizefactor ));
            unsigned short second_chunk = (unsigned short )(( byte_width + ( xstart << sizefactor )) - MLB_SIZE);

#ifndef I_USE_ASM

            /* convert chunks to long words */
            first_chunk -= first_bytes;
            first_chunk >>= 2;
            second_chunk -= remaining_bytes;
            second_chunk >>= 2;

#endif

            while ( height-- )
                {
                /* set line buffer address, align on 4k boundary */
                i_glob.vramhra->mlb1lr = mlb & 0xfff8;
                ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra->mlb1lr));

                mlb += mlbinc;

                host_ptr.bptr = (char far *)i_glob.vrammap -> haa.mlb + offset;

                offset += (unsigned short) byte_pitch;
                offset %= MLB_SIZE;

#ifdef I_USE_ASM

                _i_movmem386 ( nptr.vptr, host_ptr.vptr,
		(unsigned long) first_chunk , (long) xstart << sizefactor );

                i_glob.vramhra->mlb1lr += 8;
                ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra->mlb1lr));

                _i_movmem386 (nptr.bptr+(unsigned short)MLB_SIZE - ( xstart << sizefactor ),
                              (unsigned char far *)i_glob.vrammap -> haa.mlb,
		                        (unsigned long) second_chunk, (long) 0 );

                nptr.bptr += (unsigned short)byte_width;

#else

                /* first bytes */
                for ( i = 0; i < first_bytes; i++)
                    *nptr.bptr++ = *host_ptr.bptr++;

                /* first chunk : up to the end of the line buffer */
                for ( i = 0; i < first_chunk; i++)
                    *nptr.lptr++ = *host_ptr.lptr++;

                /* move to next block */
                i_glob.vramhra->mlb1lr += 8;
                ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra->mlb1lr));

                /* reset host pointer to beginning of block */
                host_ptr.bptr = ( unsigned char far *)i_glob.vrammap -> haa.mlb;

                /* second chunk */
                for ( i = 0; i < second_chunk; i++)
                    *host_ptr.lptr++ = *nptr.lptr++;

                /* read remaining bytes */
                for ( i = 0; i < remaining_bytes; i++)
                    *host_ptr.bptr++ = *nptr.bptr++;

#endif
                }
            }
        else
            {
            while ( height-- )
                {

                i_glob.vramhra->mlb1lr = mlb & 0xfff8;
                ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra->mlb1lr));

                mlb += mlbinc;

                host_ptr.bptr = (char far *)i_glob.vrammap -> haa.mlb + offset;

                offset += (unsigned short) byte_pitch;
                offset %= MLB_SIZE;

#ifdef I_USE_ASM

                _i_movmem386 (nptr.vptr, host_ptr.vptr,
		                        (unsigned long) byte_width, (long) xstart << sizefactor );

                nptr.bptr += (unsigned short)byte_width;

#else

                /* first bytes */
                for ( i = 0; i < first_bytes; i++)
                    *host_ptr.bptr++ = *nptr.bptr++;
    
                for ( i = 0; i < longs_per_line; i++)
                    *host_ptr.lptr++ = *nptr.lptr++;
    
                /* read remaining bytes */
                for ( i = 0; i < remaining_bytes; i++)
                    *host_ptr.bptr++ = *nptr.bptr++;

#endif
                }
            }

#ifndef I_UNIX

        } /* if ( i_glob.host_cpu_type >= CPU_80386) */

    else

        {
        /* interrupt gsp to select fb/ovl nsaag access */

        /* loop while last interrupt remain unserviced */
        while (( i_glob.vramhra->hstctll ) & I_INTIN );

        /* send message */
        i_glob.vramhra -> dpystrt = ( fb == I_OVL_SURF ) ? 1 : 0;

        /* send interrupt to GSP with message */
        regval = i_glob.vramhra->hstctll;

        /* set MSGIN field to zero */
        regval &= ~I_MSGINMSK;

        /* set INTIN and MSGIN */
        i_glob.vramhra->hstctll = regval | I_INTIN | I_MSG_SET_NSAAG_ACCESS;

        /* loop until interrupt routine has finished */
        while (( i_glob.vramhra->hstctll ) & I_INTIN );

        /* enable SA mode */
        i_glob.vramhra->hctrl &= I_SA_EN_MASK;

        /* get base address from table */
        base = i_v_adrtable [ fborg ][ surfn ];
    
        /* return error message if surfn/fborg combination is invalid */
        if ( base == 0 )
            {
            i_glob.ioerror = I_IOERR_SURF;
            return(0);
            }

        /* add y offset to base address */
        base += ystart * i_v_factable [ fborg ];

        /* set SAAG registers */
        i_glob.vramhra -> nsaag_xsa = xstart << sizefactor;
        ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> nsaag_xsa));
        i_glob.vramhra -> nsaag_ysa = base;
        ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> nsaag_ysa));
        i_glob.vramhra -> saag_wxs = xstart << sizefactor;
        ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> saag_wxs));
        i_glob.vramhra -> saag_wxe = ( xend << sizefactor ) - 1;
        ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> saag_wxe));

        /* dummy read to complete previous cycle */
        dummy = i_glob.vramhra -> saag_wxe;

        while ( nleft )
            {
            if ( nleft > ( unsigned long )( I_SAAG_MAXC >> sizefactor ))
                count = I_SAAG_MAXC >> sizefactor;
            else
                count = ( unsigned short )nleft;

            nleft -= count;

            ptr.bptr = (char far *)i_glob.vrammap -> haa.cda;

#ifdef I_USE_ASM
/* use assembly language routine to speed up things */

			_i_s_movmem286 ( nptr.vptr, ptr.vptr, count, sizefactor );
            nptr.bptr += ( count << sizefactor );

#else
/* c code for cases where assembly cannot be used */

            switch ( sizefactor )
                {
                case 0 :
                    while ( count--)
                        *ptr.bptr++ = *nptr.bptr++;
                    break;

                case 1 :
                    while ( count--)
                        *ptr.wptr++ = *nptr.wptr++;
                    break;

                case 2 :
                    while ( count--)
                        *ptr.lptr++ = *nptr.lptr++;
                    break;

                default :
                    i_glob.ioerror = I_IOERR_SURF;
                    return (0);
                }

#endif

            } /* while */
        } /* else */

#endif

#endif /* PHAR_LAP */

    /* hstctll register bit 14 indicates a bus fault error */
    if ( i_glob.vramhra -> hstctll & 0x4000 )
        {
        /* reset bit */
        i_glob.vramhra -> hstctll &= 0xBFFF;

        /* return error message */
        i_glob.ioerror = I_IOERR_BUSERR;
        return (0);
        }

    /* otherwise, return success message */
    return (1);

} /* iowrfbarea () */
