/*
*
*    Standard PG/SM-1281 C binding library header.
*
*    COPYRIGHT (C) 1988, 1989, 1990, 1991  Matrox Electronic Systems Ltd.
*    All rights reserved
*
*/

#ifndef __I_DEF_H__
#define __I_DEF_H__

#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* System Parameters */

#define     NO          0
#define     FALSE       0

/* YES is defined for assignations only. One should never test for equality */
/* with YES. One should instead test for difference from 0.                 */

#define     YES         1

/* SHey 94/03/09 Changed for WATCOM compiler */
#if !defined(OK) 
 #define	OK	(0)
#else
 #if ((OK) != 0)
  #define OK (0)
 #endif
#endif


/* Pseudo-storage Classes */

/* to be used with intra-module objects */
#define     LOCAL       static

/* to be used for external references */
#define     IMPORT      extern

/* to be used for globally accessible objects */
#define     GLOBAL

/* to be used with functions passing parameters through registers */
#define     FASTPARM    register


/* Short Integers */

/* angle in degrees (or fraction of degrees) */
typedef     short       ANGLE;


/* to be used with objects being either null or non-null */
#if ! ( defined ( XIMG ) || defined ( I_OS2 ) || defined ( I_WINDOWS ) || defined ( __WINDOWS__ ))

typedef     unsigned short       BOOL;

#endif /* I_OS2 */

/* Floating Point Numbers */

/* fixed point 16.16 number */
typedef     float       FIXPT;


/* Screen Coordinates (physical coordinates) */

typedef  struct  Phcoord {
                 short  x;
                 short  y;
                 } PHCOORD;


/* 2D Virtual Coordinates */

typedef  struct V2coord {
                FIXPT  x;
                FIXPT  y;
                } V2COORD;


/* 3D Virtual Coordinates */

typedef  struct V3coord {
                FIXPT  x;
                FIXPT  y;
                FIXPT  z;
                } V3COORD;


/* 3D Virtual Coordinates with Intensity */

typedef  struct V3coordi {
                FIXPT  x;
                FIXPT  y;
                FIXPT  z;
                FIXPT  i;
                } V3COORDI;


/* 3D Virtual Coordinates Normalized */

typedef  struct V3coordn {
                FIXPT  x;
                FIXPT  y;
                FIXPT  z;
                FIXPT  nx;
                FIXPT  ny;
                FIXPT  nz;
                } V3COORDN;


/* Color Intensities */

typedef struct Lutval  {
                unsigned short  red;      /* red intensity */
                unsigned short  green;    /* green intensity */
                unsigned short  blue;     /* blue intensity */
                } LUTVAL;


/* Graphics Cursor Drawing Mode Specification */

typedef struct Gcattr {
                short  tdef1;        /* first pass transparency definition */
                short  mask1;        /* first pass write mask */
                short  fcol1;        /* first pass foreground color index */
                short  bcol1;        /* first pass background color index */
                short  bop1;         /* first pass boolean operator */
                short  tdef2;        /* second pass transparency definition */
                short  mask2;        /* second pass write mask */
                short  fcol2;        /* second pass foreground color index */
                short  bcol2;        /* second pass background color index */
                short  bop2;         /* second pass boolean operator */
                short  full_screen;  /* clipping flag */
                } GCATTR;


/* Font Specification */

typedef struct Font  {
                short  fmt;          /* character format:
                                        1 =  raster character.
                                        2 =  small stroke font.
                                        4 =  large stroke font.  */
                short  firstch;      /* first character code */
                short  lastch_off;   /* last character as offset
                                        from first character */
                short  replch_off;   /* replacement character as offset
                                        from first character */
                short  brkch_off;    /* word delimiter as offset
                                        from first character */
                short  width;        /* character width
                                        Null for proportional-spaced */
                short  height;       /* character height */
                short  pitch;        /* font pitch in words */
                short  nkpairs;      /* number of kerned pairs */
                short  ascent;       /* ascent distance (from bottom) */
                short  half;         /* half distance (from bottom) */
                short  base;         /* base distance (from bottom) */
                short  descent;      /* descent (from bottom) */
                short  _I_PTYPE *owtable;
                                     /* offset/width table address
                                        Null for mono-spaced, except for
                                        standard raster, in which case this
                                        is the power of two of the character
                                        width */
                short  _I_PTYPE *kerntable;
                                     /* pointer to kerning table */
                short  _I_PTYPE *data;        
                                     /* font data block address */
                } FONT;


/* Text Offset Table Entry */

typedef struct Owentry  { /* offset/width table entry */
                short  offset;       /* offset in font */
                short  width;        /* character width */
                } OWENTRY;


/* Kerned Pair Entry */

typedef struct Kpair  {
                short  firstch;      /* first character code of kerned pair */
                short  nextch;       /* last character code of kerned pair */
                short  amount;       /* kerning amount in pixels for this pair */
                } KPAIR;


/* Bit Maps */

typedef struct Bitmap  { /* arbitrary bitmap descriptor */
                unsigned short   w;      /* width in pixels */
                unsigned short   h;      /* height in pixels */
                unsigned short   pitch;  /* pitch in words */
                unsigned short   fmt;    /* format:
                                               8 LSBs: # bits/pixel
                                               8 MSBs: # of planes */
				    short   _I_PTYPE *tl;    /* pointer to top-left corner */
#if defined ( I_WINDOWS ) || defined ( __WINDOWS__ )
				} SHELLBITMAP;
#else
				} BITMAP;
#endif


/* Light Definition */

typedef  struct Light {
                FIXPT  amb;
                FIXPT  maxinte;
                FIXPT  dx;
                FIXPT  dy;
                FIXPT  dz;
                } LIGHT;


/* Utility Macros */

/* Find the size in words of X */

#define     SIZEWORDS(X)    (sizeof(X)/2)

/* Load the fractional and integer parts of a float into a buffer of words */

#define     LDFBUFF(PtrBuff, Float)  \
  {  unsigned long tmpVal; 			 \
     tmpVal = (unsigned long) ( (Float) * 65536.0 ); \
     *((unsigned short *)PtrBuff++) = (unsigned short) ( 0x0FFFF & tmpVal); \
     *((unsigned short *)PtrBuff++) = (unsigned short) ( tmpVal >> 16 ); \
  }

#endif /* __I_DEF_H__ */

