/*/
* enhance.c -- part of Image-1280 Windows 3.0 demo
*
* (c) Matrox Electronic Systems    November 1990
*
* This part of the filter demo implements the different filtering operations
* avaiilable.  filter calls enhance() with the current ROI coordinates (zoomed)
* and the selected filter.
*/

#include <windows.h>
#include "imseries.h"
#include "i_head.h"
#include "proto.h"
#include "enhance.h"
#include "filter.h"

enhance(x0, y0, x1, y1, filter)
short x0, y0, x1, y1, filter;
	{
	short nx0, ny0, nx1, ny1;

	pcstoverscan(I_TRANSPARENT,0);

	// roi coordinates are zoomed
	nx0 = x0 >> 1;
	ny0 = y0 >> 1;
	nx1 = x1 >> 1;
	ny1 = y1 >> 1;

	pcstroipos(I_ROI0, nx0, ny0);
	pcstroipos(I_ROI2, x0, y0);    // zoomed image !!!
	pcstroisiz(nx1 - nx0 + 1, ny1 - ny0 + 1);

	switch (filter)
		{
		case IDM_PREWITT:
			nbdomconv(I_FB1 | I_ROI0, I_FB1 | I_ROI1, I_NO_BUF,
				I_APP_PREWITT, I_OVERWRITE);
			break;
		case IDM_SHARP1:
			nbdoconv(I_FB1 | I_ROI0, I_FB1 | I_ROI1,  I_NO_BUF,
				I_SHARP1, I_OVERWRITE, 0);
			break;
		case IDM_HOREDGE:
			nbdoconv(I_FB1 | I_ROI0, I_FB1 | I_ROI1, I_NO_BUF,
			 I_HOREDGE, I_OVERWRITE, 0);
			break;
		case IDM_MORPHGRAD:
			nbdomconv(I_FB1 | I_ROI0,I_FB1 | I_ROI1, I_NO_BUF,
				I_MORPHGRAD, I_OVERWRITE);
			break;
		case IDM_VERTEDGE:
			nbdoconv(I_FB1 | I_ROI0, I_FB1 | I_ROI1, I_NO_BUF,
			 I_VERTEDGE, I_OVERWRITE, 0);
			break;
		case IDM_SOBEL:
			nbdomconv(I_FB1 | I_ROI0, I_FB1 | I_ROI1, I_NO_BUF, 
				I_APP_SOBEL, I_OVERWRITE);
			break;
		}

	pcstroisiz(x1 - x0, y1 - y0);
	fbcpbtob( I_FB1 | I_ROI1, I_FB0 | I_ROI2, 0L, 0L, 2);
	} // end of enhance

enhance_init()
	{
	short i;

	proc_init();                          // processing initialization

	lsdcstopal(3);
	lsdcstmsbsource( I_VDO_FBPAL );

	pcstroisiz( 512, 480 );
	pcstroipos(I_ROI0, 0, 0 );
	pcstroipos(I_ROI1, 0, 512 );
	pcstroipos(I_ROI2, 512, 0 );
	pcstroipos(I_ROI3, 512, 512 );

	pcstroisiz(1024, 960);

	for (i = 0; i < 10000; ++i)
		;

//	fbcpbtob( I_FB1 | I_ROI0, I_FB0 | I_ROI0, 0L, 0L, 2 ); // zoom it by 2
	} // enhance_init

proc_init()
	{
	short i;

	pcstbinarize(I_SRC1,0xffff,I_DONT_BINARIZE,0);
	pcstbinarize(I_SRC2,0xffff,I_DONT_BINARIZE,0);
	pcslsync(I_PROC_ALONE);
	pcstcond(0, I_FOR, 1);

	// pcslsync( I_PROC_DISP );
	pcstoverscan( I_REPLACE, 0 );          
	pcstformat( I_UNSIGNED_8, I_UNSIGNED_8, I_UNSIGNED_8 );
	pcstsrcmsk( I_SRC1, 0xffff );          
	pcstsrcmsk( I_SRC2, 0xffff );
	pcstdstmsk( 0xffffffffL );                  
	pcstlattice( I_RECT );
	pcstooi( I_FB0,0xffff,255,I_EVERYWHERE );

	for (i = 0; i < 10000; ++i)
		;
	} // proc_init

display_init()
	{
	short i;
	long value;

	// display lookup table
	utlmgnlut(3L, 0xfff20000L , 256L, 3L );  // palette # 3, 100 elements

	// enhance lookup table #2
	for( i = 0; i < 4; i++ )
		{
		utlmgnlut(  0L, 0xfff20200L | (long)i, 1L, 0L );
		}

	for( i = 4, value = 0L; i < 100; i++,value += 2L )
		{
		utlmgnlut( value, 0xfff20200L | (long)i , 1L, 0L );
		}

	for( i = 100 ; i < 256; i++, value++ )
		{
		if( value > 255L )
			value = 255L;

		utlmgnlut( value, 0xfff20200L | (long)i , 1L, 0L );
		}
	} // display_init

restore_palette()
	{
  	utlmgnlut(0L, 0xfff20100L, 256L, 0L);
  	utlmgnlut(0L, 0xfff20200L, 256L, 0L);
  	utlmgnlut(0L, 0xfff20300L, 256L, 0L);
	} // resotre_palette

restore()
	{

	pcstroisiz( 1024, 960 );
	pcstroipos(I_ROI0, 0, 0 );
	fbcpbtob(I_FB1 | I_ROI0, I_FB0 | I_ROI0, 0L, 0L, 2);
	} // restore
