/*/  Function name:  lsrlrdrst
*
*    Note:  The user must be sure that the read fifo is empty before sending
*           that command.
*
*    Author:   Jean Dupre
*    Date:     Feb 15, 1988
*
*    Modification history:  
*
*					Andre Allore	March 7/1989
*										use "iogetu()" to get an unsigned
*					short and avoid sign extension when typecasting as an
*              (unsigned long).
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*            iogetbuf:  get a buffer of words from the board.
*				   iogetu:  get an unsigned short from the board.
*
*    Uses:  None
*
*    Return value:  None
*/


#include  <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#define   TEMPBUFFSIZE   1024
/*        Size of a disk cluster, 1024Kwords or 2048Kbytes */

IMPORT unsigned short  tempbuff[];
/*        This buffer is also declared in lsrdrst() */

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE lsrlrdrst(short left, short top, short right, short bottom,
                     char _I_PTYPE *dest_filename)
#else
FTYPE lsrlrdrst(left, top, right, bottom, dest_filename)
short  left, top, right, bottom;
char  _I_PTYPE *dest_filename;
#endif

    {
    FILE    _I_PTYPE *fpw;                          /* Output file pointer */
    unsigned long  length;
    unsigned short  numwrite;

    ptrbuff = buff;

    *ptrbuff++ = 0x0037;
    *ptrbuff++ = left;
    *ptrbuff++ = top;
    *ptrbuff++ = right;
    *ptrbuff = bottom;

    ioputbuf(buff, 5);

    length = (unsigned long) ((unsigned short)iogetw());
    length += (unsigned long) (((unsigned short)iogetw()) << 16);

    fpw = fopen(dest_filename, "wb");

    while (length)
        {
        if (length > TEMPBUFFSIZE)
            {
            numwrite = TEMPBUFFSIZE;
            length -= TEMPBUFFSIZE;
            }
        else
            {
            numwrite = (unsigned short) length;
            length = 0;
            }

        iogetbuf((short *) tempbuff, numwrite);

        fwrite((char *)tempbuff, sizeof(short), numwrite, fpw);
        }

    fclose(fpw);
    }


