/*/
*   KAF4200F.C
*
*   ImInit Image-Series Utility Ver: 0.57beta
*   Copyright (C) 1992, 1993.  Matrox Electronic Systems Ltd.
*
*   Date:   Thu Apr 29 1993
*   Time:   10:50:38
*
*   Target board: ASD Normal
*   Camera Type: RS170A Monochrome, CONTINUOUS grab.
*   Resolution: 2048H x 2048V
*   Pixel clock rate: 10.000 MHz
*
*   Target camera:  Kodak KAF-4200
*
*   Camera mode:    Mode #6:  Free Running Single Line Readout mode.
*
*   Electrical interface:
*
* Signal       KAF-4200 DB-15   KAF-4200 BNC     IM-ASD/AT 50     IM-ASD/AT DB9
* Name         sync connector   VIDEO output A   pin RS422 port   Analog input
* ======       ==============   ==============   ============     =============
*
* Pixel Clock+       1  22
* Pixel Clock-       9  47
* Line Rate V+       2  19
* Line Rate V-      10  44
* Frame Data V+      3  20
* Frame Data V-     11  45
* Common             8  18
*                                                43
* VIDEO A                            CENTER  1
* AGND                               SHIELD  6
*
**/

#include "llashead.h"   /* Contains all defines used as parameters   */
#include "camera.h"     /* Contains camera structure definition      */
#include "i_head.h"

#define PIXELCLK  10.000              /* pixel clock frequency in MHz      */

#define DIGPIXCLK PIXELCLK * 1000     /* digitizer pixel clock in kHz      */

/* US_TO_PIX() macro can be used to specify horizontal timing in usec      */
/* instead of in number of pixels.                                         */
/* US_TO_PIX() should be used when no clock signal is included in the      */
/* camera-to-digitizer interface.                                          */

#define US_TO_PIX(p) (p)*PIXELCLK+0.5 /* macro definition that converts    */
                                      /* a usec value to a nb. of pixels.  */

CAMERA kaf4200f = {

/* ------------------------ BASIC INFORMATION ----------------------------*/

        ASD_NORMAL,     /* target_board:                                */
                        /* logical camera format id                     */
                        /* #defines : ASD_NORMAL : Normal ASD (IM-ASD)  */
                        /*            ASD_H : High resolution ASD       */
                        /*                    (IM-ASD/H)                */

                 0,     /* hdigcomp:                      */
                        /* horizontal compensation factor */

       PROGRESSIVE,     /* scan_mode:                          */
                        /* scan mode                           */
                        /* #defines: INTERLACED, PROGRESSIVE   */
                        /*           LINEGRAB                  */

         NEXTFIELD,     /* start_field:                                    */
                        /* start field                                     */
                        /* #defines: STARTNEXTFD (do not use), STARTEVENFD,*/
                        /*           NEXTFIELD, EVERYFD (obsolete),        */
                        /*           STARTODDFD, EVENFIELD (do not use),   */
                        /*           ODDFIELD (do not use)                 */

         DIGPIXCLK,     /* pixclk: Digitizer pixel clock                   */
                        /*         This parameter is defined using         */
                        /*         DIGPIXCLK.                              */

       ADR_HRES_ON,     /* adr_hres:                              */
                        /* adr hreset                             */
                        /* H defines: ADR_HRES_ON, ADR_HRES_OFF   */

       ADR_VRES_ON,     /* adr_vres:                              */
                        /* adr hreset                             */
                        /* H defines: ADR_VRES_ON, ADR_VRES_OFF   */

/*--------------------------- TIMING SECTION ------------------------------*/

                 0,     /* vblnkw:                 */
                        /* vertical blanking width */

               260,     /* hblnkw:                    */
                        /* horizontal blanking width  */

  2048 /* 0x800 */,     /* vtotal:        */
                        /* vertical total */

  2303 /* 0x8ff */,     /* htotal:          */
                        /* horizontal total */

                 1,     /* hsync:                  */
                        /* horizontal sync width   */

             DUMMY,     /* psg_htotal:       */
                        /* PSG-1024 htotal   */
                        /* value or DUMMY    */

  2048 /* 0x800 */,     /* roi_hmax:            */
                        /* ROI maximum width    */

                 1,     /* vsync:               */
                        /* vertical sync width  */

             DUMMY,     /* psg_vtotal:       */
                        /* PSG-1024 vtotal   */
                        /* value or DUMMY    */

  2048 /* 0x800 */,     /* roi_vmax:            */
                        /* ROI maximum height   */

/*-----------------------  CLAMPING TIMING SECTION ------------------------*/

     80 /* 0x50 */,     /* hsclmp:                 */
                        /* horizontal start clamp  */
                        /* value or DUMMY          */

     80 /* 0x50 */,     /* clmpwidth:           */
                        /* clamping pulse width */
                        /* value or DUMMY       */

/*-------------------- PROGRAMMABLE TIMER SECTION -------------------------*/

             DUMMY,     /* trigger:                                  */
                        /* programmable timer mode                   */
                        /* H defines: HARDTRIG, TIMEBASETRIG, DUMMY  */
                        /*            SOFTTRIG                       */

             DUMMY,     /* exposure:      */
                        /* exposure time  */
                        /* value or DUMMY */

             DUMMY,     /* transfer:      */
                        /* transfer time  */
                        /* value or DUMMY */

/*-------------------------- ASD MODE SECTION -----------------------------*/

        FRAME_SCAN,     /* monoshot_mode:                                  */
                        /* PSG-1024 and ASD mode                           */
                        /* H defines : NO_MONOSHOT, NO_MONOSHOT_NIL,       */
                        /*             NO_MONOSHOT_MASTER, LINE_SCAN,      */
                        /*             FRAME_SCAN                          */

             DUMMY,     /* intl_frame_scan:                                */
                        /* monoshot single-field frame scan                */
                        /* H defines : INTL_FD_SCAN, INTL_FRAME_SCAN,      */
                        /*             DUMMY                               */

/*----------------- SYNCHRONISATION INTERFACE SECTION ---------------------*/

             DUMMY,     /* csync_fmt:                                      */
                        /* PSG-1024 output composite sync format           */
                        /* H defines : BLOCKSYNC, SERRTSYNC, SEREQUSYNC,   */
                        /*             DUMMY                               */

        RS422SYINT,     /* interface:                                      */
                        /* synchronization interface                       */
                        /* H defines: ANALOGSYINT, TTLSYINT, RS422SYINT,   */
                        /*            TTLINRSOUTSYINT, RSINTTLOUTSYINT,    */
                        /*            ANAINTTLOUTSYINT, ANAINRSOUTSYINT    */

            INT_IN,     /* int_dir:                            */
                        /* synchronization direction           */
                        /* H defines: INT_IN, INT_OUT, DUMMY   */

            HVSYNC,     /* sep_sync:                        */
                        /* digital interface sync. format   */
                        /* H defines: CSYNC, HVSYNC, DUMMY  */

             DUMMY,     /* sync_chan:                                      */
                        /* analog sync. channel                            */
                        /* H defines: CH0SYNC, CH1SYNC, CH2SYNC, CH3SYNC,  */
                        /*            DUMMY                                */

        PSGEXTSYNC,     /* psgmode:                            */
                        /* PSG-1024  mode                      */
                        /* H defines: PSGINTSYNC, PSGEXTSYNC   */

             DUMMY,     /* psghres:                            */
                        /* enable PSG-1024 input hreset        */
                        /* H defines: ENHRES, DISHRES, DUMMY   */

           LOSYPOL,     /* sync_pol:                                     */
                        /* sync. signal polarities                       */
                        /* 0 = low going edge                            */
                        /* 1 = high going edge                           */
                        /*       bit 0 : ASD input hsync polarity        */
                        /*       bit 1 : ASD input vsync polarity        */
                        /*       bit 2 : ASD input csync polarity        */
                        /*       bit 3 : ASD output hsync polarity       */
                        /*       bit 4 : ASD output vsync polarity       */
                        /*       bit 5 : ASD output csync polarity       */
                        /*       bit 6 : PSG-1024 input hreset polarity  */
                        /*       bit 7 : PSG-1024 input vreset polarity  */
                        /*       bit 8 : PSG-1024 output hsync           */
                        /*       bit 9 : PSG-1024 output vsync           */
                        /* H defines: HISYPOL : 0xbf                     */
                        /*            LOSYPOL : 0x80 (RS170/CCIR)        */

/*--------------------------- CLOCK SECTION -------------------------------*/

   DIRECT_EXTCLKIN,     /* clk_src:                                        */
                        /* clock source                                    */
                        /* H defines: PLLCLK, USERCLK, EBICLK,             */
                        /*            DIRECT_EXTCLKIN, EXTCLK,             */
                        /*            USERCLKOUT_EXTCLKIN,                 */
                        /*            EBICLKOUT_EXTCLKIN                   */

              DIV1,     /* div_fact:                           */
                        /* PSG-1024 clock division factor      */
                        /* H defines: DIV1, DIV2, DIV4, DIV8   */

        RS422CLKIN,     /* in_clk:                                   */
                        /* Enable digital input clock interface      */
                        /* H defines : RS422CLKIN, TTLCLKIN, NOCLKIN */

          NOCLKOUT,     /* out_clk:                                     */
                        /* Enable digital output clock and exposure     */
                        /* signal interface.                            */
                        /* H defines : RS422CLKOUT, TTLCLKOUT, NOCLKOUT */

   INCLK_HIGH_EDGE,     /* in_clk_pol:                                  */
                        /* PSG-1024 clock polarity.                     */
                        /* H defines: INCLK_HIGH_EDGE, INCLK_LOW_EDGE   */

/*------------------------- DATA PATH SECTION -----------------------------*/

          ANALOGDT,     /* data_src:                           */
                        /* Enable data interface               */
                        /* H defines: ANALOGDT, RS422DT, TTLDT */

            CH0DIG,     /* chsrc:                                       */
                        /* Analog data channel select                   */
                        /* H defines: CH0DIG, CH1DIG, CH2DIG, CH3DIG,   */
                        /*            DUMMY                             */

             DUMMY,     /* buswidth:                           */
                        /* Digital data format select          */
                        /* H_defines: W8BITS, W16BITS, DUMMY   */

          MSK8BITS,     /* mask:                                        */
                        /* Iluts address bits coming from digital data. */
                        /* H_defines: MSK8BITS, MSK9BITS, MSK10BITS,    */
                        /*            MSK11BITS, MSK12BITS              */

                 0,     /* palette:                                        */
                        /* Lut initial palette number ranging from 0 to 15.*/

/*----------------------- GAIN, REFERENCES SECTION ------------------------*/

           GN_2_10,     /* gain:                                           */
                        /* Analog initial video gain select.               */
                        /* H defines: GN_3_15, GN_2_10, GN_1_40, GN_0_93,  */
                        /*            DUMMY                                */

     44 /* 0x2c */,     /* refplus0:   ref1+ ranging from 0 to 63          */
      13 /* 0xd */,     /* repminus0:  ref1- ranging from 0 to 63          */

             DUMMY,     /* refplus1:   H_defines: DUMMY                    */
             DUMMY,     /* refminus1:  H_defines: DUMMY                    */

             DUMMY,     /* refplus2:   H_defines: DUMMY                    */
             DUMMY,     /* refminus2:  H_defines: DUMMY                    */

/*--------------------------- OTHER SECTION -------------------------------*/

          USER1_HI,     /* user1:                                 */
                        /* Initial TTL user1 bit level            */
                        /* H defines: USER1_HI, USER1_LO, DUMMY   */

         PSG_VSYNC,     /* vsyncsel:                        */
                        /* ADR-1024 vsync select            */
                        /* H defines: PSG_VSYNC, CAM_VSYNC  */

             DUMMY,     /* sethcnt:                      */
                        /* PSG-1024 preset hcount value  */
                        /* value or DUMMY                */

             DUMMY,     /* setvcnt:                      */
                        /* PSG-1024 preset vcount value  */
                        /* value or DUMMY                */

        };


