/*
 * Decompiled with CFR 0.152.
 */
import com.symbios.jxdr.JRPCClient;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamTokenizer;

public class SystemData {
    String hostName;
    int rpcType;
    String proxyServer;
    int proxyPort = 6301;
    int handle;
    public JRPCClient clnt;
    int connected;
    int registered;
    int connectOk;
    int quit;
    int tvErr;
    int cid;
    String[] machineName = new String[8];
    int[] machineRpcType = new int[8];
    String protocol = "tcp";
    int num_machines;
    int soTimeout = 5;
    public static final int SO_TIMEOUT = 5;
    public static final int DMI_RPC_NUMBER = 300598;
    public static final int DMI_RPC_VERSION = 1;
    public static final int MAX_MACHINES = 8;
    public static final String INI_FILE = "storDMI.ini";
    public static final int PROXY_PORT = 6301;

    public void reset_data() {
        this.rpcType = 0;
        this.handle = 0;
        this.connected = 0;
        this.registered = 0;
        this.connectOk = 0;
        this.quit = 0;
        this.tvErr = 0;
        this.protocol = "tcp";
        this.soTimeout = 5;
    }

    public void readInitValue(String string) throws FileNotFoundException, IOException, BadFileException {
        FileInputStream fileInputStream = new FileInputStream(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(fileInputStream);
        streamTokenizer.commentChar(35);
        streamTokenizer.commentChar(91);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChar(61);
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3) continue;
            if (streamTokenizer.sval.compareTo("ProxyServer") == 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new BadFileException();
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 10) {
                    throw new BadFileException();
                }
                this.proxyServer = streamTokenizer.sval;
            } else if (streamTokenizer.sval.compareTo("ProxyPort") == 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new BadFileException();
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    throw new BadFileException();
                }
                this.proxyPort = (int)streamTokenizer.nval;
            } else if (streamTokenizer.sval.compareTo("Protocol") == 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new BadFileException();
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 10) {
                    throw new BadFileException();
                }
                this.protocol = streamTokenizer.sval;
            } else if (streamTokenizer.sval.compareTo("SocketTimeout") == 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new BadFileException();
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    throw new BadFileException();
                }
                this.soTimeout = (int)streamTokenizer.nval;
            } else if (streamTokenizer.sval.compareTo("Machine") == 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new BadFileException();
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 10) {
                    throw new BadFileException();
                }
                ++this.num_machines;
                this.machineName[this.num_machines - 1] = streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    throw new BadFileException();
                }
                if ((int)streamTokenizer.nval == 0) {
                    this.machineRpcType[this.num_machines - 1] = 0;
                } else if ((int)streamTokenizer.nval == 1) {
                    this.machineRpcType[this.num_machines - 1] = 1;
                } else {
                    throw new BadFileException();
                }
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 10 || streamTokenizer.ttype == -1) continue;
            throw new BadFileException();
        }
        return;
    }

    public void writeInitValue(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        String string2 = "##############################################################################\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# Do not edit this file - changes made will be lost                          #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# This file was automatically generated by the LSI DMI Browser               #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# ProxyServer  : Internet Name or Address of the Windows NT machine          #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                configured to run the LSI DCE Proxy Service                 #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# ProxyPort    : TCP Port of the Proxy Service                               #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# Protocol     : Protocol for RPC calls (\"tcp\" or \"udp\")                     #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# SocketTimeout: Socket Timeout in seconds after which to toss an            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                IO Exception.                                               #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "# Machine      : Recently Managed Machine Name, RPCType (DCE=0, ONC=1)       #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "#                                                                            #\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "##############################################################################\r\n\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "[DCE Proxy]\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "ProxyServer = \"" + this.proxyServer + "\"" + "\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "ProxyPort = " + this.proxyPort + "\r\n\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "[TCP/IP]\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "Protocol = " + this.protocol + "\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "SocketTimeout = " + this.soTimeout + "\r\n\r\n";
        dataOutputStream.writeBytes(string2);
        string2 = "[Machines]\r\n";
        dataOutputStream.writeBytes(string2);
        int n = 0;
        while (n < this.num_machines) {
            string2 = "Machine = \"" + this.machineName[n] + "\"" + " " + this.machineRpcType[n] + "\r\n";
            dataOutputStream.writeBytes(string2);
            ++n;
        }
        fileOutputStream.close();
        return;
    }

    public int readCmdLineValues(AppletData appletData) {
        int n = 0;
        if (appletData == null) {
            return 1;
        }
        this.proxyServer = appletData.proxyServer;
        this.proxyPort = appletData.proxyPort;
        this.protocol = appletData.protocol;
        this.soTimeout = appletData.socketTimeout;
        this.hostName = appletData.machineName;
        if (this.hostName == null) {
            n = 1;
        }
        if (appletData.rpcType != null) {
            if (appletData.rpcType.equalsIgnoreCase("dce")) {
                this.rpcType = 0;
            } else if (appletData.rpcType.equalsIgnoreCase("onc")) {
                this.rpcType = 1;
            } else {
                n = 1;
                this.rpcType = 2;
            }
        }
        if (this.rpcType == 0 && (this.proxyServer == null || this.proxyPort == 0)) {
            n = 1;
        }
        if (this.protocol == null) {
            this.protocol = "tcp";
        }
        if (this.soTimeout == 0) {
            this.soTimeout = 5;
        }
        return n;
    }

    public class BadFileException
    extends Exception {
        BadFileException() {
            super("storDMI.ini file is corrupted");
            SystemData.this = SystemData.this;
        }
    }
}

