/*
 * Decompiled with CFR 0.152.
 */
package com.symbios.jxdr;

public class JxdrStream {
    protected byte[] buffer;
    protected int inPos;
    protected int outPos;
    protected int length;

    public JxdrStream() {
        this.Init();
    }

    public void SmallInit() {
        this.buffer = new byte[2048];
        this.length = 2048;
        this.inPos = 0;
        this.outPos = 0;
    }

    public void Init() {
        this.buffer = new byte[8192];
        this.length = 8192;
        this.inPos = 0;
        this.outPos = 0;
    }

    public void BigInit() {
        this.buffer = new byte[8192];
        this.length = 8192;
        this.inPos = 0;
        this.outPos = 0;
    }

    public void putData(byte[] byArray, int n) {
        if (this.inPos + n > this.length) {
            byte[] byArray2 = this.buffer;
            int n2 = n - this.length + 255;
            this.length += (n2 &= 0xFFFFFF00);
            this.buffer = new byte[this.length];
            System.arraycopy(byArray2, 0, this.buffer, 0, byArray2.length);
            this.inPos += byArray2.length;
        }
        System.arraycopy(byArray, 0, this.buffer, this.inPos, n);
        this.inPos += n;
    }

    public void putInt64(long l) {
        this.buffer[this.inPos++] = (byte)(l >> 56 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 48 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 40 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 32 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 24 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 16 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l >> 8 & 0xFFL);
        this.buffer[this.inPos++] = (byte)(l & 0xFFL);
    }

    public void putInt32(int n) {
        this.buffer[this.inPos++] = (byte)(n >> 24 & 0xFF);
        this.buffer[this.inPos++] = (byte)(n >> 16 & 0xFF);
        this.buffer[this.inPos++] = (byte)(n >> 8 & 0xFF);
        this.buffer[this.inPos++] = (byte)(n & 0xFF);
    }

    public void putInt16(short s) {
        this.buffer[this.inPos++] = (byte)(s >> 8 & 0xFF);
        this.buffer[this.inPos++] = (byte)(s & 0xFF);
    }

    public void putInt8(byte by) {
        this.buffer[this.inPos++] = by;
    }

    public void putChar(char c) {
        this.buffer[this.inPos++] = (byte)(c >> 24 & 0xFF);
        this.buffer[this.inPos++] = (byte)(c >> 16 & 0xFF);
        this.buffer[this.inPos++] = (byte)(c >> 8 & 0xFF);
        this.buffer[this.inPos++] = (byte)(c & 0xFF);
    }

    public void putString(String string) {
        int n = string.length();
        this.putInt32(n);
        int n2 = 0;
        while (n2 < n) {
            this.putChar(string.charAt(n2));
            ++n2;
        }
    }

    public void putRaw(byte[] byArray) {
        int n = byArray.length;
        this.putInt32(n);
        System.arraycopy(byArray, 0, this.buffer, this.inPos, n);
        this.inPos += n;
        int n2 = n % 4;
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < 4 - n2) {
                this.putInt8((byte)0);
                ++n3;
            }
        }
    }

    public long getInt64() {
        long l = 0L;
        int n = 4;
        while (n <= 7) {
            l += (long)(this.buffer[this.outPos + n] & 0xFF);
            l <<= 8;
            n = (short)(n + 1);
        }
        n = 0;
        while (n < 3) {
            l += (long)(this.buffer[this.outPos + n] & 0xFF);
            l <<= 8;
            n = (short)(n + 1);
        }
        this.outPos += 8;
        return l += (long)(this.buffer[this.outPos + 3] & 0xFF);
    }

    public int getInt32() {
        int n = 0;
        n = this.buffer[this.outPos++] & 0xFF;
        int n2 = 3;
        while (n2 > 0) {
            n <<= 8;
            n += this.buffer[this.outPos++] & 0xFF;
            n2 = (short)(n2 - 1);
        }
        return n;
    }

    public short getInt16() {
        short s = this.buffer[this.outPos++];
        s = (short)(s << 8);
        s = (short)(s + (this.buffer[this.outPos++] & 0xFF));
        return s;
    }

    public byte getInt8() {
        return this.buffer[this.outPos++];
    }

    public char getChar() {
        int n = this.buffer[this.outPos++] & 0xFF;
        int n2 = 3;
        while (n2 > 0) {
            n <<= 8;
            n += this.buffer[this.outPos++] & 0xFF;
            --n2;
        }
        char c = (char)n;
        return c;
    }

    public String getString() {
        int n = this.getInt32();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = this.getChar();
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public byte[] getRaw() {
        int n = this.getInt32();
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.outPos, byArray, 0, n);
        this.outPos += n;
        int n2 = 0;
        while (n2 < n % 4) {
            this.getInt8();
            ++n2;
        }
        return byArray;
    }

    public void printLine() {
        int n = 0;
        while (n < this.inPos) {
            System.out.print(String.valueOf(this.buffer[n]) + " ");
            ++n;
        }
    }

    public void fixHeaderLength() {
        int n = this.inPos;
        this.buffer[2] = (byte)(n >> 24 & 0xFF);
        this.buffer[3] = (byte)(n >> 16 & 0xFF);
        this.buffer[4] = (byte)(n >> 8 & 0xFF);
        this.buffer[5] = (byte)(n & 0xFF);
    }
}

