/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

public class Introspector {
    private BeanInfo informant;
    private boolean propertyChangeSource = false;
    private Class beanClass;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private static Hashtable beanInfoCache = new Hashtable();
    private static Class eventListenerType = class$java$util$EventListener != null ? class$java$util$EventListener : (class$java$util$EventListener = Introspector.class$("java.util.EventListener"));
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Hashtable methods = new Hashtable();
    private static Hashtable declaredMethodCache;
    private Hashtable properties = new Hashtable();
    private Hashtable events = new Hashtable();
    private static String[] searchPath;
    static /* synthetic */ Class class$java$util$EventListener;
    static /* synthetic */ Class class$java$beans$PropertyVetoException;
    static /* synthetic */ Class class$java$util$TooManyListenersException;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        BeanInfo bi = (BeanInfo)beanInfoCache.get(beanClass);
        if (bi == null) {
            bi = new Introspector(beanClass, null).getBeanInfo();
            beanInfoCache.put(beanClass, bi);
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class beanClass, Class stopClass) throws IntrospectionException {
        return new Introspector(beanClass, stopClass).getBeanInfo();
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String[] getBeanInfoSearchPath() {
        return searchPath;
    }

    public static void setBeanInfoSearchPath(String[] path) {
        searchPath = path;
    }

    private Introspector(Class beanClass, Class stopClass) throws IntrospectionException {
        this.beanClass = beanClass;
        if (stopClass != null) {
            boolean isSuper = false;
            Class c = beanClass.getSuperclass();
            while (c != null) {
                if (c == stopClass) {
                    isSuper = true;
                }
                c = c.getSuperclass();
            }
            if (!isSuper) {
                throw new IntrospectionException(String.valueOf(stopClass.getName()) + " not superclass of " + beanClass.getName());
            }
        }
        this.informant = this.findInformant(beanClass);
        if (beanClass.getSuperclass() != stopClass) {
            this.superBeanInfo = stopClass == null ? Introspector.getBeanInfo(beanClass.getSuperclass()) : Introspector.getBeanInfo(beanClass.getSuperclass(), stopClass);
        }
        if (this.informant != null) {
            this.additionalBeanInfo = this.informant.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor bd = this.getTargetBeanDescriptor();
        EventSetDescriptor[] esds = this.getTargetEventInfo();
        int defaultEvent = this.getTargetDefaultEventIndex();
        PropertyDescriptor[] pds = this.getTargetPropertyInfo();
        int defaultProperty = this.getTargetDefaultPropertyIndex();
        MethodDescriptor[] mds = this.getTargetMethodInfo();
        return new GenericBeanInfo(bd, esds, defaultEvent, pds, defaultProperty, mds, this.informant);
    }

    /*
     * Unable to fully structure code
     */
    private BeanInfo findInformant(Class beanClass) {
        name = String.valueOf(beanClass.getName()) + "BeanInfo";
        try {
            return (BeanInfo)Introspector.instantiate(beanClass, name);
        }
        catch (Exception v0) {
            ** while (name.indexOf((int)46) > 0)
        }
lbl-1000:
        // 1 sources

        {
            name = name.substring(name.indexOf(46) + 1);
            continue;
        }
lbl8:
        // 1 sources

        i = 0;
        while (i < Introspector.searchPath.length) {
            try {
                fullName = String.valueOf(Introspector.searchPath[i]) + "." + name;
                return (BeanInfo)Introspector.instantiate(beanClass, fullName);
            }
            catch (Exception v1) {
                ++i;
            }
        }
        return null;
    }

    private PropertyDescriptor[] getTargetPropertyInfo() throws IntrospectionException {
        PropertyDescriptor[] explicit = null;
        if (this.informant != null) {
            explicit = this.informant.getPropertyDescriptors();
            int ix = this.informant.getDefaultPropertyIndex();
            if (ix >= 0 && ix < explicit.length) {
                this.defaultPropertyName = explicit[ix].getName();
            }
        }
        if (explicit == null && this.superBeanInfo != null) {
            PropertyDescriptor[] supers = this.superBeanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addProperty(supers[i]);
                ++i;
            }
            int ix = this.superBeanInfo.getDefaultPropertyIndex();
            if (ix >= 0 && ix < supers.length) {
                this.defaultPropertyName = supers[ix].getName();
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            PropertyDescriptor[] additional = this.additionalBeanInfo[i].getPropertyDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addProperty(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicit != null) {
            int i2 = 0;
            while (i2 < explicit.length) {
                this.addProperty(explicit[i2]);
                ++i2;
            }
        } else {
            Method[] methodList = Introspector.getDeclaredMethods(this.beanClass);
            int i3 = 0;
            while (i3 < methodList.length) {
                Method method = methodList[i3];
                int mods = method.getModifiers();
                if (!Modifier.isStatic(mods) && Modifier.isPublic(mods)) {
                    String name = method.getName();
                    Class<?>[] argTypes = method.getParameterTypes();
                    Class<?> resultType = method.getReturnType();
                    int argCount = argTypes.length;
                    PropertyDescriptor pd = null;
                    try {
                        if (argCount == 0) {
                            if (name.startsWith("get")) {
                                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), method, null);
                            } else if (resultType == Boolean.TYPE && name.startsWith("is")) {
                                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(2)), method, null);
                            }
                        } else if (argCount == 1) {
                            if (argTypes[0] == Integer.TYPE && name.startsWith("get")) {
                                pd = new IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, method, null);
                            } else if (resultType == Void.TYPE && name.startsWith("set")) {
                                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, method);
                                if (this.throwsException(method, class$java$beans$PropertyVetoException != null ? class$java$beans$PropertyVetoException : Introspector.class$("java.beans.PropertyVetoException"))) {
                                    pd.setConstrained(true);
                                }
                            }
                        } else if (argCount == 2 && argTypes[0] == Integer.TYPE && name.startsWith("set")) {
                            pd = new IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, null, method);
                            if (this.throwsException(method, class$java$beans$PropertyVetoException != null ? class$java$beans$PropertyVetoException : Introspector.class$("java.beans.PropertyVetoException"))) {
                                pd.setConstrained(true);
                            }
                        }
                    }
                    catch (IntrospectionException introspectionException) {
                        pd = null;
                    }
                    if (pd != null) {
                        if (this.propertyChangeSource) {
                            pd.setBound(true);
                        }
                        this.addProperty(pd);
                    }
                }
                ++i3;
            }
        }
        PropertyDescriptor[] result = new PropertyDescriptor[this.properties.size()];
        Enumeration elements = this.properties.elements();
        int i4 = 0;
        while (i4 < result.length) {
            result[i4] = (PropertyDescriptor)elements.nextElement();
            if (this.defaultPropertyName != null && this.defaultPropertyName.equals(result[i4].getName())) {
                this.defaultPropertyIndex = i4;
            }
            ++i4;
        }
        return result;
    }

    void addProperty(PropertyDescriptor pd) {
        String name = pd.getName();
        PropertyDescriptor old = (PropertyDescriptor)this.properties.get(name);
        if (old == null) {
            this.properties.put(name, pd);
            return;
        }
        Class<?> opd = old.getPropertyType();
        Class<?> npd = pd.getPropertyType();
        if (opd != null && npd != null && opd != npd) {
            this.properties.put(name, pd);
            return;
        }
        PropertyDescriptor composite = old instanceof IndexedPropertyDescriptor || pd instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor(old, pd) : new PropertyDescriptor(old, pd);
        this.properties.put(name, composite);
    }

    /*
     * WARNING - void declaration
     */
    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        void var5_13;
        EventSetDescriptor[] explicit = null;
        if (this.informant != null) {
            explicit = this.informant.getEventSetDescriptors();
            int ix = this.informant.getDefaultEventIndex();
            if (ix >= 0 && ix < explicit.length) {
                this.defaultEventName = explicit[ix].getName();
            }
        }
        if (explicit == null && this.superBeanInfo != null) {
            EventSetDescriptor[] supers = this.superBeanInfo.getEventSetDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addEvent(supers[i]);
                ++i;
            }
            int ix = this.superBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < supers.length) {
                this.defaultEventName = supers[ix].getName();
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            EventSetDescriptor[] additional = this.additionalBeanInfo[i].getEventSetDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addEvent(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicit != null) {
            int i2 = 0;
            while (i2 < explicit.length) {
                this.addEvent(explicit[i2]);
                ++i2;
            }
        } else {
            Method[] methodList = Introspector.getDeclaredMethods(this.beanClass);
            Hashtable<String, Method> adds = new Hashtable<String, Method>();
            Hashtable<String, Method> removes = new Hashtable<String, Method>();
            int i3 = 0;
            while (i3 < methodList.length) {
                Method method = methodList[i3];
                int mods = method.getModifiers();
                if (!Modifier.isStatic(mods) && Modifier.isPublic(mods)) {
                    String compound;
                    String name = method.getName();
                    Class<?>[] argTypes = method.getParameterTypes();
                    Class<?> resultType = method.getReturnType();
                    if (name.startsWith("add") && argTypes.length == 1 && resultType == Void.TYPE) {
                        compound = String.valueOf(name.substring(3)) + ":" + argTypes[0];
                        adds.put(compound, method);
                    } else if (name.startsWith("remove") && argTypes.length == 1 && resultType == Void.TYPE) {
                        compound = String.valueOf(name.substring(6)) + ":" + argTypes[0];
                        removes.put(compound, method);
                    }
                }
                ++i3;
            }
            Enumeration keys = adds.keys();
            String beanClassName = this.beanClass.getName();
            while (keys.hasMoreElements()) {
                String compound = (String)keys.nextElement();
                if (removes.get(compound) == null || compound.indexOf("Listener:") <= 0) continue;
                String listenerName = compound.substring(0, compound.indexOf(58));
                String eventName = Introspector.decapitalize(listenerName.substring(0, listenerName.length() - 8));
                Method addMethod = (Method)adds.get(compound);
                Method removeMethod = (Method)removes.get(compound);
                Class<?> argType = addMethod.getParameterTypes()[0];
                if (!Introspector.isSubclass(argType, eventListenerType)) continue;
                Method[] allMethods = argType.getMethods();
                int count = 0;
                int i4 = 0;
                while (i4 < allMethods.length) {
                    if (this.isEventHandler(allMethods[i4])) {
                        ++count;
                    } else {
                        allMethods[i4] = null;
                    }
                    ++i4;
                }
                Method[] methods = new Method[count];
                int j = 0;
                int i5 = 0;
                while (i5 < allMethods.length) {
                    if (allMethods[i5] != null) {
                        methods[j++] = allMethods[i5];
                    }
                    ++i5;
                }
                EventSetDescriptor esd = new EventSetDescriptor(eventName, argType, methods, addMethod, removeMethod);
                if (this.throwsException(addMethod, class$java$util$TooManyListenersException != null ? class$java$util$TooManyListenersException : Introspector.class$("java.util.TooManyListenersException"))) {
                    esd.setUnicast(true);
                }
                this.addEvent(esd);
            }
        }
        EventSetDescriptor[] result = new EventSetDescriptor[this.events.size()];
        Enumeration elements = this.events.elements();
        boolean i6 = false;
        while (var5_13 < result.length) {
            result[var5_13] = (EventSetDescriptor)elements.nextElement();
            if (this.defaultEventName != null && this.defaultEventName.equals(result[var5_13].getName())) {
                this.defaultEventIndex = var5_13;
            }
            ++var5_13;
        }
        return result;
    }

    void addEvent(EventSetDescriptor esd) {
        String key = esd.getName();
        if (key.equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if (esd.getListenerType().isAssignableFrom(class$java$beans$VetoableChangeListener != null ? class$java$beans$VetoableChangeListener : (class$java$beans$VetoableChangeListener = Introspector.class$("java.beans.VetoableChangeListener")))) {
            key = String.valueOf(key) + "Vetoable";
        } else if (esd.getListenerType().isAssignableFrom(class$java$beans$PropertyChangeListener != null ? class$java$beans$PropertyChangeListener : (class$java$beans$PropertyChangeListener = Introspector.class$("java.beans.PropertyChangeListener")))) {
            key = String.valueOf(key) + "Property";
        }
        EventSetDescriptor old = (EventSetDescriptor)this.events.get(key);
        if (old == null) {
            this.events.put(key, esd);
            return;
        }
        EventSetDescriptor composite = new EventSetDescriptor(old, esd);
        this.events.put(key, composite);
    }

    private MethodDescriptor[] getTargetMethodInfo() throws IntrospectionException {
        MethodDescriptor[] explicit = null;
        if (this.informant != null) {
            explicit = this.informant.getMethodDescriptors();
        }
        if (explicit == null && this.superBeanInfo != null) {
            MethodDescriptor[] supers = this.superBeanInfo.getMethodDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addMethod(supers[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            MethodDescriptor[] additional = this.additionalBeanInfo[i].getMethodDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addMethod(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicit != null) {
            int i2 = 0;
            while (i2 < explicit.length) {
                this.addMethod(explicit[i2]);
                ++i2;
            }
        } else {
            Method[] methodList = Introspector.getDeclaredMethods(this.beanClass);
            int i3 = 0;
            while (i3 < methodList.length) {
                Method method = methodList[i3];
                if (Modifier.isPublic(method.getModifiers())) {
                    MethodDescriptor md = new MethodDescriptor(method);
                    this.addMethod(md);
                }
                ++i3;
            }
        }
        MethodDescriptor[] result = new MethodDescriptor[this.methods.size()];
        Enumeration elements = this.methods.elements();
        int i4 = 0;
        while (i4 < result.length) {
            result[i4] = (MethodDescriptor)elements.nextElement();
            ++i4;
        }
        return result;
    }

    private void addMethod(MethodDescriptor md) {
        String name = md.getMethod().getName();
        MethodDescriptor old = (MethodDescriptor)this.methods.get(name);
        if (old == null) {
            this.methods.put(name, md);
            return;
        }
        Class<?>[] p1 = md.getMethod().getParameterTypes();
        Class<?>[] p2 = old.getMethod().getParameterTypes();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            int i = 0;
            while (i < p1.length) {
                if (p1[i] != p2[i]) {
                    match = false;
                    break;
                }
                ++i;
            }
        }
        if (match) {
            MethodDescriptor composite = new MethodDescriptor(old, md);
            this.methods.put(name, composite);
            return;
        }
        String longKey = this.makeQualifiedMethodName(md);
        old = (MethodDescriptor)this.methods.get(longKey);
        if (old == null) {
            this.methods.put(longKey, md);
            return;
        }
        MethodDescriptor composite = new MethodDescriptor(old, md);
        this.methods.put(longKey, composite);
    }

    private String makeQualifiedMethodName(MethodDescriptor md) {
        Method m = md.getMethod();
        StringBuffer sb = new StringBuffer();
        sb.append(m.getName());
        sb.append("=");
        Class<?>[] params = m.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            sb.append(":");
            sb.append(params[i].getName());
            ++i;
        }
        return sb.toString();
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() throws IntrospectionException {
        BeanDescriptor bd;
        if (this.informant != null && (bd = this.informant.getBeanDescriptor()) != null) {
            return bd;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private boolean isEventHandler(Method m) throws IntrospectionException {
        try {
            Class<?>[] argTypes = m.getParameterTypes();
            if (argTypes.length != 1) {
                return false;
            }
            String type = String.valueOf(argTypes[0]);
            return type.indexOf("Event") >= 0;
        }
        catch (Exception ex) {
            throw new IntrospectionException("Unexpected reflection exception: " + ex);
        }
    }

    private static synchronized Method[] getDeclaredMethods(Class clz) {
        Method[] result;
        if (declaredMethodCache == null) {
            declaredMethodCache = new Hashtable();
        }
        if ((result = (Method[])declaredMethodCache.get(clz)) == null) {
            result = clz.getDeclaredMethods();
            declaredMethodCache.put(clz, result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static Method findMethod(Class cls, String methodName, int argCount) throws IntrospectionException {
        if (methodName != null) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            methods = Introspector.getDeclaredMethods(cls);
            i = 0;
            while (i < methods.length) {
                method = methods[i];
                mods = method.getModifiers();
                if (!Modifier.isStatic(mods) && Modifier.isPublic(mods) && method.getName().equals(methodName) && method.getParameterTypes().length == argCount) {
                    return method;
                }
                ++i;
            }
            cls = cls.getSuperclass();
lbl13:
            // 2 sources

            ** while (cls != null)
        }
lbl14:
        // 1 sources

        throw new IntrospectionException("No method \"" + methodName + "\" with " + argCount + " arg(s)");
    }

    static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class x = a;
        while (x != null) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class<?>[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (Introspector.isSubclass(interfaces[i], b)) {
                        return true;
                    }
                    ++i;
                }
            }
            x = x.getSuperclass();
        }
        return false;
    }

    private boolean throwsException(Method method, Class exception) {
        Class<?>[] exs = method.getExceptionTypes();
        int i = 0;
        while (i < exs.length) {
            if (exs[i] == exception) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Object instantiate(Class sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception exception) {}
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        searchPath = new String[]{"sun.beans.infos"};
    }
}

