/* $Id: ini9100u.c,v 1.1 1996/07/28 08:28:18 root Exp root $
 * ini9100u.c -- Initio INI-9X00U/UW LINUX device driver
 * Author: Henry Chen
 * Copyright 1996-97 Initio Corporation
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 **************************************************************************
 
 DESCRIPTION:

 This is the Linux low-level SCSI driver for Initio INI-9X00U/UW SCSI host
 adapters

 **************************************************************************/

#define CVT_LINUX_VERSION(V,P,S)        (V * 65536 + P * 256 + S)

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#ifdef MODULE
#include <linux/module.h>
#endif

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
#include <stdarg.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/bios32.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/pci.h>
#include <linux/proc_fs.h>
#include <linux/blk.h>
#include "sd.h"
#include "scsi.h"
#include "hosts.h"
#include "ini9100u.h"
#include <linux/stat.h>
#include <linux/malloc.h>
#include <linux/config.h>

#else

#include <linux/kernel.h>
#include <linux/head.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/ioport.h>

#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <asm/system.h>
#include <asm/io.h>
#include "../block/blk.h"
#include "scsi.h"
#include "sd.h"
#include "hosts.h"
#include <linux/malloc.h>
#include "ini9100u.h"
#endif

#ifdef DEBUG_i91u
unsigned int i91u_debug  = DEBUG_DEFAULT;
#endif

#ifdef MODULE
Scsi_Host_Template driver_template = INI9100U;
#include "scsi_module.c"
#endif

char    *i91uCopyright  = "Copyright (C) 1996-97";
char    *i91uInitioName = "by Initio Corporation";
char    *i91uProductName= "INI-9X00U/UW";
char    *i91uVersion    = "v1.01g";

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
struct proc_dir_entry proc_scsi_ini9100u =
	{
	PROC_SCSI_INI9100U , 7, "INI9100U",
	S_IFDIR | S_IRUGO | S_IXUGO, 2
	};
#endif

/* set by i91_setup according to the command line */
static	int		setup_called    = 0;

static	int      	tul_num_ch = 4;
static	int      	tul_num_scb; 
static	int      	tul_tag_enable = 1;
static	SCB      	*tul_scb;

#ifdef DEBUG_i91u
static	int	setup_debug     = 0;
#endif

static	char	*setup_str = (char *)NULL;

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static	void	i91u_intr0( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr1( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr2( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr3( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr4( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr5( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr6( int irq, void *dev_id, struct pt_regs * );
static	void	i91u_intr7( int irq, void *dev_id, struct pt_regs * );
#else
static	void	i91u_intr0( int irq, struct pt_regs * );
static	void	i91u_intr1( int irq, struct pt_regs * );
static	void	i91u_intr2( int irq, struct pt_regs * );
static	void	i91u_intr3( int irq, struct pt_regs * );
static	void	i91u_intr4( int irq, struct pt_regs * );
static	void	i91u_intr5( int irq, struct pt_regs * );
static	void	i91u_intr6( int irq, struct pt_regs * );
static	void	i91u_intr7( int irq, struct pt_regs * );
#endif

static	void	i91u_panic(char *msg);

static	void	i91uSCBPost(BYTE *pHCB, BYTE *pSCB);

				/* ---- EXTERNAL FUNCTIONS ---- */
					/* Get total number of adapters*/
extern	int     tul_ReturnNumberOfAdapters(void);
extern	void     get_tulipPCIConfig(HCS *pHCB, int iChannel_index);
extern	int     init_tulip(HCS *pHCB, SCB *pSCB, int tul_num_scb);
extern	SCB     *tul_alloc_scb(HCS *pHCB);
extern	SCB     *tul_abort_srb(HCS *pHCB, Scsi_Cmnd *pSRB);
extern	void    tul_exec_scb(HCS *pHCB, SCB *pSCB);
extern	void    tul_release_scb(HCS *pHCB, SCB *pSCB);
extern	int     tul_isr(HCS *pHCB);

				/* ---- EXTERNAL VARIABLES ---- */
extern	HCS    	tul_hcs[];

/*
 *  queue services:
 */
#if 0
/*****************************************************************************
 Function name  : i91uPushSRBToQueue
 Description    : This function will push current request into save list
 Input          : pSRB  -       Pointer to SCSI request block.
		  pHCB  -       Pointer to host adapter structure
 Output         : None.
 Return         : None.
*****************************************************************************/
static void i91uPushSRBToQueue(HCS *pHCB, Scsi_Cmnd *pSRB)
{
/*    printk("i91u: enter i91uPushSRBToQueue: \n");*/
    if (pHCB->pSRB_head == NULL)
	{
	pHCB->pSRB_tail = pSRB;
	pSRB->next = NULL; 
	}
    else
	{
	pSRB->next = pHCB->pSRB_head; 
	}

    pHCB->pSRB_head = pSRB;

    return;
}
#endif

/*****************************************************************************
 Function name  : i91uAppendSRBToQueue
 Description    : This function will push current request into save list
 Input          : pSRB  -       Pointer to SCSI request block.
		  pHCB  -       Pointer to host adapter structure
 Output         : None.
 Return         : None.
*****************************************************************************/
static void i91uAppendSRBToQueue(HCS *pHCB, Scsi_Cmnd *pSRB)
{
/*    printk("i91u: enter i91uAppendSRBToQueue: \n");*/

    pSRB->next = NULL;                  /* Pointer to next              */

    if (pHCB->pSRB_head == NULL)
	pHCB->pSRB_head = pSRB;
    else
	pHCB->pSRB_tail->next = pSRB;   /* Pointer to next              */
    pHCB->pSRB_tail = pSRB;

    return;
}

/*****************************************************************************
 Function name  : i91uPopSRBFromQueue
 Description    : This function will pop current request from save list
 Input          : pHCB  -       Pointer to host adapter structure
 Output         : None.
 Return         : pSRB  -       Pointer to SCSI request block.
*****************************************************************************/
static Scsi_Cmnd *i91uPopSRBFromQueue(HCS *pHCB)
{
    Scsi_Cmnd   *pSRB;

/*    printk("i91u: enter i91uPopSRBFromQueue: \n");*/

    if ((pSRB = pHCB->pSRB_head) != NULL)
	{
	pHCB->pSRB_head = pHCB->pSRB_head->next;
	pSRB->next = NULL;
	}

    return (pSRB);
}

/* called from init/main.c */

void i91u_setup( char *str, int *ints)
{
/*    printk("i91u: enter i91u_setup: ");*/
    if (setup_called)
	i91u_panic("i91u: i91u_setup called twice.\n");

    setup_called    = ints[0];
    setup_str       = str;
#ifdef DEBUG_i91u
    setup_debug     = ints[0] >= 1 ? ints[1] : DEBUG_DEFAULT;
#endif
}

int i91u_detect(Scsi_Host_Template * tpnt)
{
    SCB                 *pSCB;
    HCS                 *pHCB;
    struct Scsi_Host    *hreg;
    int         i, ok = 0, iAdapters;
  
/*    printk("i91u: enter i91u_detect: \n");*/

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
    tpnt->proc_dir = &proc_scsi_ini9100u;
#endif

    if (setup_called)
	{                               /* Setup by i91u_setup          */
	printk("i91u: processing commandline: ");
   
#ifdef DEBUG_i91u
	if (setup_called > 1)
	    {
	    printk("\ni91u: %s\n", setup_str );
	    printk("i91u: usage: i91u[=<DEBUG>]\n");
	    i91u_panic("i91u panics in line %d", __LINE__);
	    }
	i91u_debug   = setup_debug;
#endif
	}

    if (tul_tag_enable)
	{
//	tul_num_scb = 35;
	tul_num_scb = MAX_TARGETS * tul_num_ch * i91u_MAXQUEUE;
	}
    else
	{
	tul_num_scb = MAX_TARGETS + 3;        /* 1-tape, 1-CD_ROM, 1- extra */
	}

    iAdapters = tul_ReturnNumberOfAdapters();  /* Get total number of adapters
							in the motherboard */
	/*printk("i91u: Total Initio Adapters = %d\n", iAdapters);*/

    if (iAdapters == 0)                 /* If no tulip founded, return*/
	return (0);

    tul_num_ch = (iAdapters > tul_num_ch)? tul_num_ch : iAdapters;
					/* Update actually channel number */
					/* Get total memory needed for HCS */
    i = tul_num_ch * sizeof(HCS);
    memset((unsigned char *) &tul_hcs[0], 0, i);/* Initialize tul_hcs 0	*/
					/* Get total memory needed for SCB */
    i = tul_num_ch * tul_num_scb * sizeof(SCB);

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
    tul_scb = (SCB *) kmalloc(i, GFP_ATOMIC|GFP_DMA);
#else
    tul_scb = (SCB *) scsi_init_malloc(i, GFP_ATOMIC|GFP_DMA);
#endif

    memset((unsigned char *) tul_scb, 0, i);

    pSCB = tul_scb;
    for ( i = 0; i < tul_num_ch * tul_num_scb; i++, pSCB++)
	{
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	pSCB->SCB_SGPAddr = (ULONG) VIRT_TO_BUS (&pSCB->SCB_SGList[0]);
#else
	pSCB->SCB_SGPAddr = (ULONG) (&pSCB->SCB_SGList[0]);
#endif
	}

    for (i = 0, pHCB = &tul_hcs[0];     /* Get pointer for control block*/
	 i < tul_num_ch;
	 i++, pHCB++)
	{
	pHCB->pSRB_head = NULL;         /* Initial SRB save queue       */
	pHCB->pSRB_tail = NULL;         /* Initial SRB save queue       */

	request_region(pHCB->HCS_Base, 0x100, "i91u");  /* Register */

#if 0
	printk("i91u: Reset SCSI bus ... \n");
#endif

	get_tulipPCIConfig(pHCB, i);

#if 1
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	pHCB->HCS_BIOS = (ULONG) phys_to_virt (pHCB->HCS_BIOS);
#endif
#endif

	init_tulip(pHCB, tul_scb + (i * tul_num_scb), tul_num_scb);

#if 0
	printk("i91u: vital data: PCI Base=0x%04X, IRQ=%d, BIOS=0x%04X0, SCSI ID=%d\n",
		pHCB->HCS_Base,
		pHCB->HCS_Intr,
		pHCB->HCS_BIOS,
		pHCB->HCS_SCSI_ID);
#endif
	hreg = scsi_register(tpnt, sizeof(HCS));
	hreg->io_port = pHCB->HCS_Base;
	hreg->n_io_port = 0xff;
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	hreg->unique_id = pHCB->HCS_Base;
	hreg->max_id = pHCB->HCS_MaxTar;
#endif
/*      hreg->max_lun = 8;
	hreg->max_channel = 1;*/
	hreg->irq = pHCB->HCS_Intr;
	hreg->this_id = pHCB->HCS_SCSI_ID;/* Assign HCS index           */
	hreg->base = (UCHAR *) pHCB;
#if 1
	hreg->sg_tablesize = TOTAL_SG_ENTRY;	/* Maximun support is 32*/
#else
	hreg->sg_tablesize = SG_NONE;   /* No SG                        */
#endif
/*      hreg->this_id = i;               Assign HCS index               */
#if 1  
					/* Initial tulip chip           */
	switch (i) {
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	    case 0:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr0,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 1:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr1,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 2:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr2,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 3:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr3,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 4:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr4,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 5:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr5,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 6:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr6,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
	    case 7:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr7,SA_INTERRUPT | SA_SHIRQ,"i91u",NULL);
		break;
#else
	    case 0:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr0,SA_INTERRUPT,"i91u");
		break;
	    case 1:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr1,SA_INTERRUPT,"i91u");
		break;
	    case 2:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr2,SA_INTERRUPT,"i91u");
		break;
	    case 3:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr3,SA_INTERRUPT,"i91u");
		break;
	    case 4:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr4,SA_INTERRUPT,"i91u");
		break;
	    case 5:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr5,SA_INTERRUPT,"i91u");
		break;
	    case 6:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr6,SA_INTERRUPT,"i91u");
		break;
	    case 7:
		ok = request_irq(pHCB->HCS_Intr, i91u_intr7,SA_INTERRUPT,"i91u");
		break;
#endif
	    default:
		i91u_panic("i91u: Too many host adapters\n");
		break;
	    }
	if (ok < 0)
	    {
	    if (ok == -EINVAL)
		{
		printk("i91u: bad IRQ %d.\n", pHCB->HCS_Intr);
		printk("         Contact author.\n");
		}
	    else
		if( ok == -EBUSY)
		    printk( "i91u: IRQ %d already in use. Configure another.\n",
			pHCB->HCS_Intr);
		else
		    {
		    printk( "\ni91u: Unexpected error code on requesting IRQ %d.\n",
		    pHCB->HCS_Intr);
		    printk("         Contact author.\n");
		    }
	    i91u_panic("i91u: driver needs an IRQ.\n");
	    }
#endif
	}

    tpnt->this_id = -1;
/*    tpnt->can_queue=i91u_MAXQUEUE;*/
    tpnt->can_queue=1;

    return 1;
}

static void i91uBuildSCB(HCS *pHCB, SCB *pSCB, Scsi_Cmnd *SCpnt)
{                                       /* Create corresponding SCB     */
    struct scatterlist  *pSrbSG;
    SG                  *pSG;           /* Pointer to SG list           */
    int                 i;
    long                TotalLen;

    pSCB->SCB_Post      = i91uSCBPost;  /* i91u's callback routine	*/
    pSCB->SCB_Srb       = SCpnt;
    pSCB->SCB_Opcode    = ExecSCSI;
    pSCB->SCB_Flags     = SCF_NO_DCHK;  /* Clear done bit               */
    pSCB->SCB_Flags     |= SCF_POST;    /* After SCSI done, call post routine*/
    pSCB->SCB_Target    = SCpnt->target;
    pSCB->SCB_Lun       = SCpnt->lun;
/*    pSCB->SCB_Ident   = SCpnt->lun | DISC_NOT_ALLOW;*/
    pSCB->SCB_Ident     = SCpnt->lun | DISC_ALLOW;
#if 1
    pSCB->SCB_Flags     |= SCF_SENSE;   /* Turn on auto request sense   */
    memset((unsigned char *) &SCpnt->sense_buffer[0], 0, SENSE_SIZE);
#endif
    pSCB->SCB_SensePtr = pSCB->SCB_SGPAddr;
    pSCB->SCB_SenseLen = SENSE_SIZE;

    pSCB->SCB_CDBLen    = SCpnt->cmd_len;
    pSCB->SCB_HaStat    = 0;
    pSCB->SCB_TaStat    = 0;
    memcpy(&pSCB->SCB_CDB[0], &SCpnt->cmnd, SCpnt->cmd_len);

    if (SCpnt->device->tagged_supported)
	{                               /* Tag Support                  */
	pSCB->SCB_TagMsg = SIMPLE_QUEUE_TAG;    /* Do simple tag only   */
	}
    else
	{
	pSCB->SCB_TagMsg = 0;           /* No tag support               */
	}

    if (SCpnt->use_sg)
	{
	pSrbSG  = (struct scatterlist *) SCpnt->request_buffer;
	if (SCpnt->use_sg == 1)         /* If only one entry in the list*/
	    {                           /*      treat it as regular I/O */
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	    pSCB->SCB_BufPtr        = (ULONG) VIRT_TO_BUS (pSrbSG->address);
#else
	    pSCB->SCB_BufPtr        = (ULONG) (pSrbSG->address);
#endif
	    TotalLen = pSrbSG->length;
	    pSCB->SCB_SGLen = 0;
	    }
	else
	    {                           /* Assign SG physical address   */
	    pSCB->SCB_BufPtr    = pSCB->SCB_SGPAddr;
	    pSCB->SCB_Flags     |= SCF_SG;/* Turn on SG list flag       */
	    for (i = 0, TotalLen = 0, pSG = &pSCB->SCB_SGList[0];/* 1.01g*/
		 i < SCpnt->use_sg;
		 i++, pSG++, pSrbSG++)
		{
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
		pSG->SG_Ptr = (ULONG) VIRT_TO_BUS (pSrbSG->address);
#else
		pSG->SG_Ptr = (ULONG) (pSrbSG->address);
#endif
		TotalLen += pSG->SG_Len = pSrbSG->length;
		}
	    pSCB->SCB_SGLen     = i;
	    }
	pSCB->SCB_BufLen = (SCpnt->request_bufflen > TotalLen) ?
				TotalLen : SCpnt->request_bufflen;
	}
    else                                /* Non SG                       */
	{
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
	pSCB->SCB_BufPtr        = (ULONG) VIRT_TO_BUS(SCpnt->request_buffer);
#else
	pSCB->SCB_BufPtr        = (ULONG) (SCpnt->request_buffer);
#endif
	pSCB->SCB_BufLen        = SCpnt->request_bufflen;
	pSCB->SCB_SGLen         = 0;
	}

    return;
}

/* 
 *  Queue a command and setup interrupts for a free bus.
 */
int i91u_queue( Scsi_Cmnd * SCpnt, void (*done)(Scsi_Cmnd *))
{
    register SCB        *pSCB;
    HCS                 *pHCB;          /* Point to Host adapter control block*/

    pHCB = (HCS *) SCpnt->host->base;

/*    printk("i91u: enter i91u_queue\n");*/

    SCpnt->scsi_done =       done;
					/* Get free SCSI control block  */
    if ((pSCB = tul_alloc_scb(pHCB)) == NULL)
	{
	i91uAppendSRBToQueue(pHCB, SCpnt);      /* Buffer this request  */
/*      printk("i91u_entry: can't allocate SCB\n");*/
	return (0);
	}
    i91uBuildSCB(pHCB, pSCB, SCpnt);
    tul_exec_scb(pHCB, pSCB);   /* Start execute SCB            */
    return (0);
}

/*
 *  We only support command in interrupt-driven fashion
 */
int i91u_command( Scsi_Cmnd *SCpnt )
{
    printk( "i91u: interrupt driven driver; use i91u_queue()\n" );
    return -1;
}

/*
 *  Abort a queued command
 *  (commands that are on the bus can't be aborted easily)
 */
int i91u_abort( Scsi_Cmnd *SCpnt)
{
    HCS *pHCB;

    printk( "i91u: abort SRB \n" );
    pHCB = (HCS *) SCpnt->host->base;
    if (tul_abort_srb(pHCB, SCpnt) != NULL)
	{
	SCpnt->result = DID_ABORT << 16;
	SCpnt->done(SCpnt);
	return (SCSI_ABORT_SUCCESS);
	}
    else
	{
	printk("Command not found\n");
	return (SCSI_ABORT_NOT_RUNNING);
	}
#if 0
    return SCSI_ABORT_BUSY;
#endif
}

/*
 *  Reset registers, reset a hanging bus and
 *  kill active and disconnected commands for target w/o soft reset
 */
int i91u_reset(Scsi_Cmnd * __unused, unsigned int reset_flags)
{                               /* I need Host Control Block Information */     
    printk( "i91u: Reset not support yet\n" );
    return (SCSI_RESET_SUCCESS);
}

/*
 * Return the "logical geometry"
 */
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
int i91u_biosparam(Scsi_Disk *disk, kdev_t dev, int *info_array )
#else
int i91u_biosparam(Scsi_Disk *disk, int dev, int *info_array )
#endif
{
    HCS *pHcb;                          /* Point to Host adapter control block*/
    TCS *pTcb;

    pHcb = (HCS *) disk->device->host->base;
    pTcb = &pHcb->HCS_Tcs[disk->device->id];

/*
    printk( "i91u: Enter i91u biosparam, device id = %x \n", disk->device->id );
    printk( "head = %x \n", pHcb->HCS_Tcs[disk->device->id].TCS_DrvHead);
    printk( "sector = %x \n", pHcb->HCS_Tcs[disk->device->id].TCS_DrvSector);
*/  

    if (pTcb->TCS_DrvHead)
	{
	info_array[0] = pTcb->TCS_DrvHead;
	info_array[1] = pTcb->TCS_DrvSector;
	info_array[2] = disk->capacity / pTcb->TCS_DrvHead / pTcb->TCS_DrvSector;
	}
    else
	{
	if (pTcb->TCS_DrvFlags & TCF_DRV_255_63)
	    {
	    info_array[0] = 255;
	    info_array[1] = 63;
	    info_array[2] = disk->capacity / 255 / 63;
	    }
	else
	    {
	    info_array[0] = 64;
	    info_array[1] = 32;
	    info_array[2] = disk->capacity >> 11;
	    }
	}

#if defined(DEBUG_BIOSPARAM)
    if (i91u_debug & debug_biosparam)
	{
	printk("bios geometry: head=%d, sec=%d, cyl=%d\n",
	   info_array[0], info_array[1], info_array[2]);
	printk("WARNING: check, if the bios geometry is correct.\n");
	}
#endif

    return 0;
}

/*****************************************************************************
 Function name  : i91uSCBPost
 Description    : This is callback routine be called when tulip finish one
			SCSI command.
 Input          : pHCB  -       Pointer to host adapter control block.
		  pSCB  -       Pointer to SCSI control block.
 Output         : None.
 Return         : None.
*****************************************************************************/
static void i91uSCBPost(BYTE *pHcb, BYTE *pScb)
{
    Scsi_Cmnd   *pSRB;          /* Pointer to SCSI request block */
    HCS         *pHCB;
    SCB         *pSCB;

    pHCB = (HCS *) pHcb;
    pSCB = (SCB *) pScb;
    if ((pSRB = pSCB->SCB_Srb) == 0)
	{
	printk("i91uSCBPost: SRB pointer is empty\n");

	tul_release_scb(pHCB, pSCB);    /* Release SCB for current channel */
	return;
	}
#if 0
    printk("Ha= %x Ta= %x \n", pSCB->SCB_HaStat, pSCB->SCB_TaStat);
#endif
    switch (pSCB->SCB_HaStat) {
	case 0x0:
	case 0xa: /* Linked command complete without error and linked normally*/
	case 0xb: /* Linked command complete without error interrupt generated*/
	    pSCB->SCB_HaStat = 0;
	    break;

	case 0x11: /* Selection time out-The initiator selection or target
		    reselection was not complete within the SCSI Time out period */
	    pSCB->SCB_HaStat = DID_TIME_OUT;
	    break;

	case 0x14: /* Target bus phase sequence failure-An invalid bus phase or bus
		    phase sequence was requested by the target. The host adapter
		    will generate a SCSI Reset Condition, notifying the host with
		    a SCRD interrupt */
	    pSCB->SCB_HaStat = DID_RESET;
	    break;

	case 0x12: /* Data overrun/underrun-The target attempted to transfer more data
		    than was allocated by the Data Length field or the sum of the
		    Scatter / Gather Data Length fields. */
	case 0x13: /* Unexpected bus free-The target dropped the SCSI BSY at an unexpected time. */
	case 0x15: /* MBO command was not 00, 01 or 02-The first byte of the CB was
		    invalid. This usually indicates a software failure. */
	case 0x16: /* Invalid CCB Operation Code-The first byte of the CCB was invalid.
		    This usually indicates a software failure. */
	case 0x17: /* Linked CCB does not have the same LUN-A subsequent CCB of a set
		    of linked CCB's does not specify the same logical unit number as
		    the first. */
	case 0x18: /* Invalid Target Direction received from Host-The direction of a
		    Target Mode CCB was invalid. */
	case 0x19: /* Duplicate CCB Received in Target Mode-More than once CCB was
		    received to service data transfer between the same target LUN
		    and initiator SCSI ID in the same direction. */
	case 0x1a: /* Invalid CCB or Segment List Parameter-A segment list with a zero
		    length segment or invalid segment list boundaries was received.
		    A CCB parameter was invalid. */
	default:
	    printk("ini9100u: %x %x\n", pSCB->SCB_HaStat, pSCB->SCB_TaStat);
	    pSCB->SCB_HaStat = DID_ERROR; /* Couldn't find any better */
	    break;
    }
    if ((pSCB->SCB_TaStat == 2) &&      /* Check condition              */
	(pSCB->SCB_Flags & SCF_SENSE))  /* Turn on auto request sense   */
	{
	memcpy((unsigned char *) &pSRB->sense_buffer[0], (unsigned char *) pSCB->SCB_SGPAddr, SENSE_SIZE);
	}
    pSRB->result = pSCB->SCB_TaStat | (pSCB->SCB_HaStat << 16);

    if (pSRB == NULL)
	{
	printk("pSRB is NULL\n");
	}
    pSRB->scsi_done(pSRB);              /* Notify system DONE           */
    if ((pSRB = i91uPopSRBFromQueue(pHCB)) != NULL)
					/* Find the next pending SRB    */
	{                               /* Assume resend will success   */
					/* Reuse old SCB                */
	i91uBuildSCB(pHCB, pSCB, pSRB); /* Create corresponding SCB     */

	tul_exec_scb(pHCB, pSCB);       /* Start execute SCB            */
	}
    else
	{                               /* No Pending SRB               */
	tul_release_scb(pHCB, pSCB);    /* Release SCB for current channel */
	}
    return;
}

/*
 * Interrupts handler (main routine of the driver)
 */
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr0( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr0( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

/*    printk("irqno= %x\n", irqno);*/
    pHCB = &tul_hcs[0];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr1( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr1( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[1];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr2( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr2( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[2];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr3( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr3( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[3];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr4( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr4( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[4];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr5( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr5( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[5];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr6( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr6( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[6];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}
#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1,3,0)
static void i91u_intr7( int irqno, void *dev_id, struct pt_regs * regs )
#else
static void i91u_intr7( int irqno, struct pt_regs * regs )
#endif
{
    HCS *pHCB;

    pHCB = &tul_hcs[7];
    if (pHCB->HCS_Intr != irqno)
	return;
    tul_isr(pHCB);
}

/* 
 * Dump the current driver status and panic...
 */
static void i91u_panic(char *msg)
{
  printk("\ni91u_panic: %s\n", msg);
  panic("i91u panic");
}
/*#include "i91uscsi.c"*/
