/******************************************************************************
			Copyright (c) 1996-1997 Initio Corp.
	Initio LINUX device driver are copyrighted by Initio Corporation.
	Your rights of ownership are subject to the limitations and restrictions
	imposed by the copyright laws. Initio makes no warranty  of any kind in
	regard to this material, including,  but not  limited to,  the  implied
	warranties of merchantability and fitness  for  a  particular  purpose.
	Initio is not liable for any errors contained  herein  or incidental or
	consequential damages in connection with furnishing, performance or use
	of this material.
  -----------------------------------------------------------------------
 Module: ini9100u.h
 Description: INI-9100U/UW LINUX device driver header
 Revision History:
	06/18/96 Harry Chen, Initial Version 1.00A (Beta)
*******************************************************************************/

#ifndef	CVT_LINUX_VERSION
#define	CVT_LINUX_VERSION(V,P,S)	(((V) * 65536) + ((P) * 256) + (S))
#endif

#ifndef	LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#include "sd.h"

extern int        i91u_detect(Scsi_Host_Template *);
extern int        i91u_command(Scsi_Cmnd *);
extern int        i91u_queue(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));
extern int        i91u_abort(Scsi_Cmnd *);
extern int        i91u_reset(Scsi_Cmnd *, unsigned int);

#if LINUX_VERSION_CODE >= CVT_LINUX_VERSION(1, 3, 0)
extern int        i91u_biosparam(Scsi_Disk *, kdev_t, int *); /*for linux v2.0*/
extern struct proc_dir_entry proc_scsi_ini9100u;
#else
extern int        i91u_biosparam(Disk *, int, int *);  /*for linux v1.13 */
#endif

#define i91u_REVID "Initio INI-9X00U/UW SCSI device driver; Revision: 1.01g"

#if LINUX_VERSION_CODE < CVT_LINUX_VERSION(1, 3, 0)
#define INI9100U	{ \
		NULL, \
		NULL, \
		i91u_REVID, \
		i91u_detect, \
		NULL, \
		NULL, \
		i91u_command, \
		i91u_queue, \
		i91u_abort, \
		i91u_reset, \
		NULL, \
		i91u_biosparam, \
		1, \
		7, \
		SG_ALL, \
		1, \
		0, \
		0, \
		ENABLE_CLUSTERING \
}
#else
#define INI9100U	{ \
		NULL, \
		NULL, \
		&proc_scsi_ini9100u, \
		NULL, \
		i91u_REVID, \
		i91u_detect, \
		NULL, \
		NULL, \
		i91u_command, \
		i91u_queue, \
		i91u_abort, \
		i91u_reset, \
		NULL, \
		i91u_biosparam, \
		1, \
		7, \
		SG_ALL, \
		1, \
		0, \
		0, \
		ENABLE_CLUSTERING \
}
#endif


#define VIRT_TO_BUS(i)  (unsigned int) virt_to_bus((void *)(i))


#define ULONG   unsigned long
#define USHORT  unsigned short
#define UCHAR   unsigned char
#define BYTE    unsigned char
#define WORD    unsigned short
#define DWORD   unsigned long
#define UBYTE   unsigned char
#define UWORD   unsigned short
#define UDWORD  unsigned long

#ifndef NULL
#define NULL     0            /* zero          */
#endif
#ifndef TRUE
#define TRUE     (1)          /* boolean true  */
#endif
#ifndef FALSE
#define FALSE    (0)          /* boolean false */
#endif
#ifndef FAILURE
#define FAILURE  (-1)
#endif

#define i91u_MAXQUEUE		2 
#define TOTAL_SG_ENTRY		32
#define MAX_TARGETS		16
#define SENSE_SIZE		14

#define TUL_VENDOR_ID   0x1101          /* Initio's PCI vendor ID       */
#define TUL_DEVICE_ID   0x9500          /* Initio's product ID          */

/************************************************************************/
/*              Scatter-Gather Element Structure                        */
/************************************************************************/
typedef struct SG_Struc         {
	ULONG   SG_Ptr;         /* Data Pointer */
	ULONG   SG_Len;         /* Data Length */
} SG;

/***********************************************************************
		SCSI Control Block
************************************************************************/
typedef struct Scsi_Ctrl_Blk            {
	ULONG	SCB_InitioReserved[9]; /* 0 */

	UBYTE   SCB_Opcode;     /*24 SCB command code */
	UBYTE   SCB_Flags;      /*25 SCB Flags */
	UBYTE   SCB_Target;     /*26 Target Id */
	UBYTE   SCB_Lun;        /*27 Lun */
	ULONG   SCB_BufPtr;     /*28 Data Buffer Pointer */
	ULONG   SCB_BufLen;     /*2C Data Allocation Length */
	UBYTE   SCB_SGLen;      /*30 SG list # */
	UBYTE   SCB_SenseLen;   /*31 Sense Allocation Length */
	UBYTE   SCB_HaStat;     /*32 */
	UBYTE   SCB_TaStat;     /*33 */
	UBYTE   SCB_CDBLen;     /*34 CDB Length */
	UBYTE   SCB_Ident;      /*35 Identify */
	UBYTE   SCB_TagMsg;     /*36 Tag Message */ 
	UBYTE   SCB_TagId;      /*37 Queue Tag */
	UBYTE   SCB_CDB[12];    /*38 */
	ULONG   SCB_SGPAddr;    /*44 SG List/Sense Buf phy. Addr. */
	ULONG   SCB_SensePtr;   /*48 Sense data pointer */
	void    (* SCB_Post)(BYTE *, BYTE *);  /*4C POST routine */
	Scsi_Cmnd       *SCB_Srb;       /*50 SRB Pointer */
	SG      SCB_SGList[TOTAL_SG_ENTRY];     /*54 Start of SG list */
} SCB;

/* Opcodes of SCB_Opcode */
#define ExecSCSI        0x1
#define BusDevRst       0x2
#define AbortCmd        0x3

/* Bit Definition for SCB_Flags */
#define SCF_DONE        0x01
#define SCF_POST        0x02
#define SCF_SENSE       0x04
#define SCF_DIR         0x18
#define SCF_NO_DCHK     0x00
#define SCF_DIN         0x08
#define SCF_DOUT        0x10
#define SCF_NO_XF       0x18
#define SCF_POLL        0x40
#define SCF_SG          0x80

/* Error Codes for SCB_HaStat */
#define HOST_SEL_TOUT   0x11
#define HOST_DO_DU      0x12
#define HOST_BUS_FREE   0x13
#define HOST_BAD_PHAS   0x14
#define HOST_INV_CMD    0x16
#define HOST_SCSI_RST   0x1B
#define HOST_DEV_RST    0x1C

/* Error Codes for SCB_TaStat */
#define TARGET_CHKCOND  0x02
#define TARGET_BUSY     0x08

/* Queue tag msg: Simple_quque_tag, Head_of_queue_tag, Ordered_queue_tag */
#define MSG_STAG        0x20
#define MSG_HTAG        0x21
#define MSG_OTAG        0x22

/***********************************************************************
		Target Device Control Structure
**********************************************************************/

typedef struct Tar_Ctrl_Struc {
	ULONG	TCS_InitioReserved;	/* 0 */

	UWORD   TCS_DrvFlags;           /* 4 */
	UBYTE   TCS_DrvHead;            /* 6 */
	UBYTE   TCS_DrvSector;          /* 7 */
} TCS;

/***********************************************************************
		Target Device Control Structure
**********************************************************************/
/* Bit Definition for TCF_DrvFlags */
#define TCF_DRV_255_63          0x0400

/***********************************************************************
	      Host Adapter Control Structure
************************************************************************/
typedef struct Ha_Ctrl_Struc {
	UWORD   HCS_Base;       /* 00 */
	UWORD   HCS_BIOS;       /* 02 */
	UBYTE   HCS_Intr;       /* 04 */
	UBYTE   HCS_SCSI_ID;    /* 05 */
	UBYTE   HCS_MaxTar;     /* 06 */
	UBYTE   HCS_NumScbs;    /* 07 */

	ULONG	HCS_InitioReserved[20];	/* 08 */

	TCS     HCS_Tcs[16];	/* 58 -> 16 Targets */
	Scsi_Cmnd       *pSRB_head;     /* SRB save queue header     */
	Scsi_Cmnd       *pSRB_tail;     /* SRB save queue tail       */
} HCS;

/* SCSI related definition                                              */
#define DISC_NOT_ALLOW          0x80    /* Disconnect is not allowed    */
#define DISC_ALLOW              0xC0    /* Disconnect is allowed        */
