/*     
 **********************************************************************
 *     cardcfg.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _CARDCFG_H_
#define _CARDCFG_H_

#define MAX_MEMREGISTER     1
#define MAX_IOPORT          4
#define MAX_IRQ             2
#define MAX_DMA             2

struct sblive_config
{
    u32 vendorid;                     // Vendor Id
    u32 serialno;
    u32 logdevid;
    u32 chiprev;                 // Chip revision

    u16  nummemwindows;                 // Num memory windows
    u32 membase[MAX_MEMREGISTER];     // Memory window base
    u32 memlength[MAX_MEMREGISTER];   // Memory window length
    u16  memattrib[MAX_MEMREGISTER];   // Memory window Attrib
    u16  numioports;                    // Num IO ports
    u16  ioportbase[MAX_IOPORT];        // I/O port base
    u16  ioportlenh[MAX_IOPORT];      // I/O port length
    u16  numirq;                       // Num IRQ info
    u8  IRQregs[MAX_IRQ];         // IRQ list
    u8  irqattr[MAX_IRQ];            // IRQ Attrib list

    u16  numdma;                       // Num DMA channels
    u8  dmalst[MAX_DMA];               // DMA list
    u16  dmaattr[MAX_DMA];            // DMA Attrib list

};

#endif //_CARDCFG_H_
