/*
 **********************************************************************
 *     cardwi.h -- header file for card wave input functions
 *     Copyright 1999, 2000 Creative Labs, Inc.
 *
 **********************************************************************
 *
 *     Date                 Author          Summary of changes
 *     ----                 ------          ------------------
 *     October 20, 1999     Bertrand Lee    base code release
 *
 **********************************************************************
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *
 **********************************************************************
 */
#ifndef _CARDWAVEIN_H_
#define _CARDWAVEIN_H_

#include "icardwav.h"
#include "mymix.h"
#include "recmgr.h"

struct wave_in 
{
	struct wave_in *next;
	u32 status;
	u32 state;
	int synchstart;
	struct wave_format wave_fmt;
	CALLBACKFN CallbackFn;
	struct emu_voice *emu_voice;
	struct record *rec_ptr;
	u32 memhandle;
	u32 refdata;
	u32 callbacksize;
	u32 process_id;		/* used for synchonize start */
	int setpos;
	u32 position;

#if LINUX_VERSION_CODE < 0x020301
	struct wait_queue *wait_queue;
#else
	wait_queue_head_t wait_queue;
#endif				/* LINUX_VERSION_CODE < 0x020301 */
	int mapped;
	CTDPC dsDpc;
	u32 timerhandle;
	u32 timerinterval;
};

struct wiinst
{
	struct wave_format wave_fmt;
	u32 fragment_size;
	u16 ossfragshift;
	u32 numfrags;
	struct wave_in *wave_in;
	spinlock_t lock;
};

/* sblive_wave states */
#define CARDWAVE_STATE_STOPPED     0x0001
#define CARDWAVE_STATE_STARTED     0x0002
#define CARDWAVE_STATE_SUSPEND     0x0004

/* transfer buffer format */
#define M8                        0x00
#define M16                       0x01
#define S8                        0x02
#define S16                       0x03

#define INTERPOLATION_BYTES       8
#define WAVEIN_MAXBUFSIZE         65536
#define WAVEIN_DEFAULTFRAGLEN     50
#define WAVEIN_DEFAULTBUFLEN      1000

struct sblive_wavein 
{
	DECLMAGIC
	struct wave_caps caps;
	u32 numrecordinst;
	struct wave_in *wave_inlist;
	u32 lineid;
	u32 ctrlid;
};


int sblive_waveinInit(struct sblive_wavein *, u8 *);
int sblive_waveinExit(struct sblive_wavein *);
int sblive_waveinSetPowerState(struct sblive_hw *, u32);
int sblive_waveinGetCaps(struct sblive_wavein *, struct wave_caps *);
int sblive_waveinQueryFormat(struct sblive_wavein *, struct wave_format *, u32);
int sblive_waveinOpen(struct sblive_hw *, struct wave_format *, CALLBACKFN, u32,
		   u32 *, u32, struct wave_in **);
int sblive_waveinClose(struct sblive_hw *, struct wave_in *);
int sblive_waveinGetBuffer(struct sblive_wavein *, struct wave_in *, u32 *, u8 **);
int sblive_waveinSetBuffer(struct sblive_hw *, struct wave_in *, u32, void *,
			u32 *, u32);
int sblive_waveinStart(struct sblive_hw *, struct wave_in *);
int sblive_waveinStop(struct sblive_hw *, struct wave_in *, u32 *);
int sblive_waveinGetPosition(struct sblive_wavein *, struct wave_in *, u32 *);
int sblive_waveinSetPosition(struct sblive_wavein *, struct wave_in *, u32);
int sblive_waveinGetXferSize(struct sblive_wavein *, struct wave_in *, u32 *, u32 *);
int sblive_waveinXferData(struct sblive_wavein *, struct wave_in *, u8 *, u32 *);
int sblive_waveinFillSilence(struct sblive_wavein *, struct wave_in *, u32 *);
int sblive_waveinSetControl(struct sblive_wavein *, struct wave_in *, u32, u32 *);
int sblive_waveinGetControl(struct sblive_wavein *, struct wave_in *, u32, u32 *);
int sblive_waveinSetMaxInst(struct sblive_wavein *, u32);
int sblive_waveinGetProperties(struct sblive_wavein *, struct sblive_waveprops *);

#endif //_CARDWAVEIN_H_
