/*     
 **********************************************************************
 *     cardwo.h -- header file for card wave out functions
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _CARDWAVEOUT_H_
#define _CARDWAVEOUT_H_

#include "icardwav.h"

#include "mymix.h"


struct wave_xferbuf 
{
	u32     xferpos;
	u32     xferbufsize;     /* transfer buffer size */
	u32     numpages;        /* number of pages in transfer buffer */
	u8     *xferbuffer;      /* pointer to the transfer buffer */
	u32     format;
	int     is_stereo;
	int     is16bit;
	u32     conv;
	u32     interpolationbytes;
	u32     offset;          /* used for non-pagealigned buffer in P10 */
	u32     stopposition;
};

typedef struct tCARDMIXEROBJ  *PCARDMIXEROBJ;

struct wave_out
{
    struct wave_out  *next;
    u32             status;
    u32             state;
    int              synchstart;
    CALLBACKFN          CallbackFn;
    struct emu_voice *emu_voice;
    struct emu_timer *emu_timer;
    struct emu_page *emuaddr;
    struct wave_xferbuf *wavexferbuf;
    u32             memhandle;
    u32             refdata;
    u32             callbacksize;
    u32             localvol;
    u32             localreverb;
    u32             localchorus;
    u32             globalvolFactor;
    u32             globalreverbFactor;
    u32             globalchorusFactor;
    u32             process_id;        /* used for synchonize start */
    int              setpos;
    u32             position;
    short               ZL[6];              /* for pre-comp */
    short               ZR[6];              /* for pre-comp */
    struct wave_format      wave_fmt;
    u32             playflags;

    CTDPC               dsDpc;
};



/* sblive_wave states */
#define CARDWAVE_STATE_STOPPED      0x0001
#define CARDWAVE_STATE_STOPPING     0x0008
#define CARDWAVE_STATE_STARTED      0x0002
#define CARDWAVE_STATE_SUSPEND      0x0004


/* transfer buffer format */
#define M8                          0x00
#define M16                         0x01
#define S8                          0x02
#define S16                         0x03

#define INTERPOLATION_BYTES         8
/* setting this to other than a power of two
   may break some applications */
#define WAVEOUT_MAXBUFSIZE          262144
#define WAVEOUT_MINBUFSIZE	    128

/* time to play a fragment in ms (latency) */
#define WAVEOUT_DEFAULTFRAGLEN      50
/* time to play the entire buffer in ms */
#define WAVEOUT_DEFAULTBUFLEN       1000 

//
// Default Names for our Controls
//
  
#define MAX_WAVE_CONTROL_NAMES      2
#define WAVE_VOLUMECONTROL          0x0000
#define WAVE_MUTECONTROL            0x0001

#define CARDWAVE_DEFAULT_MAXPLAYINST    64

struct woinst {
        struct wave_out *wave_out;
        struct wave_format wave_fmt;
        u16 ossfragshift;
        u32 fragment_size;
        u32 numfrags;
#if LINUX_VERSION_CODE < 0x020301
        struct wait_queue *wait_queue;
#else
        wait_queue_head_t wait_queue;
#endif /* LINUX_VERSION_CODE < 0x020301 */
        int mapped;
        u32 total_copied;
        u32 total_played;
        int silence_filled;
        u32 silence_start;
        u32 getoptr_blocks;
	u32 wave_ptr;
	spinlock_t lock;
};

struct sblive_waveout
{
    DECLMAGIC

    PCARDMIXEROBJ   mixer;
    int          fWhql;

    struct wave_caps    caps;
    u32         numplaybackinst;
    u32         maxnumplayinst;    /* maximum no. of wave instances supported */
    struct wave_out *wave_outlist;
    u32         globalvol;
    u32         mute;
    u32         left;
    u32         right;
    u32         globalreverb;
    u32         globalchorus;
    u32         lineid;
    u32         ctrlid;
};

int sblive_waveoutInit(struct sblive_waveout *, u8 *);
int sblive_waveoutExit(struct sblive_waveout *);
int sblive_waveoutSetPowerState(struct sblive_hw *, u32 );
int sblive_waveoutGetCaps(struct sblive_waveout *, struct wave_caps *);
int sblive_waveoutQueryFormat(struct sblive_waveout *, struct wave_format *, u32);
int sblive_waveoutOpen(struct sblive_hw *, struct wave_format *, CALLBACKFN, u32, u32 *, u32, struct wave_out **);
int sblive_waveoutClose(struct sblive_hw *, struct wave_out *);
int sblive_waveoutGetBuffer(struct sblive_waveout *, struct wave_out *, u32 *, u8 **);
int sblive_waveoutSetBuffer(struct sblive_hw *, struct wave_out *, u32, void *, u32 *, u32);
int sblive_waveoutStart(struct sblive_hw *, struct wave_out *);
int sblive_waveoutStop(struct sblive_hw *, struct wave_out *, u32 *);
int sblive_waveoutGetPosition(struct sblive_waveout *, struct wave_out *, u32 *);
int sblive_waveoutSetPosition(struct sblive_hw *, struct wave_out *, u32);
int sblive_waveoutGetXferSize(struct sblive_waveout *, struct wave_out *, u32 *, u32 *);
int sblive_waveoutXferData(struct sblive_waveout *, struct wave_out *, u8 *, u32 *);
int sblive_waveoutFillSilence(struct sblive_waveout *, struct wave_out *, u32 *);
int sblive_waveoutSetControl(struct sblive_hw *, struct wave_out *, u32, u32 *);
int sblive_waveoutGetControl(struct sblive_waveout *, struct wave_out *, u32, u32 *);
int sblive_waveoutSetMaxInst(struct sblive_waveout *, u32);
int sblive_waveoutGetProperties(struct sblive_waveout *, struct sblive_waveprops *);

#endif //_CARDWAVEOUT_H_

