/*     
 **********************************************************************
 *     sblive_fx.c
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#include "hwaccess.h"
#include "efxmgr.h"

int sblive_fxInit(struct sblive_hw * sb_hw)
{
	int i;
	u32 z, w, x, y, pc = 16;

	for (i = 0; i < 512; i++) {
		halEfxWrite(sb_hw, 0x00000400 + (i * 2), 0x10040);
		halEfxWrite(sb_hw, 0x00000400 + (i * 2 + 1), 0x610040);
	}

	for (i = 0; i < 256; i++)
		halEfxWrite(sb_hw, 0x00000100 + i, 0);

	w = 1;
	x = 1;
	y = 0x40;
	z = 0x100;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x100;
	x = 0x100;
	y = sb_hw->bIsAPS ? 0x17 : 0x40;
	z = 0x101;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x101;
	x = 0x40;
	y = 0x13;
	z = 0x21;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;


	w = 0x101;
	x = 0x40;
	y = 0x13;
	z = 0x23;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x40;
	y = 0x40;
	z = 0x25;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x27;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x101;
	x = 0x40;
	y = 0x13;
	z = 0x29;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x11;
	y = 0x40;
	z = 0x2B;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0;
	x = 0;
	y = 0x40;
	z = 0x102;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x102;
	x = 0x102;
	y = sb_hw->bIsAPS ? 0x16 : 0x40;
	z = 0x103;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x103;
	x = 0x40;
	y = 0x12;
	z = 0x20;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;


	w = 0x103;
	x = 0x40;
	y = 0x12;
	z = 0x22;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x40;
	y = 0x40;
	z = 0x24;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x26;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x103;
	x = 0x40;
	y = 0x12;
	z = 0x28;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x10;
	y = 0x40;
	z = 0x2A;
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2), (x << 10) | y);
	halEfxWrite(sb_hw, 0x00000400 + (pc * 2 + 1), (6 << 20) | (z << 10) | w);
	++pc;

	sblive_writesynth(sb_hw, 0x00520000, 0);

	return CTSTATUS_SUCCESS;
}


int sblive_fxExit(struct sblive_hw * sb_hw)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxLoadEffect
 *
 * Input    : sb_hw - pointer to hardware object
 *            InitFXS - pointer to FXS initialization array
 *            effectbuf - pointer to micro code words buffer
 *            bufsize - no. of micro code words
 *
 * About    : load effects. Different object code ID is referring to
 *            different FXS registers initialization table.           
 */
 
int sblive_fxLoadEffect(struct sblive_hw * sb_hw, u32 *initFXS, u16 *effectbuf, u32 bufsize)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxSetControl
 *
 * Input    : sb_hw - pointer to hardware object
 *            numUCPos - no. of micro code positions to change
 *            CPos - pointer to micro code position array
 *            pvalue - pointer to the micro code value to be set
 *
 * About    : set control value for a particular control
 */
 
int sblive_fxSetControl(struct sblive_hw * sb_hw, u32 numUCpos, u32 * UCpos, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxGetControl
 *
 * Input    : sb_hw - pointer to hardware object
 *            controlid - control ID
 *            pvalue - pointer to the control value to be set
 *
 * About    : get control value for a particular control
 */
 
int sblive_fxGetControl(struct sblive_hw * sb_hw, u32 controlid, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxSetReverb 
 *
 * Input    : sb_hw - pointer to hardware object   
 *            pvalue - pointer to the reverb variation to be set 
 *
 * About    : set reverb variation 
 */
 
int sblive_fxSetReverb(struct sblive_hw * sb_hw, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxSetChorus 
 *
 * Input    : sb_hw - pointer to hardware object 
 *            pvalue - pointer to the chorus variation to be set
 *
 * About    : set chorus variation
 */
 
int sblive_fxSetChorus(struct sblive_hw * sb_hw, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxSetBass
 *
 * Input    : sb_hw - pointer to hardware object
 *            pvalue - pointer to the bass variation to be set
 *
 * About    : set bass variation
 */

int sblive_fxSetBass(struct sblive_hw * sb_hw, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxSetTreble
 *
 * Input    : sb_hw - pointer to hardware object
 *            pvalue - pointer to the treble variation to be set
 *
 * About    : set treble variation
 */

int sblive_fxSetTreble(struct sblive_hw * sb_hw, u32 * pvalue)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxOnOffControl
 *
 * Input    : sb_hw - pointer to hardware object
 *            controlclass - control classification
 *            onoff - ON or OFF
 *
 * About    : turn ON or OFF a particular control
 */

int sblive_fxOnOffControl(struct sblive_hw * sb_hw, u32 controlclass, int onoff)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxOffAudio
 *
 * Input    : sb_hw - pointer to hardware object
 *
 * About    : turn off output audio
 */

int sblive_fxOffAudio(struct sblive_hw * sb_hw)
{
	return CTSTATUS_SUCCESS;
}


/*
 * Function : sblive_fxOnAudio
 *
 * Input    : sb_hw - pointer to hardware object
 *
 * About    : turn on output audio
 */

int sblive_fxOnAudio(struct sblive_hw * sb_hw)
{
	return CTSTATUS_SUCCESS;
}
