/*     
 **********************************************************************
 *     sblive_fx.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _EFFECTMGR_H
#define _EFFECTMGR_H

#define TANKMEM_16K                16384
#define TANKMEM_64K                65536

#define DEFAULT_REVERB_VAR              4
#define DEFAULT_CHORUS_VAR              2
#define DEFAULT_BASS_VAR                5
#define DEFAULT_TREBLE_VAR              5
#define DEFAULT_STEREOENHANCEMENT_VAR   0

/* FXS registers initialization */
enum {
	INITFXS_TRAMDETECT = 0,
	INITFXS_DEFAULT
};

int sblive_fxInit(struct sblive_hw *);
int sblive_fxExit(struct sblive_hw *);
int sblive_fxDetectTRam(struct sblive_hw *, u32 *);
int sblive_fxLoadEffect(struct sblive_hw *, u32 *, u16 *, u32);
int sblive_fxSetControl(struct sblive_hw *, u32, u32 *, u32 *);
int sblive_fxGetControl(struct sblive_hw *, u32, u32 *);
int sblive_fxSetReverb(struct sblive_hw *, u32 *);
int sblive_fxSetChorus(struct sblive_hw *, u32 *);
int sblive_fxSetBass(struct sblive_hw *, u32 *);
int sblive_fxSetTreble(struct sblive_hw *, u32 *);
int sblive_fxOnOffControl(struct sblive_hw *, u32, int);
int sblive_fxOffAudio(struct sblive_hw *);
int sblive_fxOnAudio(struct sblive_hw *);

#endif				// _EFFECTMGR_H
