/*     
 **********************************************************************
 *     emuadxmg.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _EMUADXMG_H
#define _EMUADXMG_H

struct emuaddr_allocdesc
{
    struct sblive_hw *      sb_hw;
    u32     ownertype;
    CALLBACKFN  callback;
    u32     callback_data;
    u32     size;     /* Size in bytes requested */
    u32     flags;    /* stereo/mono  8/16 */
};

struct emu_page
{
    u16  flags;
    struct sblive_hw *sb_hw;
    u32 emustartaddr;
};

struct emu_addrmgr
{
    struct emu_page emupagetable[MAXPAGES];
};

int emu10kaddxmgrInit(struct sblive_hw *);
int emu10kaddxmgrExit(struct sblive_hw *);
int emu10kaddxmgrAlloc(struct emuaddr_allocdesc *,struct emu_page *  *);
int emu10kaddxmgrFree(struct emu_page *);

#endif
