/**********************************************************************
 *     isblive_mix.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _ICARDMIXER_H_
#define _ICARDMIXER_H_

#define MAX_SHORTNAME_CHARS     16
#define MAX_LONGNAME_CHARS      64
#define MAX_CARDMIXER_DESC      80

struct tCARDMIXERCAPS
{
    u32 product_id;
    u32 numdest;
    u8  cardmixerdesc[MAX_CARDMIXER_DESC];
};

typedef struct tCARDMIXERCAPS CARDMIXERCAPS;
typedef struct tCARDMIXERCAPS  *PCARDMIXERCAPS;

/*
**  Mixer Destinations
*/
struct tDESTDETAILS
{
    u32 componenttype;            //Dest Component Type
    u32 channels;                 //Num of Channels
    u32 sources;                  //Num of Sources at dest
    u32 controls;                 //Num of Controls at dest
    u8  shortname[MAX_SHORTNAME_CHARS];
    u8  longname[MAX_LONGNAME_CHARS];
};

typedef struct tDESTDETAILS DESTDETAILS;
typedef struct tDESTDETAILS  *PDESTDETAILS;


/*
**  Mixer Sources
*/
struct tSOURCEDETAILS
{
    u32 componenttype;            // Source Component Type
    u32 targettype;               // Source Target Type
    u32 channels;                 // Num of Channels
    u32 controls;                 // Num of Controls at source
    u32 isactive;                  // status of source
    u8  shortname[MAX_SHORTNAME_CHARS];
    u8  longname[MAX_LONGNAME_CHARS];
    struct {
        u32 type;                 /* MIXERLINE_TARGETTYPE_xxxx */
        u32 deviceID;             /* target device ID of device type */
        u16  manufacturer_id;                   /* of target device */
        u16  product_id;                   /*        " */
        u16  driver_version;         /*      " */
        u8  product_name[MAXPNAMELEN];   /*      " */
    } Target;
};

typedef struct tSOURCEDETAILS SOURCEDETAILS;
typedef struct tSOURCEDETAILS  *PSOURCEDETAILS;

/*
**  Mixer Controls
*/
struct tCONTROLDETAILS
{
    u32 controltype;              // Control Type
    u32 channels;                 // Num of Channels
    u32 fcontrol;			// Flag
    u32 mivalue, maxvalue;     // Range
    u32 steps;                    // Steps
    u8  shortname[MAX_SHORTNAME_CHARS];
    u8  longname[MAX_LONGNAME_CHARS];
};

typedef struct tCONTROLDETAILS CONTROLDETAILS;
typedef struct tCONTROLDETAILS  *PCONTROLDETAILS;

struct tCONTROLCHANGEDETAILS
{
    u32     destid;
    u32     sourceid;
    u32     controlid;
    u32     leftvalue;
    u32     rightvalue;
};

typedef struct tCONTROLCHANGEDETAILS CONTROLCHANGEDETAILS;
typedef struct tCONTROLCHANGEDETAILS  *PCONTROLCHANGEDETAILS;

typedef u32 (*GETSETCONTROLFN)(u32,u32,u32,u32);
typedef GETSETCONTROLFN  * PGETSETCONTROLFN;


typedef struct tICARDMIXER ICARDMIXER, *PICARDMIXER;
typedef struct tICARDMIXER  *( *PPICARDMIXER);


struct mixer_ops
{
    int    (*sblive_mixerGetCaps)( PICARDMIXER, PCARDMIXERCAPS );
    int    (*sblive_mixerOpen)( PICARDMIXER, CALLBACKFN, u32, u32 * );
    int    (*sblive_mixerClose)( PICARDMIXER, u32 );
    int    (*sblive_mixerGetDestDetails)( PICARDMIXER, u32, PDESTDETAILS );
    int    (*sblive_mixerGetSourceDetails)( PICARDMIXER, u32, u32, PSOURCEDETAILS );
    int    (*sblive_mixerGetControlDetails)( PICARDMIXER, u32, u32, u32, PCONTROLDETAILS );
    int    (*sblive_mixerGetControlValue)( PICARDMIXER, u32, u32, u32, u32 *, u32 * );
    int    (*sblive_mixerSetControlValue)( PICARDMIXER, u32, u32, u32, u32, u32 );
    int    (*sblive_mixerAddDest)( PICARDMIXER, PDESTDETAILS, u32 * );
    int    (*sblive_mixerAddSource)( PICARDMIXER, u32, PSOURCEDETAILS, u32 * );
    int    (*sblive_mixerAddControl)( PICARDMIXER, u32, u32, PCONTROLDETAILS, GETSETCONTROLFN, u32, u32 *);
    int    (*sblive_mixerHookControl)( PICARDMIXER, u32, u32, u32, GETSETCONTROLFN, u32, PGETSETCONTROLFN, u32 *);
    int    (*sblive_mixerLineChange)( PCARDMIXEROBJ, u32, u32);
    int    (*sblive_mixerLineDisable)( PCARDMIXEROBJ, u32, u32, u32);
};

struct tICARDMIXER
{
    struct mixer_ops * ops;
};

// CardMixer Events
#define CARDMIXER_EVENT_CONTROLCHANGE   0x00000000
#define CARDMIXER_EVENT_LINECHANGE   0x00000001

#endif // _ICARDMIXER_H_
