/*     
 **********************************************************************
 *     irq.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _IRQ_H_
#define _IRQ_H_

#define IRQ_MAX 		2
#define ISR_STACKSIZE	0x1000

struct sblive_irq
{
        u32         ID;

	u32		status;
	unsigned long	irq;
	CALLBACKFN	callback;
	u32		refdata;
};

int	irqInit(struct sblive_irq *irq_ptr, u8 irq, CALLBACKFN callback, u32 refdata);
int	irqExit(struct sblive_irq * irq_ptr);
int	irqAcquire(struct sblive_irq * irq_ptr);
int	irqRelease(struct sblive_irq * irq_ptr);
int	irqStart(struct sblive_irq * irq_ptr);
int	irqStop(struct sblive_irq * irq_ptr);
int	irqAcknowledge(struct sblive_irq * irq_ptr);


#endif //_IRQ_H_

