/*     
 **********************************************************************
 *     osutils.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _OSUTILS_H_
#define _OSUTILS_H_

#ifdef __cplusplus
extern "C" {
#endif



#if !defined(DLIST)
#define DLIST(x)    struct {x  *next,  *pPrev;} DList


#define dlAddNode(list,node) {(node)->DList.next = *(list); (node)->DList.pPrev = NULL; if (*list) (*(list))->DList.pPrev = (node); *(list) = (node);}

#define dlDelNode(list, node) {if ((node)->DList.pPrev == NULL) *(list) = (node)->DList.next; else ((node)->DList.pPrev)->DList.next = (node)->DList.next; if ((node)->DList.next != NULL) ((node)->DList.next)->DList.pPrev = (node)->DList.pPrev; (node)->DList.next = (node)->DList.pPrev = NULL;}


#define dlFirstNode(list)       (*(list))
#define dlNextNode(curnode)     ((curnode)->DList.next)
#define dlPrevNode(curnode)     ((curnode)->DList.pPrev)
#endif


typedef struct memhandle {
	unsigned long physaddx;
	void *virtaddx;
	u32 order;
} LMEMHANDLE, *PLMEMHANDLE;

typedef u16 HARDCRITICALSECTION,  * PHARDCRITICALSECTION;

typedef struct tCTDPC {
	CALLBACKFN DPCCallBackFn;
	u32 refdata;
	u32 param;
	int is_active;
} CTDPC,  * PCTDPC;

struct sblive_list {
	struct sblive_list  *next;
};

typedef struct tCTNOTIFYDATA {
	u32 refdata;
	u32 param1;
	u32 param2;
	u32 logicaltime;
} CTNOTIFYDATA,  * PCTNOTIFYDATA,  * ( * PPCTNOTIFYDATA);

typedef struct tCTNOTIFY {
	u32 callbackFn;
	u32 refdata;
	u32 msg;
	u32 param1;
	u32 param2;
} CTNOTIFY,  * PCTNOTIFY,  * ( * PPCTNOTIFY);


/****************************************************************
                    type define structure
 ***************************************************************/

#define MEM_NORMAL      0x0000

/****************************************************************
                        Function defination
 ***************************************************************/
int osAllocMemPhysical(u32, u32 *, void **, unsigned long *);
int osFreeMemPhysical(u32);
int osCopyPageTable(char *, u32, u32, u32 *);

int osListAttach(struct sblive_list ** head, struct sblive_list * new);
int osListRemove(struct sblive_list ** head, struct sblive_list * pDead);
struct sblive_list * osListGetNext(struct sblive_list * head, struct sblive_list * curr);
int osCallRing3(u32, u32, u32, u32, u32);
int osScheduleDPC(PCTDPC);
int osSetGlobalTimeOut(PCTDPC dpc, u32 timev, u32 * handle);
int osCancelGlobalTimeOut(u32 timeout);

void __cdecl osDbgOut(char *szFormat,...);

#ifdef __cplusplus
}

#endif
#endif				//_OSUTILS_H_
