/*     
 **********************************************************************
 *     platform.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#if !defined(_PLATFORM_H)
#define _PLATFORM_H


#include <linux/version.h>
//#include <linux/module.h>

#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/ioport.h>
#include <linux/sound.h>
#include <linux/malloc.h>
#include <linux/soundcard.h>
#if LINUX_VERSION_CODE < 0x020100
#include <linux/bios32.h>
#endif
#include <linux/pci.h>
#include <asm/io.h>
#include <asm/dma.h> 

#if LINUX_VERSION_CODE < 0x020100
typedef int spinlock_t;
#define SPIN_LOCK_UNLOCKED 0
#define spin_lock_init(lock) {}
#define spin_lock_irqsave(lock,flags) do { save_flags(flags); cli(); } while (0)
#define spin_unlock_irqrestore(lock,flags) restore_flags(flags)
#else // LINUX_VERSION_CODE
#if LINUX_VERSION_CODE < 0x020300
#include <asm/spinlock.h>
#endif /* LINUX_VERSION_CODE < 0x020300 */
#endif // LINUX_VERSION_CODE

#if defined(MANGLE_SYMS)
#include "symbols.h"
#endif

#include "haldefs.h"

#define _stdcall
#define __cdecl

#define min(x,y) ((x) < (y)) ? (x) : (y)

#include "creaf.h"
#include "osutils.h"
#include "cardcfg.h"
#include "dbg.h"

#endif  // _PLATFORM_H

