/*     
 **********************************************************************
 * 
 *     sndstat.h
 *     Copyright 1999, 2000 Creative Labs, Inc.
 * 
 *     This file uses some code from sound_config.h, Copyright 1993-
 *     1997, Hannu Savolainen
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

/*
 * Minor numbers for the sound driver.
 */

#define SND_NDEVS	256	/* Number of supported devices */
#define SND_DEV_CTL	0	/* Control port /dev/mixer */
#define SND_DEV_SEQ	1	/* Sequencer output /dev/sequencer (FM
				   synthesizer and MIDI output) */
#define SND_DEV_MIDIN	2	/* Raw midi access */
#define SND_DEV_DSP	3	/* Digitized voice /dev/dsp */
#define SND_DEV_AUDIO	4	/* Sparc compatible /dev/audio */
#define SND_DEV_DSP16	5	/* Like /dev/dsp but 16 bits/sample */
#define SND_DEV_STATUS	6	/* /dev/sndstat */
#define SND_DEV_AWFM	7	/* Reserved */
#define SND_DEV_SEQ2	8	/* /dev/sequencer, level 2 interface */
#define SND_DEV_SNDPROC 9	/* /dev/sndproc for programmable devices */
#define SND_DEV_PSS	SND_DEV_SNDPROC

#define SOUND_VERSION_STRING "3.8s2++-971130"

#define SELECTED_SOUND_OPTIONS		0x0

static int in_use = 0;
static int is_unloading = 0;

int sound_started = 0;
int soundcard_configured = 0;

#ifndef ONECARD
struct address_info {
	int io_base;
	int irq;
	int dma;
	int dma2;
	int always_detect;	/* 1=Trust me, it's there */
	char *name;
	int driver_use_1;	/* Driver defined field 1 */
	int driver_use_2;	/* Driver defined field 2 */
	int *osp;	/* OS specific info */
	int card_subtype;	/* Driver specific. Usually 0 */
	void *memptr;           /* Module memory chainer */
	int slots[6];           /* To remember driver slot ids */
};

struct driver_info 
{
	char *driver_id;
	int card_subtype;	/* Driver specific. Usually 0 */
	int card_type;		/*	From soundcard.h	*/
	char *name;
	void (*attach) (struct address_info *hw_config);
	int (*probe) (struct address_info *hw_config);
	void (*unload) (struct address_info *hw_config);
};

struct card_info 
{
	int card_type;	/* Link (search key) to the driver list */
	struct address_info config;
	int enabled;
	void *for_driver_use;
};


int num_sound_cards = 0;
struct card_info snd_installed_cards[20] = {{0}};

int num_sound_drivers = 0;
struct driver_info sound_drivers[20] = {{0}};

#define MAX_AUDIO_DEV   5
#define MAX_MIXER_DEV   5
#define DMA_DUPLEX      0x04

struct audio_operations *audio_devs[MAX_AUDIO_DEV] = {NULL}; 
int num_audiodevs = 0;

struct mixer_operations *mixer_devs[MAX_MIXER_DEV] = {NULL}; 
int num_mixers = 0;

#define CONFIG_AUDIO

#endif
