#include "overlay.h"
#include "XOverlay.h"
#include "dxr2-api.h"
#include <math.h>

dxr2_status_info_t* dxr2_info;

static float x_scale = 1;
static int y_scale = 1;

void init_overlay(int argc, char** argv, dxr2_status_info_t* _dxr2_info)
{
  geom_t geom;

  dxr2_info = _dxr2_info;

  geom.x = dxr2_info->overlay_pos.arg1 * x_scale;
  geom.y = dxr2_info->overlay_pos.arg2 - 10;
  geom.width = dxr2_info->overlay_dim.arg1 * x_scale;
  geom.height = dxr2_info->overlay_dim.arg2;

  init_win(&argc, argv, geom);
  set_geom_fn( &resize_overlay );
}

void dest_overlay()
{
  destwin();
}

int resize_overlay(geom_t geom)
{
  dxr2_info->overlay_pos.arg1 = geom.x / x_scale;
  dxr2_info->overlay_pos.arg2 = geom.y + 10;
  dxr2_info->overlay_dim.arg1 = geom.width / x_scale;
  dxr2_info->overlay_dim.arg2 = geom.height;

  dxr2_set_overlay_geom(geom);
}
