#include "XOverlay.h"
#include <X11/Xmu/Xmu.h>
#include <X11/Xlib.h>
#include "pthread.h"

static XtAppContext application;
static Widget toplevel;
static pthread_t x_thread;

static void resize_handle(Widget, XtPointer, XEvent*, Boolean*);
static void* x_loop(void*);

static int (*resize_fn)(geom_t);

void init_win(int* argc, char** argv, geom_t geom)
{
  Dimension x, y;
  int mask;

  printf("doing init.\n"); fflush(stdout);
  toplevel = XtAppInitialize(&application, "DxR2 Player",
			     NULL, 0,
			     argc, argv,
			     NULL,
			     NULL, 0);

  printf("doing init.\n"); fflush(stdout);

  
  mask = ResizeRedirectMask;

  XtMakeResizeRequest(toplevel, geom.width, geom.height, &x, &y);
  XtRealizeWidget(toplevel);
  XMoveWindow( XtDisplay(toplevel), XtWindow(toplevel), geom.x, geom.y);

  resize_fn=NULL;

  pthread_create(&x_thread, NULL, x_loop, NULL);
}

void* x_loop(void* arg)
{
  XEvent event;

  while (toplevel != NULL) /* forever */
    { 
      XtAppNextEvent(application, &event);

      /* Xevent read off queue */

      if(event.type == 22) { // Resize event
	resize_handle(toplevel, NULL, NULL, NULL);
      }

      XtDispatchEvent(&event);
    }
}

void destwin()
{
  pthread_kill( x_thread, 9 );
  XtDestroyWidget(toplevel);
  toplevel = NULL;
  resize_fn = NULL;
}

void resize_handle(Widget w, XtPointer passed_data, XEvent* event, Boolean* bool)
{
  XWindowAttributes attrib;
  Position x, y;
  geom_t geom;

  XGetWindowAttributes( XtDisplay(w), XtWindow(w) , &attrib );
  XtTranslateCoords(w, attrib.x, attrib.y, &x, &y);

  geom.x=x;
  geom.y=y;
  geom.width=attrib.width;
  geom.height=attrib.height;

  if(resize_fn==NULL) {
    printf("Xpos: %d   Ypos: %d\n", x, y);
    printf("Width: %d  Height: %d\n", attrib.width, attrib.height);
    printf("Border: %d\n", attrib.border_width);
  } else
    (*resize_fn)(geom);
}

int set_geom_fn( int (*fn)(geom_t))
{
  resize_fn = fn;
  return 1;
}
