#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include "multifile.h"
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/mman.h>
#include "ifo.h"
#include "vobtitle.h"

#define DVD_BLOCKSIZE	2048
#define IFO_HDR_LEN 8
#define OFFSET_START_TBL_CMD (12+8*2+32*4+8+16*PGCI_COLOR_LEN)
#define PGCI_COLOR_LEN 4
#define PGCI_SUB_LEN 8
#define CADDR_HDR_LEN 8
#define CADDR_LEN 12
#define OFFSET_VTS_LEN		0x000C

typedef struct {
	u_short	vob_id		: 16;	// Video Object Identifier
	u_int	cell_id		: 8;	// Cell Identifier
	u_char			: 8;	// don't know
	u_int	start		: 32;	// Cell start
	u_int	end		: 32;	// Cell end
} cell_addr_t;
	
typedef struct ifo_struct {
	char *ifo;
	char *start_ptt;
	char *start_title_pgci;
	char *start_menu_pgci;
	char *start_tmt;
	char *start_menu_cell_addr;
	char *start_menu_vobu_addr_map;
	char *start_title_cell_addr;
	char *start_title_vobu_addr_map;
} ifo_t;

typedef struct {
	u_short num	: 16;	// number of entries
	u_short		: 16;	// don't known (reserved?)
	u_int	len	: 32;	// length of table
} ifo_hdr_t;

typedef struct {
	u_short id		: 16;	// Language
	u_short			: 16;	// don't know
	u_int	start		: 32;	// Start of unit
} pgci_sub_t;

typedef struct {
	u_short	num		: 16;	// Number of Video Objects
	u_short unknown		: 16;	// don't know
	u_int	len		: 32;	// length of table
} cell_addr_hdr_t;

int ifo_is_vts (int fd)
{
        char ptr_descr[13];

        lseek (fd, 0, SEEK_SET);

        read (fd, ptr_descr, 12);
        ptr_descr[12] = '\0';

        if (!strcmp (ptr_descr, "DVDVIDEO-VTS")) {
		return 1;
	}

	return 0;
}

static size_t ifo_get_len (int fd, int offset)
{
	u_int ptr_len;
	size_t len;

	lseek (fd, offset, SEEK_SET);
	read (fd, &ptr_len, 4);

	len = ntohl (ptr_len); // * 0x800; 

	return len;
}

static void *_ifo_mmap (int fd, size_t len)
{
	void *ret;

	if ((ret = mmap (0, len, PROT_READ, MAP_SHARED, fd, 0)) < 0) {
		fprintf (stderr, "%s/%d: unable to mmap\n",
			__FILE__, __LINE__);
	}

	return ret;
}

u_int get4bytes (u_char *buf)
{
        u_int ret;

        ret  = buf[0] << 24;
        ret |= buf[1] << 16;
        ret |= buf[2] << 8;
        ret |= buf[3];

	return ret;
}

u_int get2bytes (u_char *buf)
{
        u_int ret;

        ret = buf[0] << 8;
        ret |= buf[1];

        return ret;
}

void ifo_pars(vob_info_t* vob_info){
  ifo_t *ifo;
  u_char *ptr;
  cell_addr_hdr_t *cell_addr_hdr;
  int fd;
  offset_t len;
  u_int num_cells;
  u_int start_program_map;
  int i;
  u_char *ptr_pgc;
  u_char *ptr_pgci,*ptr_prog;
  ifo_hdr_t *hdr;
  u_int *start_list;
  call_stack_t *tmp_call_stack;

  if ((fd = open (vob_info->ifo_file, O_RDONLY)) < 0) {
    fprintf (stderr, "error opening ifo file %s.\n",vob_info->ifo_file);
    vob_info->use_ifo=0;
    return;
  }
  vob_info->use_ifo=1;

  if (!(ifo = (ifo_t *) malloc (sizeof (ifo_t)))) {
    fprintf (stderr, "%s/%d: memory squeeze\n", __FILE__, __LINE__);
    vob_info->use_ifo=0;
    return;
  }
  
  if (!(len = ifo_get_len (fd, OFFSET_VTS_LEN))) {
    fprintf (stderr, "%s/%d: len @ offset 0x%x is ZERO\n",
	     __FILE__, __LINE__, OFFSET_VTS_LEN);
  }
  
  ifo->ifo = _ifo_mmap (fd, len);
  
  // Get address of pgci "Used in metode=1" 
  ifo->start_title_pgci		= get4bytes (ifo->ifo + 0xCC)
    ? ifo->ifo + get4bytes (ifo->ifo + 0xCC) * DVD_BLOCKSIZE : 0;
  // Get address of cell info "Used to get correct playing siquenc in the vob" 
  ifo->start_title_cell_addr	= get4bytes (ifo->ifo + 0xE0)
    ? ifo->ifo + get4bytes (ifo->ifo + 0xE0) * DVD_BLOCKSIZE : 0;
  
  // Is it a file stream IFO file
  if (ifo_is_vts (fd)) {
    // Find start of pgci.
    ptr_pgci = (u_char *) ifo->start_title_pgci;
    hdr = (ifo_hdr_t *) ptr_pgci;
    
    if (!ptr_pgci)
      return;
    start_list = (u_int *) calloc (ntohs (hdr->num), sizeof (u_int));
    
    ptr_pgci += IFO_HDR_LEN;
    
    for (i=0; i<ntohs(hdr->num); i++) {
      pgci_sub_t *pgci_sub = (pgci_sub_t *) ptr_pgci;
      
      start_list[i] = ntohl (pgci_sub->start);
      
      ptr_pgci += PGCI_SUB_LEN;
    }
    
    
    ptr_pgc = (u_char *) hdr + start_list[0];
    if (!ptr_pgc)
      return;
    ptr_pgc+=2; // Her pgc starts.
    num_cells = *ptr_pgc++;
    vob_info->num_cell_addr = *ptr_pgc++;	
    
    ptr_pgc += OFFSET_START_TBL_CMD - 2;
    start_program_map	 = get2bytes (ptr_pgc);
    // Store the program map in vob_info.
    if (start_program_map){
      ptr_prog=start_program_map+(u_char *) hdr + start_list[0];
      vob_info->ptr_pc=(u_char *)malloc(sizeof(u_char)*(vob_info->num_cell_addr-1));
      for (i=1; i<vob_info->num_cell_addr; i++) {
	vob_info->ptr_pc[i-1]=*ptr_prog;
	ptr_prog++;
      }
    }else{
      ptr_prog==NULL;
    }
    ptr=ifo->start_title_cell_addr;
    // Find start of cell map.
    cell_addr_hdr = (cell_addr_hdr_t *) ptr;
    if (!ptr)
      return;
    
    //    len=ntohl (cell_addr_hdr->len)*0x800;
    ptr += CADDR_HDR_LEN; // This is the start of the cell map.
    
  }else{
    vob_info->use_ifo=0;
    return;
  }
  // Copy info about vob navigation in a usable form.
  vob_info->call_stack=(call_stack_t *)malloc(sizeof(call_stack_t)*(vob_info->num_cell_addr-1));
  vob_info->num_cell_addr=0;
  i=0;

  while (ptr<((u_char *) cell_addr_hdr) + ntohl (cell_addr_hdr->len)){
    vob_info->num_cell_addr++;
    vob_info->call_stack[i].vob_id=ntohs(((cell_addr_t *)ptr)->vob_id);
    vob_info->call_stack[i].cell_id=((cell_addr_t *)ptr)->cell_id;
    vob_info->call_stack[i].start=ntohl(((cell_addr_t *)ptr)->start);
    vob_info->call_stack[i].end=ntohl(((cell_addr_t *)ptr)->end);
    vob_info->call_stack[i].next=(call_stack_t *)malloc(sizeof(call_stack_t));
    tmp_call_stack=&vob_info->call_stack[i];
    ptr += CADDR_LEN; 
    while(ptr<((u_char *) cell_addr_hdr) + ntohl (cell_addr_hdr->len) &&
	  ntohs (((cell_addr_t *)ptr)->vob_id)==i ){
      tmp_call_stack=tmp_call_stack->next;
      tmp_call_stack->vob_id=ntohs(((cell_addr_t *)ptr)->vob_id);
      tmp_call_stack->cell_id=((cell_addr_t *)ptr)->cell_id;
      tmp_call_stack->start=ntohl(((cell_addr_t *)ptr)->start);
      tmp_call_stack->end=ntohl(((cell_addr_t *)ptr)->end);
      tmp_call_stack->next=(call_stack_t *)malloc(sizeof(call_stack_t));
      ptr += CADDR_LEN; 
    }
    tmp_call_stack->next=NULL;
    i++;
  }
  free(ifo);
  free(start_list);
}
