#include "player.h"
#include "multifile.h"
#include "ifo.h"

static call_stack_t* cell_stack;
static int id;
static int current;
static player_info_t* player_info;
static offset_t offset;
static int skip_angles;
static int angle;
static int metode;
static vob_info_t vob_info;
static unsigned long elapsed_secs;
static int frame_tics;
static scan_forwards;

static void free_mem(player_info_t*);
static offset_t vob_recenter_cell(offset_t);
static offset_t vob_next_cell(offset_t);

int open_vob(char* file_name)
{
  char** names = generate_filenames(file_name);

  print_info("VOB title\n");
  strcpy(vob_info.ifo_file,file_name);
  if(file_name[strlen(vob_info.ifo_file) - 1]=='B'){
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 5]='0';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 3]='I';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 2]='F';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 1]='O';
  }else{
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 5]='0';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 3]='i';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 2]='f';
    vob_info.ifo_file[strlen(vob_info.ifo_file) - 1]='o';
  }
  elapsed_secs=0;
  frame_tics=0;
  ifo_pars(&vob_info);
  scan_forwards=0;

  if(vob_info.use_ifo) {
    current = 0;
    cell_stack = &vob_info.call_stack[0];
    id = cell_stack->cell_id;
    metode = 0;
    angle = 0;
    skip_angles=0;
    offset = cell_stack->start;

    if(cell_stack->next!=NULL && id==cell_stack->next->cell_id){  
      // We don't have cell_id info in call_stac so try using pc in stead.
      metode=1;
      if(vob_info.ptr_pc!=NULL) 
	cell_stack=&vob_info.call_stack[vob_info.ptr_pc[current]];
      else
	cell_stack=&vob_info.call_stack[current]; // No pc use simpel counter.
    }

    return multi_open(names);
  }
  else return -1;
}

offset_t vob_read(char* buffer, int len)
{
  offset_t size = -1;
  int vob_id = cell_stack->vob_id;
  unsigned long secs, mins, hrs;

  if(vob_info.use_ifo){
    size=-1;

      if(offset == -1) {
	offset = vob_next_cell(offset);
	offset = multi_lseek(offset-1, SEEK_SET);
      }

      if(scan_forwards) {
	print_info("scanning!\n");
	offset +=  FRAME_SIZE / 0x800;
	vob_lseek(offset, SEEK_SET);
	scan_forwards=0;
      }

      while(offset >= cell_stack->end && offset != -1) {
	offset = vob_next_cell(offset);
	offset = multi_lseek(offset-1, SEEK_SET);
      }

      if(offset == -1)
	return -1;
      // Read date 0x800 is to get around addressing problems.
      // 0x10 = framesize / 0x800
      if(offset+0x10 <= cell_stack->end){
	size = multi_read(buffer, FRAME_SIZE);
	offset += FRAME_SIZE / 0x800;
      }
      else { // not a full frame.
	//offset += 10;
	size = multi_read(buffer, (cell_stack->end - offset) * 0x800);
	offset = cell_stack->end;
      }
  }
  else{
    size = multi_read(buffer, FRAME_SIZE);
  }

  if(size > 0) {
    frame_tics = (frame_tics+1) % 30;
    if(frame_tics==0)
      ++elapsed_secs;
  }

  return size;
}

void close_vob(){
  int i;
  call_stack_t *cell_stack,*cell_stack1;
  free(vob_info.ptr_pc);
  vob_info.ptr_pc=NULL;  
  for(i=0;i<vob_info.num_cell_addr-1;i++){
    cell_stack=vob_info.call_stack[i].next;
    while(cell_stack->next!=NULL){
      cell_stack1=cell_stack;
      cell_stack=cell_stack->next;
      free(cell_stack1);
    }
    free(cell_stack);
    vob_info.call_stack[i].next=NULL;
  }  
}

offset_t vob_lseek(offset_t new_offset, int type)
{
  offset = multi_lseek(new_offset, type);

  return vob_recenter_cell(offset);
}

offset_t vob_recenter_cell(offset_t _offset)
{
  offset_t new_offset;

  current = 0;
  cell_stack = vob_info.call_stack;

  while(_offset >= cell_stack->end)
    new_offset = vob_next_cell(_offset);

  offset = multi_lseek(_offset, SEEK_SET); 

  return offset;
}

offset_t vob_next_chapter()
{
  int vob_id = cell_stack->vob_id;
  offset_t _offset = offset;

  if(vob_id+1 >= vob_num_chapters())
    return _offset;

  while(cell_stack != NULL && cell_stack->vob_id <= vob_id)
    vob_next_cell(cell_stack->end);

  offset = multi_lseek(cell_stack->start, SEEK_SET);

  return offset;
}

offset_t vob_prev_chapter()
{
  return vob_chapter_seek(cell_stack->vob_id - 1);
}

int vob_num_chapters()
{
  return vob_info.num_cell_addr-1;
}

offset_t vob_chapter_seek(int vob_id)
{
  offset_t _offset = offset;

  if(vob_id < 0 || vob_id >= vob_num_chapters())
    return _offset;

  if(vob_id >= cell_stack->vob_id)
    while(vob_id > cell_stack->vob_id && vob_id < vob_num_chapters())
      _offset = vob_next_chapter(_offset);
  else {

    current = 0;
    cell_stack = vob_info.call_stack;

    while(cell_stack != NULL && vob_id > cell_stack->vob_id)
      vob_next_cell(cell_stack->end);

    _offset = multi_lseek(cell_stack->start, SEEK_SET); 
  }

  offset = _offset;

  return _offset;
}

offset_t vob_next_cell(offset_t offset)
{
  print_info("New cell needed at offset %x.\n", offset);
  if(cell_stack->next!=NULL){ // More movie in current vob_id.
    if(cell_stack->next->next!=NULL && cell_stack->start==cell_stack->next->start){ 
      // Don't play the same again
      cell_stack=cell_stack->next->next;
    }else{
      cell_stack=cell_stack->next;
    }
  }else{
    print_info("New stack needed.\n");
    // We need to find a new vob_id to play from.
    if(id!=-1) // Reinitialize id.
      id=cell_stack->cell_id;

    current++; // Next vob_id
    print_info("Selected stack %d\n", current);

    if(current>=vob_info.num_cell_addr){ // Are We at the end of the movie.
      return -1;
    }

    if(metode==1){ // Metode 1 Navigation via pc and call_stack.
      if(vob_info.ptr_pc!=NULL)
	cell_stack=&vob_info.call_stack[vob_info.ptr_pc[current]];
      else
	cell_stack=&vob_info.call_stack[current]; // No pc use simple counter.
    }else{ // Navigation via call_stack only
      cell_stack=&vob_info.call_stack[current];
    }

    if(cell_stack->next!=NULL){ // There is more than one cell in this vob_id.
      // For now just play the first angle.  Make this selectable later.
      if(skip_angles==0){ 
	// Is this multiangled.
	if(cell_stack->next!=NULL&&cell_stack->cell_id==cell_stack->next->cell_id) {
	  int angle_choice=angle;
	  while(angle_choice > 0 && cell_stack->next!=NULL&&cell_stack->cell_id==cell_stack->next->cell_id){
	    ++current;
	    --angle_choice;
	    if(current>=vob_info.num_cell_addr){
	      return -1;
	    }
	    cell_stack=&vob_info.call_stack[current];
	    //	  cell_stack=cell_stack->next;
	  }
	  
	  // if more angle left, skip them.
	  skip_angles = cell_stack->next!=NULL && cell_stack->cell_id==cell_stack->next->cell_id;
	}
      }else{
	// OK We are in a multiangled section.
	// We need a cell_id difrent from the one We have now.
	while(cell_stack->next!=NULL&&cell_stack->cell_id==cell_stack->next->cell_id){
	  ++current;
	  if(current>=vob_info.num_cell_addr){
	    return -1;
	  }
	  cell_stack=&vob_info.call_stack[current];
	  //	  cell_stack=cell_stack->next;
	}
	// Now We are out of the multiangled part.
	angle=0;
      }

      // cell_id has to change when vob_id change.
      while(id==cell_stack->cell_id){
	if(cell_stack->next!=NULL){
	  cell_stack=cell_stack->next;
	}else{
	  current++;
	  if(current>=vob_info.num_cell_addr){
	    return -1;
	  }
	  cell_stack=&vob_info.call_stack[current];
	}
      }
    }else{
      id=-1;
    }
  }

  return cell_stack->start;
}      

int vob_choose_angle(int new_angle)
{
  angle = new_angle;
  return angle;
}


int vob_scan_forwards()
{
  scan_forwards=1;
}
