/*     
 **********************************************************************
 *     cardmo.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 *     November 2, 1999     Alan Cox	    cleaned up
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _CARDMO_H_
#define _CARDMO_H_

#include "icardmid.h"


#define MIDIOUT_MAX_BUFFER_SIZE     16  // Definition for struct sblive_mpuout

struct sblive_mpuout
{
    DECLMAGIC

    u32             status;
    u32             state;
    volatile int    intr;
    struct midi_queue *firstmidiq;
    struct midi_queue *lastmidiq;
    u8                laststatus;
    CTDPC             dpc;
    spinlock_t        lock;
    struct midi_caps        caps;
    struct midi_openinfo    openinfo;
};

#define CARDMIDIOUT_STATE_DEFAULT    0x00000000
#define CARDMIDIOUT_STATE_SUSPEND    0x00000001

int sblive_mpuoutInit( struct sblive_mpuout *, struct sblive_hw * );
int sblive_mpuoutExit( struct sblive_hw * );
int sblive_mpuoutSetPowerState ( struct sblive_hw *, u32 );

int sblive_mpuoutGetCaps          ( struct sblive_mpuout *, struct midi_caps * );
int sblive_mpuoutOpen             ( struct sblive_hw *, struct midi_openinfo *, u32 * );
int sblive_mpuoutClose            ( struct sblive_hw *, u32 );
int sblive_mpuoutAddBuffer        ( struct sblive_hw *, u32, struct midi_hdr *);
int sblive_mpuoutStart            ( struct sblive_mpuout *, u32 );
int sblive_mpuoutStop             ( struct sblive_mpuout *, u32 );
int sblive_mpuoutWriteShortData   ( struct sblive_hw *, u32, u32 );
int sblive_mpuoutPause            ( struct sblive_mpuout *, u32 );
int sblive_mpuoutStream           ( struct sblive_mpuout *, u32, struct midi_hdr * );
int sblive_mpuoutRestart          ( struct sblive_mpuout *, u32 );
int sblive_mpuoutReset            ( struct sblive_hw *, u32 );
int sblive_mpuoutCache            ( struct sblive_mpuout *, u32, struct midi_cache * );
int sblive_mpuoutGetPosition      ( struct sblive_mpuout *, u32, u32 * );
int sblive_mpuoutGetControl       ( struct sblive_mpuout *, u32, u32, u32 * );
int sblive_mpuoutSetControl       ( struct sblive_mpuout *, u32, u32, u32 * );

#endif  //_CARDMO_H_

