/*     
 **********************************************************************
 *     dbg.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _DEBUG_H
#define _DEBUG_H


#ifdef ASSERT
    #undef ASSERT
#endif


#ifdef CHECKED
    #define EDBG(x)         (x)
    
    #define DECLMAGIC       u32 magic;
    #define SETMAGIC(x)     ((x)->magic = 0x4944494dl)    
    #define CLEARMAGIC(x)   ((x)->magic = 0xcccccccc)

    #define SUCCESS(x)      if ((x) != CTSTATUS_SUCCESS) 
    #define ASSERT(x)       if (!(x)) printk(KERN_ERR "sblive: bad magic at %s %s.\n", __FILE__, __LINE__);
    #define TESTMAGIC(x)    if (!(x) || (x)->magic != 0x4944494dl) printk(KERN_ERR "sblive: bad magic at %s %s.\n", __FILE__, __LINE__);
#else
    #define EDBG(x)
    #define SUCCESS(x)      (x)
    #define DECLMAGIC
    #define SETMAGIC(x)
    #define TESTMAGIC(x)
    #define CLEARMAGIC(x)
    #define ASSERT(x)
#endif


#undef DPF             /* undef it, just in case */
#ifdef EMU10K1_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define DPD(x,y) printk( KERN_NOTICE "emu10k1: %s %x\n", x, (unsigned int) y)
#    define DPF(x)   printk( KERN_NOTICE "emu10k1: %s\n", x)
#  else
     /* This one for user space */
#    define DPD(x,y) fprintf(stderr, "emu10k1: %s %x\n", x, (unsigned int) y)
#    define DPF(x)   fprintf(stderr, "emu10k1: %s\n", x)
#  endif // __KERNEL__
#else
#  define DPD(x,y) /* not debugging: nothing */
#  define DPF(x)
#endif // EMU10K1_DEBUG

#endif //_DEBUG_H
