/*     
 **********************************************************************
 *     haldefs.h -- common definintion used in HAL
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _COMMON_H_
#define _COMMON_H_

/****************************************************************
            OS specified defination
 ***************************************************************/
/****************************************************************
            typedef for common datatypes
 ***************************************************************/

typedef int (*CALLBACKFN)(unsigned long,unsigned long ,unsigned long);
typedef int (*R3CALLBACKFN)(u32,u32,u32,u32);

enum GlobalErrorCode
{
    CTSTATUS_SUCCESS = 0x0000,
    CTSTATUS_ERROR,
    CTSTATUS_INVALIDPARAM,
    CTSTATUS_NOTSUPPORTED,
    CTSTATUS_NOMEMORY,
    CTSTATUS_INVALIDIO,
    CTSTATUS_INVALIDIRQ,
    CTSTATUS_INVALIDDMA,
    CTSTATUS_INVALIDID,
    CTSTATUS_INVALIDVALUE,
    CTSTATUS_BADFORMAT_BITS,
    CTSTATUS_BADFORMAT_RATE,
    CTSTATUS_BADFORMAT_CHANNELS,
    CTSTATUS_INUSE,
    CTSTATUS_STILLPLAYING,
    CTSTATUS_ALLOCATED,
    CTSTATUS_INVALID_FORMAT,
    CTSTATUS_OUT_OF_RESOURCE,
    CTSTATUS_CHIP_INUSE,
    CTSTATUS_NOCHIPRESOURCE,
    CTSTATUS_PORTS_INUSE
};

enum LocalErrorCode
{
    CTSTATUS_NOTENABLED = 0x7000,
    CTSTATUS_READY,
    CTSTATUS_BUSY,
    CTSTATUS_DATAAVAIL,
    CTSTATUS_NODATA,
    CTSTATUS_NEXT_BYTE
};

#define FLAGS_ENABLED       0x0001
#define FLAGS_AVAILABLE     0x0002
#define FLAGS_READY         0x0004
#define FLAGS_CLOSEPENDING  0x0008

//defines

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif
#ifndef NULL
#define NULL    0
#endif


#ifndef HIBYTE
#define HIBYTE(x)   (u8)((u16)(x)>>8)
#endif
#ifndef LOBYTE
#define LOBYTE(x)   (u8)(x)
#endif
#ifndef HIWORD
#define HIWORD(x)   (u16)((u32)(x)>>16)
#endif
#ifndef LOWORD
#define LOWORD(x)   (u16)(x)
#endif



#endif //_COMMON_H_

