/*
 **********************************************************************
 *     hwaccess.h
 *     Copyright 1999, 2000 Creative Labs, Inc.
 *
 **********************************************************************
 *
 *     Date		    Author	    Summary of changes
 *     ----		    ------	    ------------------
 *     October 20, 1999     Bertrand Lee    base code release
 *
 **********************************************************************
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *
 **********************************************************************
 */

#ifndef _HWACCESS_H
#define _HWACCESS_H

/*
 *		I N C L U D E	F I L E S
 */

#if defined(MANGLE_SYMS)
#include "symbols.h"
#endif

#if !defined(_PLATFORM_H) && !defined(_HAL_H)
    #include <platform.h>
#endif

#if !defined(_8010_H)
    #include "8010.h"
#endif

struct sblive_hw;

#if !defined(_VOICEMGR_H)
    #include "voicemgr.h"
#endif

#if !defined(_EMUADXMG_H)
    #include "emuadxmg.h"
#endif

#if !defined(_TIMER_H)
    #include "timer.h"
#endif

#if !defined(_IRQMGR_H)
#include "irq.h"
#include "irqmgr.h"
#endif

#if !defined(_EFFECTMGR_H)
    #include "efxmgr.h"
#endif

/*
 *			D A T A   S T R U C T U R E S
 */
struct sblive_hw {
	DECLMAGIC

	struct sblive_hw *next;
	struct sblive_hw *prev;

	unsigned long         synthaddx;
	unsigned long         mpuaddx;
	unsigned long         mixeraddx;
	unsigned long         intrenabaddx;
	unsigned long         intrStatusAddx;
	unsigned long         wallclockaddx;
	unsigned long         hwconfigaddx;
	unsigned long         timeraddx;

	u32 *        virtualpagetableptr;
	u32         virtualpagetable;
	unsigned long         PTBphysaddr;

	u32 *        tankmemptr;
	u32         tankmem;
	unsigned long         tmemphysaddr;

	u32 *        silentpageptr;
	u32         silentpage;
	unsigned long         silentpagephysaddx;

	// Critical Sections
	spinlock_t emu_lock;         // prevent multiple accesses

	struct voice_mgr  voice_manager;
	struct emu_addrmgr      emu_addrmgr;

	struct emu_timer	*emu_timer;

	struct sblive_irq          hw_irq;

	u32         irq;                  // Not used in NT
	unsigned long         hwaddr;
	u32         oshandle;
	unsigned        numvoices;
	unsigned        awecount;
	u32         tmemsize;
	u32         intrstate;            // Interrupt enable state


	unsigned long  joybase;
	struct pci_dev  *pcidev_joy;
	u32         tmemsizeIdx;
	int          bIsAPS;
	unsigned long          audio_num;
	unsigned long          mixer_num;
	unsigned long          midi_num;
	unsigned long          stat_num;
	struct sblive_waveout *card_waveout;
	struct sblive_wavein *card_wavein;
	struct sblive_mpuout *card_mpuout;
	struct sblive_mpuin *card_mpuin;
	u16          arrwVol[25]; // Size is hardcoded. Bad!
	unsigned int    modcnt;
	struct semaphore  open_sem;
	mode_t            open_mode;
#if LINUX_VERSION_CODE < 0x020301
	struct wait_queue *open_wait;
#else
	wait_queue_head_t open_wait;
#endif /* LINUX_VERSION_CODE < 0x020301 */


	u8	    paneffectsbus;
	u8	    auxeffectsbus;
	u8	    choruseffectsbus;
	u8	    reverbeffectsbus;

	CALLBACKFN  PCIBusErrorCallback;
	CALLBACKFN  MixerButtonCallback;    // VI,VD,MU bits in IP register
	CALLBACKFN  RecordCallback;	    // AF,AH bits in IP register
	CALLBACKFN  VoiceCallback;	    // CL bits in IP register
	CALLBACKFN  MpuOutCallback;	    // TX bits in IP register
	CALLBACKFN  MpuInCallback;	    // RX bits in IP register
	CALLBACKFN  TimerCallback;	    // IT bit in IP register
	CALLBACKFN  SPDIFCallback;	    // SS & CS bits in IP register
	CALLBACKFN  DSPCallback;	    // DSP bit in IP register

	u32	    pcierrorrefdata;
	u32	    mixerbuttonrefdata;
	u32	    recordrefdata;
	u32	    voicerefdata;
	u32	    mpuoutrefdata;
	u32	    mpuinrefdata;
	u32	    timerrefdata;
	u32	    spdifrefdata;
	u32	    DSPrefdata;

	u32	    powerstate; 	  // Current Power State
	u32	    mpuacqcount;	  // Mpu acquire count
	struct sblive_config	  dsCardCfg;
	u32	    has_toslink;	       // TOSLink detection
};


typedef u32  MCUSTATUS,  *PMCUSTATUS;
typedef u32  MPUSTATUS,  *PMPUSTATUS;

//******************************************************************************
//*				  D E F I N E S 			       *
//******************************************************************************

/*
** The following defines specify the devices available on the card.
*/
#define HWFLAG_EMU		    0x0001
#define HWFLAG_CQM		    0x0002
#define HWFLAG_MPU		    0x0004
#define HWFLAG_IRQ		    0x0008
#define HWFLAG_SF		    0x0010
#define HWFLAG_MIXER		    0x0020
#define HWFLAG_EFFECT		    0x0040
#define HWFLAG_DSP		    0x0080

/*
** Power states
*/
#define POWERSTATE_ON		    0x00000000
#define POWERSTATE_STANDBY	    0x00000001
#define POWERSTATE_STANDBYRESUME    0x00000002
#define POWERSTATE_SUSPEND	    0x00000004
#define POWERSTATE_SUSPENDRESUME    0x00000008
#define POWERSTATE_CRITICALRESUME   0x00000010


/* SBPRO - unusable for Live */
/*
** SB Port Offset defines
*/
#define SB_PORT_WRITESTATUS	    0x000C
#define SB_PORT_READSTATUS	    0x000E
#define SB_PORT_WRITEDATA	    0x000C
#define SB_PORT_READDATA	    0x000A
#define SB_PORT_RESET		    0x0006
#define SB_PORT_MIXERINDEX	    0x0004
#define SB_PORT_MIXERDATA	    0x0005
#define SB_PORT_8bIRQACK	    0x000E
#define SB_PORT_16bIRQACK	    0x000F
#define SB_PORT_MPUIRQACK	    0x0000

/*
** SB Mixer Register defines
*/
#define MIXER_REG_IRQSETUP	    0x80
#define MIXER_REG_DMASETUP	    0x81
#define MIXER_REG_IRQSTATUS	    0x82
#define MIXER_REG_MPUSETUP	    0x84

#define MIXER_REG_CHIPREV	    0xFD
#define MIXER_REG_CHIPID	    0xFE
#define MIXER_REG_CHIPIDTEST	    0xFF

#define MIXER_REG_MASTERL	    0x30
#define MIXER_REG_MASTERR	    0x31
#define MIXER_REG_MASTERRECL	    0x50
#define MIXER_REG_MASTERRECR	    0x51
#define MIXER_REG_WAVEL 	    0x32
#define MIXER_REG_WAVER 	    0x33
#define MIXER_REG_MIDIL 	    0x34
#define MIXER_REG_MIDIR 	    0x35
#define MIXER_REG_CDL		    0x36
#define MIXER_REG_CDR		    0x37
#define MIXER_REG_LINEINL	    0x38
#define MIXER_REG_LINEINR	    0x39
#define MIXER_REG_MIC		    0x3A
#define MIXER_REG_SPKR		    0x3B
#define MIXER_REG_MASTERINL	    0x50
#define MIXER_REG_MASTERINR	    0x51
#define MIXER_REG_AUXL		    0x52
#define MIXER_REG_AUXR		    0x53
#define MIXER_REG_TREBLEL	    0x44
#define MIXER_REG_TREBLER	    0x45
#define MIXER_REG_BASSL 	    0x46
#define MIXER_REG_BASSR 	    0x47
#define MIXER_REG_AGC		    0x43
#define MIXER_REG_INGAINL	    0x3F
#define MIXER_REG_INGAINR	    0x40
#define MIXER_REG_OUTGAINL	    0x41
#define MIXER_REG_OUTGAINR	    0x42
#define MIXER_REG_INSWITCHL	    0x3D
#define MIXER_REG_INSWITCHR	    0x3E
#define MIXER_REG_INSWITCHEX	    0x4A
#define MIXER_REG_OUTSWITCH	    0x3C
#define MIXER_REG_OUTSWITCHEX	    0x48
#define MIXER_REG_MASTERMUTE	    0x49
#define MIXER_REG_POWERDOWN	    0x7C
#define MIXER_REG_POWERSTANDBY	    0x88
#define MIXER_REG_POWERSUSPEND	    0x89
#define MIXER_REG_NEWFEATURES	    0x8E
#define MIXER_REG_3DSE		    0x90

/*
** AC97's Mixer Register defines
*/
#define AC97_REG_RESET		    0x00

#define AC97_REG_MASTER_VOL	    0x02    // line control
#define AC97_REG_HEADPHONE_VOL	    0x04    // head-phone control
#define AC97_REG_MONO_VOL	    0x06    // play control
#define AC97_REG_MASTER_TONE	    0x08
#define AC97_REG_PC_BEEP_VOL	    0x0A
#define AC97_REG_PHONE_VOL	    0x0C
#define AC97_REG_MIC_VOL	    0x0E
#define AC97_REG_LINE_VOL	    0x10
#define AC97_REG_CD_VOL 	    0x12
#define AC97_REG_VIDEO_VOL	    0x14
#define AC97_REG_AUX_VOL	    0x16
#define AC97_REG_PCM_VOL	    0x18
#define AC97_REG_REC_SELECT	    0x1A
#define AC97_REG_REC_GAIN	    0x1C
#define AC97_REG_REC_GAIN_MIC	    0x1E
#define AC97_REG_GENERAL	    0x20
#define AC97_REG_3D_CTRL	    0x22
#define AC97_REG_MODEM_RATE	    0x24
#define AC97_REG_PWR_DWN_CTRL	    0x26
#define AC97_REG_PWR_DWN_STAT	    0x26

#define AC97_REG_VENDOR_ID1	    0x7C
#define AC97_REG_VENDOR_ID2	    0x7E

#define AC97_REG_ZVIDEO_VOL	    0xEC //temp
#define AC97_REG_AC3_VOL	    0xED //temp

/*
** MPU Port Offset defines
*/
#define MPU_PORT_WRITESTATUS	    0x1
#define MPU_PORT_READSTATUS	    0x1
#define MPU_PORT_WRITEDATA	    0x0
#define MPU_PORT_READDATA	    0x0
#define MPU_PORT_COMMAND	    0x1


/*
** Irq Setting Bitmap
*/
#define IRQSETUP_IRQ9		    0x01
#define IRQSETUP_IRQ5		    0x02
#define IRQSETUP_IRQ7		    0x04
#define IRQSETUP_IRQ10		    0x08


/*
** EMU Irq Types
*/
#define IRQTYPE_PCIBUSERROR	    INT_PCI
#define IRQTYPE_MIXERBUTTON	    (INT_VINC|INT_VDEC|INT_MUTE)
#define IRQTYPE_VOICE		    (INT_LOOP|INT_CIN)
#define IRQTYPE_RECORD		    (INT_FULL|INT_HALF|INT_MICFULL|INT_MICHALF|INT_EFXFULL|INT_EFXHALF)
#define IRQTYPE_MPUOUT		    INT_TX
#define IRQTYPE_MPUIN		    INT_RX
#define IRQTYPE_TIMER		    INT_TIMER
#define IRQTYPE_SPDIF		    (INT_GSPCS|INT_CDCS)
#define IRQTYPE_DSP		    INT_DSP

#define TIMEOUT 		    16384
#define MPU_MAXTRIES		    1000


/*
 *		F U N C T I O N   P R O T O T Y P E S
 */

#ifdef __cplusplus
extern "C" {
#endif

u32 srToPitch(u32);
u8 sumVolumeToAttenuation(u32);

int halInit(struct sblive_hw *, struct sblive_config *, u32, u32 *);
int halExit(struct sblive_hw *);

extern u8 gabMsgLenChannel[];
extern u8 gabMsgLenSystem[];

#define MSGLENCHANNEL(status)  gabMsgLenChannel[(u8)((status) >> 4) - (u8)8]
#define MSGLENSYSTEM(status) gabMsgLenSystem[(u8)(status - MIDI_STATUS_SYSTEM_FIRST)];


/*
 * Hardware Abstraction Layer access functions
 */

u32 sblive_readsynth (struct sblive_hw * , u32 );
void sblive_writesynth (struct sblive_hw *, u32, u32);
u32 halEfxRead (struct sblive_hw *, u32);
void halEfxWrite (struct sblive_hw *, u32, u32);
u32 halReadPTR (struct sblive_hw *);
void halWritePTR (struct sblive_hw *, u32);
u32 halGetTimerDelay(struct sblive_hw *);
void halSetTimerDelay(struct sblive_hw *, u32);
u32 halIntrStatus (struct sblive_hw *, u32);
void halIntrAck (struct sblive_hw *, u32);
void halIntrEnable (struct sblive_hw *, u32);
void halIntrDisable (struct sblive_hw *, u32);
void halVoiceIntrEnable (struct sblive_hw *, u32);
void halVoiceIntrDisable (struct sblive_hw *, u32);
void halSetStopOnLoop (struct sblive_hw *, u32);
void halClearStopOnLoop (struct sblive_hw *, u32);
void halWC_WAIT (struct sblive_hw *, u32);
int halSetTOSLink (struct sblive_hw *, u32);
int halGetTOSLink (struct sblive_hw *, u32 *);

/*
 * AC97 Mixer access function
 */
int sblive_readac97(struct sblive_hw *, u8, u16 *);
int sblive_writeac97(struct sblive_hw *, u8, u16);
int sblive_rmwac97(struct sblive_hw *, u8, u16, u16);

/*
 * MPU access function
 */
int hwmpuWriteData(struct sblive_hw *, u8);
int hwmpuReadData(struct sblive_hw *, u8 *);
int hwmpuReset (struct sblive_hw *);
int hwmpuAcquire (struct sblive_hw *);
int hwmpuRelease (struct sblive_hw *);

/*
 * Miscellaneous function
 */
int halSetPowerState (struct sblive_hw *, u32);

/*
 * MCU functions
 */
int hwMcuReset(u16);
int hwMcuGetIrqStatus(u16, u8 *);


#ifdef __cplusplus
}
#endif

#endif  //_HWACCESS_H
