/*     
 **********************************************************************
 *     mmmidi.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _MMMIDI_H_
#define _MMMIDI_H_

//
// MIDI defines...
//

#define MIDI_DATA_FIRST                 0x00
#define MIDI_DATA_LAST                  0x7F
#define MIDI_STATUS_FIRST               0x80
#define MIDI_STATUS_LAST                0xFF

/** 'channel' status bytes **/
#define MIDI_STATUS_CHANNEL_FIRST       0x80
#define MIDI_STATUS_CHANNEL_LAST        0xE0
#define MIDI_STATUS_CHANNEL_MASK        0xF0

/* channel voice messages */
#define MIDI_VOICE_NOTE_OFF             0x80
#define MIDI_VOICE_NOTE_ON              0x90
#define MIDI_VOICE_POLY_PRESSURE        0xA0
#define MIDI_VOICE_CONTROL_CHANGE       0xB0
#define MIDI_VOICE_PROGRAM_CHANGE       0xC0
#define MIDI_VOICE_CHANNEL_PRESSURE     0xD0
#define MIDI_VOICE_PITCH_BEND           0xE0

/* channel mode messages */
#define MIDI_MODE_CHANNEL               MIDI_VOICE_CONTROL_CHANGE

/** 'system' status bytes **/
#define MIDI_STATUS_SYSTEM_FIRST        0xF0
#define MIDI_STATUS_SYSTEM_LAST         0xFF

/* system exclusive messages */
#define MIDI_SYSEX_BEGIN                0xF0
#define MIDI_SYSEX_EOX                  0xF7

/* system common messages */
#define MIDI_COMMON_TCQF                0xF1	/* time code quarter frame  */
#define MIDI_COMMON_SONG_POSITION       0xF2
#define MIDI_COMMON_SONG_SELECT         0xF3
#define MIDI_COMMON_UNDEFINED_F4        0xF4
#define MIDI_COMMON_UNDEFINED_F5        0xF5
#define MIDI_COMMON_TUNE_REQUEST        0xF6

/* system real-time messages */
#define MIDI_RTIME_TIMING_CLOCK         0xF8
#define MIDI_RTIME_UNDEFINED_F9         0xF9
#define MIDI_RTIME_START                0xFA
#define MIDI_RTIME_CONTINUE             0xFB
#define MIDI_RTIME_STOP                 0xFC
#define MIDI_RTIME_UNDEFINED_FD         0xFD
#define MIDI_RTIME_ACTIVE_SENSING       0xFE
#define MIDI_RTIME_SYSTEM_RESET         0xFF

/* flags for flags parm of midiOutCachePatches(), midiOutCacheDrumPatches() */
#define MIDI_CACHE_ALL                  1
#define MIDI_CACHE_BESTFIT              2
#define MIDI_CACHE_QUERY                3
#define MIDI_UNCACHE                    4

/* Event Declarations for MPU IRQ Callbacks */
#define ICARDMIDI_INLONGDATA            0x00000001	// MIM_LONGDATA
#define ICARDMIDI_INLONGERROR           0x00000002	// MIM_LONGERROR
#define ICARDMIDI_OUTLONGDATA           0x00000004	// MOM_DONE for MPU OUT buffer
#define ICARDMIDI_INDATA                0x00000010	// MIM_DATA
#define ICARDMIDI_INDATAERROR           0x00000020	// MIM_ERROR

/* Declaration for flags in CARDMIDIBUFFERHDR */
/* make it the same as MHDR_DONE, MHDR_INQUEUE in mmsystem.h */
#define MIDIBUF_DONE                    0x00000001
#define MIDIBUF_INQUEUE                 0x00000004

/* Declaration for msg parameter in midiCallbackFn */
#define ICARDMIDI_OUTBUFFEROK           0x00000001
#define ICARDMIDI_INMIDIOK              0x00000002

/* Declaration for support in struct midi_caps */
/*
   #define MIDICAPS_VOLUME                 0x00000001
   #define MIDICAPS_LRVOLUME               0x00000002
   #define MIDICAPS_CACHE                  0x00000004
   #define MIDICAPS_STREAM                 0x00000008
 */

#define MIDICAPS_INPUT                  0x00001000
#define MIDICAPS_OUTPUT                 0x00002000
#define MIDICAPS_SOUNDFONT              0x00004000

/* Declaration for technology in struct midi_caps */
#define MT_MIDIPORT                     0x00000001	// in original MIDIOUTCAPS structure
#define MT_FMSYNTH                      0x00000004	// in original MIDIOUTCAPS structure
#define MT_AWESYNTH                     0x00001000
#define MT_PCISYNTH                     0x00002000
#define MT_PCISYNTH64                   0x00004000
#define CARDMIDI_AWEMASK                0x0000F000

/* flags for wTechnology field of MIDIOUTCAPS structure */
#define MOD_MIDIPORT                    1	/* output port */
#define MOD_SYNTH                       2	/* generic internal synth */
#define MOD_SQSYNTH                     3	/* square wave internal synth */
#define MOD_FMSYNTH                     4	/* FM internal synth */
#define MOD_MAPPER                      5	/* MIDI mapper */

//Bit definitions for caps for struct midi_caps
#define CARDMIDI_OUT                    0x00000001
#define CARDMIDI_IN                     0x00000002

// Definitions for product in struct midi_caps
#define MM_CREATIVE_MIDIOUT             201
#define MM_CREATIVE_MIDIIN              202
#define MM_CREATIVE_FMSYNTH_STEREO      302
#define MM_CREATIVE_MIDI_AWE32          303
#define MM_CREATIVE_MIDI_EMU8008        305
#define MM_CREATIVE_MIDI_EMU10K1        306


/* midi data block header */
struct midi_hdr {
	u8 *reserved;		/* pointer to original locked data block */
	u32 bufferlength;	/* length of data in data block */
	u32 bytesrecorded;	/* used for input only */
	u32 user;		/* for client's use */
	u32 flags;		/* assorted flags (see defines) */
	struct midi_hdr  *next;	/* reserved for driver */
	u8 *lpData;		/* second copy of first pointer */
};

struct midi_caps {
	u32 cbsize;
	u32 support;
	u32 technology;
	u32 product;
	u32 manufacturer;
	u32 voices;
	u32 notes;
	u32 channelmask;
	u8 MIDIname[MAXPNAMELEN];
	u32 caps;
};

struct midi_cache {
	u32 cbsize;
	u32 action;
	u32 bank;
	u16 array[128];
};

struct midi_open_desc {
	u32 cbsize;
	u32 flags;
	u32 callback;
	u32 refdata;
	u32 streamid;
	u32 devicetype;
	u32 deviceid;
};

/* Enumeration for SetControl */
enum {
	MIDIOBJVOLUME = 0x1,
	MIDIQUERYACTIVEINST
};

#endif				//_MMMIDI_H_
