/*     
 **********************************************************************
 *     mmwave.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _MMWAVE_H_
#define _MMWAVE_H_

/* wave data block header */
struct tCTWAVEHDR
{
    u32     lpR3Data;           /* pointer to locked data buffer */
    u32     bufferlength;     /* length of data buffer */
    u32     bytesrecorded;    /* used for input only */
    u32     user;             /* for client's use */
    u32     flags;            /* assorted flags (see defines) */
    u32     loops;            /* loop control counter */
};

typedef struct tCTWAVEHDR CTWAVEHDR;
typedef struct tCTWAVEHDR   *PCTWAVEHDR;

/* flags for flags field of WAVEHDR */
#define WHDR_DONE           0x00000001  /* done bit */
#define WHDR_PREPARED       0x00000002  /* set if this header has been prepared */
#define WHDR_BEGINLOOP      0x00000004  /* loop start block */
#define WHDR_ENDLOOP        0x00000008  /* loop end block */
#define WHDR_INQUEUE        0x00000010  /* reserved for driver */

struct tCTWAVECAPS
{
    u16    manufacturer_id;                 /* manufacturer ID */
    u16    product_id;                 /* product ID */
    u16 driver_version;       /* version of the driver */
    u8    product_name[MAXPNAMELEN]; /* product name (NULL terminated string) */
    u32   formats;            /* formats supported */
    u16    channels;            /* number of sources supported */
    u32   support;
};

typedef struct tCTWAVECAPS CTWAVECAPS;
typedef struct tCTWAVECAPS  *PCTWAVECAPS;

/* defines for format field of WAVEINCAPS and WAVEOUTCAPS */
#define WAVE_INVALIDFORMAT      0x00000000      /* invalid format */
#define WAVE_FORMAT_1M08        0x00000001      /* 11.025 kHz, Mono, 8-bit */
#define WAVE_FORMAT_1S08        0x00000002      /* 11.025 kHz, Stereo, 8-bit */
#define WAVE_FORMAT_1M16        0x00000004      /* 11.025 kHz, Mono, 16-bit */
#define WAVE_FORMAT_1S16        0x00000008      /* 11.025 kHz, Stereo, 16-bit */
#define WAVE_FORMAT_2M08        0x00000010      /* 22.05 kHz, Mono, 8-bit */
#define WAVE_FORMAT_2S08        0x00000020      /* 22.05 kHz, Stereo, 8-bit */
#define WAVE_FORMAT_2M16        0x00000040      /* 22.05 kHz, Mono, 16-bit */
#define WAVE_FORMAT_2S16        0x00000080      /* 22.05 kHz, Stereo, 16-bit */
#define WAVE_FORMAT_4M08        0x00000100      /* 44.1 kHz, Mono, 8-bit */
#define WAVE_FORMAT_4S08        0x00000200      /* 44.1 kHz, Stereo, 8-bit */
#define WAVE_FORMAT_4M16        0x00000400      /* 44.1 kHz, Mono, 16-bit */
#define WAVE_FORMAT_4S16        0x00000800      /* 44.1 kHz, Stereo, 16-bit */

/* flags for support field of WAVEOUTCAPS */
#define WAVECAPS_PITCH          0x0001          /* supports pitch control */
#define WAVECAPS_PLAYBACKRATE   0x0002          /* supports playback rate control */
#define WAVECAPS_VOLUME         0x0004          /* supports volume control */
#define WAVECAPS_LRVOLUME       0x0008          /* separate left-right volume control */
#define WAVECAPS_SYNC           0x0010
#define WAVECAPS_SAMPLEACCURATE 0x0020
#define WAVECAPS_DIRECTSOUND    0x0040

#ifndef WIDM_LOWPRIORITY
#define WIDM_LOWPRIORITY        0x4093
#endif

/* Enumeration for SetControl */
enum
{
    WAVESTARTLOOP = 0x10,
    WAVEENDLOOP,
    WAVECURPOS,
    WAVESTOPPOSITION,
    WAVEWRITEPOINTER,
    WAVESETSTOPONLOOP,

    WAVEOBJVOLUME = 0x20,
    WAVEINSTANCEVOLUME,
    WAVEOBJREVERB,
    WAVEINSTANCEREVERB,
    WAVEOBJCHORUS,
    WAVEINSTANCECHORUS,
    WAVEOBJMUTE,
    WAVEVOLFACTOR,
    WAVEREVERBFACTOR,
    WAVECHORUSFACTOR,
    WAVEINSTANCEPITCHOFFSET,
    WAVEINSTANCESEND,

    WAVESYNCHSETUP = 0x30,
    WAVESYNCHSTART,
    WAVESETFREQUENCY,
    WAVESETSTARTFLAG,
    WAVEQUERYACTIVEINST,
    WAVEINSTANCEFILTERQ,
    WAVEINSTANCEFILTERCUTOFF,
    WAVEINSTANCEFORMAT,


    WAVEPROPERTYSETGET = 0x200,
    WAVEPROPERTYSETSET,
    WAVEPROPERTYSETQUERYSUPPORT,

    WAVEGET3DBUFFERPROPERTYSETIFACE = 0x250,
    WAVEGET3DLISTENERPROPERTYSETIFACE,
    WAVENUMFREE3DBUFFERS

};

/* flags for format_tag field of WAVEFORMAT */
#define WAVE_FORMAT_PCM     1

/*
 *  extended waveform format structure used for all non-PCM formats. this
 *  structure is common to all non-PCM formats.
 */
struct tCTWAVEFORMATEX
{
    u16      format_tag;         /* format type */
    u16      num_channels;          /* number of channels (i.e. mono, stereo...) */
    u32     samples_per_second;     /* sample rate */
    u32     avg_bytes_per_sec;    /* for buffer estimation */
    u16      nblockalign;        /* block size of data */
    u16      bitspersample;     /* number of bits per sample of mono data */
};

typedef struct tCTWAVEFORMATEX CTWAVEFORMATEX;
typedef struct tCTWAVEFORMATEX  *PCTWAVEFORMATEX;

struct tCTWAVEOPENDESC
{
    u32         callback;      // callback
    u32         refdata;       // app's private instance information
    CTWAVEFORMATEX  dsWaveFmt;
    u32         isopen;
};

typedef struct tCTWAVEOPENDESC CTWAVEOPENDESC;
typedef struct tCTWAVEOPENDESC  *PCTWAVEOPENDESC;
typedef struct tCTWAVEOPENDESC  *LPCTWAVEOPENDESC;

#endif //_MMWAVE_H_
