/*
 **********************************************************************
 *     timer.h
 *
 **********************************************************************
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *
 **********************************************************************
 */


#ifndef _TIMER_H
#define _TIMER_H


#define TIMER_STATE_ENABLED		1

struct emu_timer {
	DLIST(struct emu_timer);

	struct sblive_hw *sb_hw;
	CALLBACKFN callback;
	unsigned long callback_data;

	u32 flags;
	u32 maxdelay;
};

int sblive_timerInit(struct sblive_hw *);
int sblive_timerExit(struct sblive_hw *);
int sblive_timerInstallHandler(struct sblive_hw *, CALLBACKFN, unsigned long, struct emu_timer **);
int sblive_timerUninstallHandler(struct emu_timer *);
int sblive_timerSetMaxDelay(struct emu_timer *, u32);
int sblive_timerEnable(struct emu_timer *);
int sblive_timerDisable(struct emu_timer *);

#endif				/* ifndef _TIMER_H */
