#ident "@(#) space.c 1.0 94/01/12 "
/*
 *	Copyright (C) 1994-1995 CMD Technology, Inc.
 *		All Rights Reserved.
 *	The information in this file is provided for the exclusive use of
 *	the licensees of CMD Technology, Inc.  Such users have the right 
 *	to use, modify, and incorporate this code into other products for
 *	purposes authorized by the license agreement provided they include
 *	this notice and the associated copyright notice with any such product.
 *	The information in this file is provided "AS IS" without warranty.
 */

#include <sys/types.h>

/*
 * the number of CMD-6500 PCI-to-SCSI host adapters presently configured
 * in the system.  Range of values is from 1 to 4.  Default is 2
 */

int csha_num_csa65k = 2;

/*
 * The number of CCB's (Command Control Blocks) allocated for each CMD-6500
 * host adapter presently in the system.  Default is 100.  This can be 
 * decreased (to save system main memory) or increased (to improved SCSI
 * I/O performance).  There is a one-to-one correspondence between REQ_IO
 * and the CCB for CMD-6500 host adapter.  Therefore, if SDSKOUT, the 
 * number of requests outstanding per disk at any one time, is defined in
 * Sdsk, the number of CCB's has to be sufficiently large enough to account
 * for all disk devices and tape and CD-ROM drives configured in the system.
 */

int csha_num_ccb = 100;

/*
 * The following setting limits the maximum number of CCB's per target to 
 * be queued up in the CMD-6500 firmware's Ready-to-be-submitted internal
 * queue.  If this setting is zero (0), the default, which is the firmware
 * queue size (PCSHA_QUEUE_SIZE = 64) divided by the number of targets attached
 * to this CSA-6000 host adapter under consideration, is taken. 
 */

int csha_targetq_size = 4;
