/*
** Copyright (C) 1994-1998 by
** Digital Equipment Corporation, All rights reserved.
**
** This software is furnished under a license and may be used and copied
** only  in  accordance  with  the  terms  of such  license and with the
** inclusion of the above copyright notice. This software or  any  other
** copies thereof may not be provided or otherwise made available to any
** other person. No title to and ownership of  the  software  is  hereby
** transferred.
**
** The information in this software is subject to change without  notice
** and  should  not be  construed  as  a commitment by Digital Equipment
** Corporation.
**
** Digital assumes no responsibility for the use or  reliability  of its
** software on equipment which is not supplied by Digital.
**
*/



#define XXX_HW_accesses                  ACTN_HW_accesses
#define XXX_MAX_MEDIA_TABLE              ACTN_MAX_MEDIA_TABLE
#define XXX_media_types_t                ACTN_media_types_t
#define XXX_burst_length_t               ACTN_burst_length_t
#define XXX_CACHE_ILLEGAL                ACTN_CACHE_ILLEGAL
#define XXX_cache_alignment_t            ACTN_cache_alignment_t
#define XXX_10MB_threshold_t             ACTN_10MB_threshold_t
#define XXX_crc_calc_t                   ACTN_crc_calc_t
#define xxx_turbo                        actn_turbo
#define XXX_board_config_t               ACTN_board_config_t
#define XXX_info                         actn_info
#ifdef  ACTN3_0
#define XXX3_0                           ACTN3_0
#define XXX3_0_VECT                      ACTN3_0_VECT
#define XXX3_0_SIOA                      ACTN3_0_SIOA
#define XXX3_0_EIOA                      ACTN3_0_EIOA
#ifdef ACTN_CMAJOR_3
#define XXX_CMAJOR_3                     ACTN_CMAJOR_3
#endif
#endif
#ifdef  ACTN2_0
#define XXX2_0                           ACTN2_0
#define XXX2_0_VECT                      ACTN2_0_VECT
#define XXX2_0_SIOA                      ACTN2_0_SIOA
#define XXX2_0_EIOA                      ACTN2_0_EIOA
#ifdef  ACTN_CMAJOR_2
#define XXX_CMAJOR_2                     ACTN_CMAJOR_2
#endif
#endif
#ifdef  ACTN1_0
#define XXX1_0                           ACTN1_0
#define XXX1_0_VECT                      ACTN1_0_VECT
#define XXX1_0_SIOA                      ACTN1_0_SIOA
#define XXX1_0_EIOA                      ACTN1_0_EIOA
#ifdef  ACTN_CMAJOR_1
#define XXX_CMAJOR_1                     ACTN_CMAJOR_1
#endif
#endif
#ifdef  ACTN_0
#define XXX_0                            ACTN_0
#define XXX_0_VECT                       ACTN_0_VECT
#define XXX_0_SIOA                       ACTN_0_SIOA
#define XXX_0_EIOA                       ACTN_0_EIOA
#ifdef ACTN_CMAJOR_0
#define XXX_CMAJOR_0                     ACTN_CMAJOR_0
#endif
#endif
#define xxx_hw_accesses                  actn_hw_accesses
#define xxx_debug                        actn_debug
#define xxx_max_boards                   actn_max_boards
#define XXX_max_usrs                     ACTN_max_usrs
#define xxx_Boards_table                 actn_Boards_table
#define xxxinit                          actninit
#define xxxintr                          actnintr
#define xxxpoll                          actnpoll
#define xxx1poll                         actn1poll
#define xxx2poll                         actn2poll
#define xxx3poll                         actn3poll
#define xxxhalt                          actnhalt
#define xxx_start_adapter                actn_start_adapter
#define xxx_stop_adapter                 actn_stop_adapter
#define xxx_broken_adapter               actn_broken_adapter
#define xxx_init_cntrs                   actn_init_cntrs

#define xxx_init_sia_regs                actn_init_sia_regs /* today */
/* #define xxx__initialize_gep_register      actn_initialize_gep_register */
#define xxx_WriteCSR6					 actn_WriteCSR6

#define xxx_ptok                         actn_ptok
#define xxx_ktop                         actn_ktop
#define xxxpoll_disabled                 actnpoll_disabled
#define xxxpoll_prev                     actnpoll_prev
#define xxx_crctable                     actn_crctable
#define xxx_macioc_setmca                actn_macioc_setmca
#define xxx_macioc_delmca                actn_macioc_delmca
#define xxx_macioc_clrmca                actn_macioc_clrmca
#define xxx_macioc_getmca                actn_macioc_getmca
#define xxx_macioc_getaddr               actn_macioc_getaddr
#define xxx_macioc_setaddr               actn_macioc_setaddr
#define xxx_macioc_promisc               actn_macioc_promisc
#define xxx_macioc_getraddr              actn_macioc_getraddr
#define xxx_macioc_getmcsiz              actn_macioc_getmcsiz
#define xxx_handle_rx_filter_mode        actn_handle_rx_filter_mode
#define xxx_update_csr6                  actn_update_csr6
#define xxx_create_setupacket            actn_create_setupacket
#define xxx_poll_on_setupacket           actn_poll_on_setupacket
#define xxx_find_addr_in_board_table     actn_find_addr_in_board_table
#define xxx_setupacket_handler           actn_setupacket_handler
#define xxx_compare_addrs                actn_compare_addrs
#define xxx_dl_unitdata_req              actn_dl_unitdata_req
#define xxx_process_rx_pkts              actn_process_rx_pkts
#define xxx_alloc_rx_bufs                actn_alloc_rx_bufs
#define xxx_bufcall_rx_bufs              actn_bufcall_rx_bufs
#define xxx_proc_and_free_tx_bufs        actn_proc_and_free_tx_bufs
#define xxx_check_ioctl_message          actn_check_ioctl_message
#define xxx_iocblk_ack                   actn_iocblk_ack
#define xxx_unbind                       actn_unbind
#define xxx_flush_handler                actn_flush_handler
#define xxx_ioctl_handler                actn_ioctl_handler
#define xxx_proto_pcproto_handler        actn_proto_pcproto_handler
#define xxx_mac_hwfail_ind               actn_mac_hwfail_ind
#define xxx_check_pci_bios               actn_check_pci_bios
#define xxx_pci_find_dev_using_bios      actn_pci_find_dev_using_bios
#define xxx_pci_find_class_using_bios    actn_pci_find_class_using_bios
#define xxx_pci_read_config_dword        actn_pci_read_config_dword
#define xxx_pci_write_config_dword       actn_pci_write_config_dword
#define xxx_get_bus_type                 actn_get_bus_type
#define xxx_check_pci_bus                actn_check_pci_bus
#define xxx_parse_srom                   actn_parse_srom
#define xxx_calculate_checksum           actn_calculate_checksum
#define xxx_get_board_addr               actn_get_board_addr
#define xxx_read_srom                    actn_read_srom
#define xxx_check_if_board_in_system     actn_check_if_board_in_system
#define xxx_init_board                   actn_init_board
#define xxx_handle_pci_turbo             actn_handle_pci_turbo
#define xxx_autosense_intr_handler       actn_autosense_intr_handler
#define xxx_dc21041_dynamic_autosense    actn_dc21041_dynamic_autosense
#define xxx_dc21140_dynamic_autosense    actn_dc21140_dynamic_autosense
#define xxx_autodetection                actn_autodetection
#define xxx_free_rx_resources            actn_free_rx_resources
#define xxx_free_tx_resources            actn_free_tx_resources
#define xxx_alloc_rx_list                actn_alloc_rx_list
#define xxx_alloc_tx_list                actn_alloc_tx_list
#define xxx_alloc_setup_buf              actn_alloc_setup_buf
#define xxx_alloc_dummy_pkt              actn_alloc_dummy_pkt
#define xxx_init_eisa_regs               actn_init_eisa_regs
#define xxx_init_config_reg_vals         actn_init_config_reg_vals
#define xxx_init_config_regs_map         actn_init_config_regs_map
#define xxx_init_regs_map                actn_init_regs_map
#define xxx_init_ctrl_reg_vals           actn_init_ctrl_reg_vals
#define xxx_config_read_dword            actn_config_read_dword
#define xxx_config_write_dword           actn_config_write_dword
#define xxx_pci_find_device              actn_pci_find_device
#define XXX_100MB_threshold_t            actn_100MB_threshold_t
#define XXX_module_prefix		 actn_module_prefix

	
















#define XXX_TRUE     1
#define XXX_FALSE    0


/*
** DC21X4 debug's level
*/

typedef enum
    {
    XXX_LEVEL_0,
    XXX_LEVEL_1,
    XXX_LEVEL_2,
    XXX_LEVEL_3
    } XXX_debug_level;


/*
** DC21x4 HW accesses
*/

typedef enum
    {
    XXX_USE_PCI_BIOS,
    XXX_USE_PCI_MECHANISM1,
    XXX_USE_PCI_MECHANISM2
    } XXX_HW_accesses;


/*
** Media types for DC21040, DC2104, DC21140 and DC21142
*/

typedef enum
    {
    XXX_TP,
    XXX_BNC,
    XXX_AUI,
    XXX_100TX,
    XXX_TP_FDX,
    XXX_100TX_FDX,
    XXX_100T4,
    XXX_100FX,
    XXX_100FX_FDX,
    XXX_MAX_MEDIA_TABLE
    } XXX_media_types_t;



/* Phy  Mediums */

#define XXX_MII_TP                  0x0009
#define XXX_MII_TP_FDX              0x000A
#define XXX_MII_BNC                 0x000B
#define XXX_MII_AUI                 0x000C
#define XXX_MII_100TX               0x000D
#define XXX_MII_100TX_FDX           0x000E
#define XXX_MII_100T4               0x000F
#define XXX_MII_100FX               0x0010
#define XXX_MII_100FX_FDX           0x0011


#define XXX_NWAY           0x100
#define XXX_FULL_DUPLEX    0x200
#define XXX_LINK_DISABLE   0x400
#define XXX_AUTOSENSE      0x800


/*
** DC21X4 - SIA/serial modes
*/

#define XXX_TP_FULL_DUPLEX              (XXX_TP_FDX | XXX_FULL_DUPLEX)


/*
** DC2104X - added SIA modes
*/

#define XXX_TP_LINK_DISABLE             (XXX_TP | XXX_LINK_DISABLE)


/*
** DC2114X - added serial modes
*/

#define XXX_100TX_FULL_DUPLEX          (XXX_100TX_FDX | XXX_FULL_DUPLEX)
#define XXX_100FX_FULL_DUPLEX          (XXX_100FX_FDX | XXX_FULL_DUPLEX)

#define XXX_MII_TP_FULL_DUPLEX      (XXX_MII_TP_FDX | XXX_FULL_DUPLEX)
#define XXX_MII_100TX_FULL_DUPLEX   (XXX_MII_100TX_FDX | XXX_FULL_DUPLEX)
#define XXX_MII_100FX_FULL_DUPLEX   (XXX_MII_100FX_FDX | XXX_FULL_DUPLEX)
#define XXX_MII_AUTOSENSE           (XXX_MII_TP | XXX_AUTOSENSE)

#define XXX_DC21X4_DEF_SERIAL_MODE      0xFFFE


/*
** Burst Length
*/

typedef enum
    {
    XXX_PBL_0  = 0,
    XXX_PBL_1  = 1,
    XXX_PBL_2  = 2,
    XXX_PBL_4  = 4,
    XXX_PBL_8  = 8,
    XXX_PBL_16 = 16,
    XXX_PBL_32 = 32,
    XXX_PBL_DEFAULT = 0xFF
    } XXX_burst_length_t;


/*
** Cache Alignment
*/

typedef enum
    {
    XXX_CACHE_ILLEGAL = 0,
    XXX_CACHE_8 = 1,
    XXX_CACHE_16 = 2,
    XXX_CACHE_32 = 3,
    XXX_CACHE_DEFAULT = 0xFF
    } XXX_cache_alignment_t;

/*
** TX FIFO Threshold for 10MB
*/

typedef enum
    {
    XXX_10MB_THRESHOLD_72 = 0,
    XXX_10MB_THRESHOLD_96,
    XXX_10MB_THRESHOLD_128,
    XXX_10MB_THRESHOLD_160
    } XXX_10MB_threshold_t;


/*
** TX FIFO Threshold for 100MB
*/

typedef enum
    {
    XXX_100MB_THRESHOLD_128 = 0,
    XXX_100MB_THRESHOLD_256,
    XXX_100MB_THRESHOLD_512,
    XXX_100MB_THRESHOLD_1024,
    XXX_100MB_THRESHOLD_FULL = 0xFFFF
    } XXX_100MB_threshold_t;


#define XXX_NULL_PCI_HANDLER     0


/*
** HW/SW CRC calculation
*/

typedef enum
    {
    XXX_SW_CRC_ALWAYS = 0,
    XXX_SW_CRC_NEVER
    } XXX_crc_calc_t;


/*
** DC2114X's general purpose register - use the default vale
*/

#define XXX_GPR_DEFAULT      0xFFFF



typedef struct
   {
   ulong                     board_num;
   char                      *board_id;
   ulong                     iobase;
   ulong                     ioend;
   ulong                     cfgbase;
   uint                      major_num;
   uint                      rx_bufs_to_post;
   uint                      rx_pkts_queued_thresh_hi;
   uint                      rx_pkts_queued_thresh_lo;
/*   ushort                    DC2104X_sia_mode;
   ushort                    DC2114X_serial_mode;
 */
   ushort                    DC21X4_serial_mode;
   uint                      bus_arbitration;
   XXX_burst_length_t        burst_length;
   XXX_cache_alignment_t     cache_alignment;
   uint                      pass_bad_frames;
   uint                      backoff_cntr;
   XXX_10MB_threshold_t      threshold;
   XXX_100MB_threshold_t     threshold_100;
   uint                      parity_error_response;
   uint                      latency_timer;
   ushort                    pci_handle;
   XXX_crc_calc_t            crc_calc;
   uint                      dc2114x_gpr_ctrl;
   uint                      dc2114x_gpr_data;
   uint                      xxx_turbo;
   uint                      snooze_mode;
   unchar					 mwi_key;
   unchar					 mrm_key;
   unchar					 mrl_key;
   } XXX_board_config_t;

