
#include "sys/types.h"
#include "config.h"
#include "sys/actn_space.h"

/*
** Enable/disable diagnostic messages. Allowed values are:
**    XXX_LEVEL_3  - enable debug message in level 1,2,3.
**    XXX_LEVEL_2  - enable debug message in level 1,2.
**    XXX_LEVEL_1  - enable debug message in level 1.
**    XXX_LEVEL_0 - disable debug message
*/
#define XXX_DEBUG      XXX_LEVEL_0

/*
** For PCI machines - how to access the HW :
**   XXX_USE_PCI_BIOS        - Use the 32-bit protected mode PCI BIOS calls
**   XXX_USE_PCI_MECHANISM1  - Direct access to the HW, using PCI mechanism 1
**   XXX_USE_PCI_MECHANISM2  - Direct access to the HW, using PCI mechanism 2
**
**   NOTE : The default is to use the PCI BIOS calls (in 32-bit protected
**          mode). Some systems may not support these calls, in which case
**          there will be problems at boot time. If using a system that
**          does not support 32-bit protected mode PCI BIOS calls, direct
**          hardware accesses must be used.
**          XXX_USE_PCI_MECHANISM1 or XXX_USE_PCI_MECHANISM2 should be
**          selected depending on what the specific machine supports.
*/
#define XXX_HW_ACCESSES  XXX_USE_PCI_BIOS

/*
** Number of buffers pre-allocated on the receive list
*/
#define XXX_RX_BUFS_TO_POST            6

/*
** # of packets queued to read queues before rx processing is disabled
** (used as a high-water mark to disable driver rx processing of
** packets from the adapter)
*/
#define XXX_RX_PKTS_QUEUED_THRESH_HI   16

/*
** When less than this # of packets are queued to read queue then
** driver receive processing will be re-enabled if it was previously
** disabled.
*/
#define XXX_RX_PKTS_QUEUED_THRESH_LO   8


/*
** Maximum number of streams connected (opened) to each adapter .
** Revision 1 adapters are limited to 16. If the number defined here is
** greater than the limit supported by the adapter's revision, or greater
** than the maximum supported by the driver, the driver will use the minimum
** of all the limitations
*/
#define XXX_MAX_USRS                   16


/*
** Serial mode for All boards ! . Can have one of the
** following values:
** for DC21040 and DC21041 :
**     XXX_TP                          - 10 MB/sec TP connection
**     XXX_BNC                         - 10 MB/sec BNC connection
**     XXX_AUI                         - 10 MB/sec AUI connection
**     XXX_TP_FULL_DUPLEX              - point to point full duplex, 10 MB/sec
**                                       TP connection
**     XXX_TP_LINK_DISABLE             - Twisted pair connection with linkfail
**                                       test ignore & set polarity plus
**     XXX_DC21X4_DEF_SERIAL_MODE     - choose the value that was read from
**                                       the SROM if read, else choose the
**                                       AUTOSENSE mode
**
**
** for DC21140 and DC21142/3 :
**     XXX_TP                          - 10 MB/sec TP connection
**     XXX_BNC                         - 10 MB/sec BNC connection
**     XXX_AUI                         - 10 MB/sec AUI connection
**     XXX_TP_FULL_DUPLEX              - point to point full duplex, 10 MB/sec
**                                       TP connection
**     XXX_TP_LINK_DISABLE             - Twisted pair connection with linkfail
**                                       test ignore & set polarity plus - for
**                                       DC21142 only !
**     XXX_100TX                       - 100TX MB/sec mode
**     XXX_100TX_FULL_DUPLEX           - point to point full duplex, 100TX MB/sec
**                                       mode
**     XXX_100FX                       - 100 MB/sec FX mode
**     XXX_100FX_FULL_DUPLEX           - point to point full duplex, 100 MB/sec
**                                       FX mode
**     XXX_100T4                       - 100T4 MB/sec mode
**     XXX_AUTOSENSE                   - Automatic detection between all
**                                       supported media (except FULL DUPLEX).
**     XXX_DC21X4_DEF_SERIAL_MODE     - choose the value that was read from
**                                       the SROM if read, else choose the
**                                       AUTOSENSE mode
**
** Important Note!
** This definition is a global definition for all installed boards.
** If you want to set a different mode for each board, please modify
** the 'DC21X4_serial_mode' field in the appropriate part of the XXX_info
** structure below (the values to use are those listed above).
*/
#define XXX_DC21X4_SERIAL_MODE          XXX_AUTOSENSE

/*
** Selects internal bus arbitration between the receive and transmit
** processing. Allowed values:
**    XXX_TRUE  - round robin arbitration, equal sharing
**    XXX_FALSE - receive process has priority over the transmit process
**                (default)
*/
#define XXX_BUS_ARBITRATION   XXX_FALSE

/*
** Maximum number of longwords transferred in a DMA transaction.
** Allowed values are:
**     XXX_PBL_0 (0),
**     XXX_PBL_1 (1),
**     XXX_PBL_2 (2),
**     XXX_PBL_4 (4),
**     XXX_PBL_8 (8),
**     XXX_PBL_16 (16),
**     XXX_PBL_32 (32),
**     XXX_PBL_DEFAULT (32 for DC21140/DC21142 and 16 for DC21040/DC21041).
** NOTE : Burst length of XXX_PBL_0 means the only limit is the amount
**        of data stored.
** NOTE : Burst length of XXX_PBL_0 or XXX_PBL_32 are not supported in
**        21040/21041 boards due to chips' limitation. If the user
**        will choose one of those values, the driver will change the
**        burst length to 16. No warning is issued about this.
**
** NOTE : When the driver is working on a PCI machine with the CDC chip
**        (rev 3) or with the CDC chip (rev 2) it initializes the DC21X4 burst
**        length to XXX_PBL_8 and ignores the value that is given by the user
**        in space.c . No warning is issued about this (SCO Unix boot info
**        limitations)
*/
#define XXX_BURST_LENGTH      XXX_PBL_DEFAULT

/*
** Address boundary for data burst stop. Allowed values are:
**    XXX_CACHE_8
**    XXX_CACHE_16
**    XXX_CACHE_32
**    XXX_CACHE_DEFAULT (will be the same as the burst length)
*/
#define XXX_CACHE_ALIGNMENT   XXX_CACHE_DEFAULT

/*
** Enable/disable passing of bad frames (runt frames, truncated frames,
** collided frames) from the adapter to the driver.
**    XXX_TRUE  - enables passing of bad frames
**    XXX_FALSE - disable passingof bad frames (default)
*/
#define XXX_PASS_BAD_FRAMES   XXX_FALSE

/*
** Backoff counter algorithm.
**    XXX_TRUE  - stop counter when any carrier activity is detected
**    XXX_FALSE - backoff counter is not affected by the carrier activity
**                (default)
*/
#define XXX_BACKOFF_CNTR      XXX_FALSE

/*
** Transmit FIFO threshold for starting packet transmission to line (for
** 10MB mode).
** Allowed values are:
**    XXX_10MB_THRESHOLD_72
**    XXX_10MB_THRESHOLD_96 (default)
**    XXX_10MB_THRESHOLD_128
**    XXX_10MB_THRESHOLD_160
*/
#define XXX_10MB_THRESHOLD         XXX_10MB_THRESHOLD_96

/*
** Transmit FIFO threshold for starting packet transmission to line (for
** 100MB mode).
** Allowed values are:
**    XXX_100MB_THRESHOLD_128
**    XXX_100MB_THRESHOLD_256
**    XXX_100MB_THRESHOLD_512
**    XXX_100MB_THRESHOLD_1024
**    XXX_100MB_THRESHOLD_FULL (default) - full packet
*/
#define XXX_100MB_THRESHOLD         XXX_100MB_THRESHOLD_FULL

/*
** Enable/disable parity checking on PCI bus
**    XXX_TRUE  - enable parity checking
**    XXX_FALSE - disable parity checking (default)
*/
#define XXX_PARITY_ERROR_RESPONSE XXX_FALSE

/*
** DC21040/DC21140/DC21041/DC21142 PCI Latency Timer, in units of PCI bus
** clocks. Default is 50h
**
** Note : If the user chooses a value for the PCI Latency Timer that is < 50h
**        the driver changes this value to 50h, since the driver works with
**        the minimum value - 50h.
*/
#define XXX_LATENCY_TIMER     0x50

/*
** Enable/Disable SW's CRC calculation (in transmit packets)
**    XXX_SW_CRC_ALWAYS - CRC will be calculated by the software for every
**                        transmit packet longer than the threshold, for
**                        transmit packets shorter than the threshold the HW
**                        will calculate the CRC
**    XXX_SW_CRC_NEVER  - CRC will be calculated by the hardware for every
**                        transmit packet
*/
#define XXX_CRC_CALC          XXX_SW_CRC_ALWAYS

/*
** The control and data values to be written to the DC21140/DC21142 general
** purpose register.
**    XXX_GPR_DEFAULT - use the value found in the SROM. If no value
**                      is found in the SROM the driver uses its default
**                      values.
** The user can override the SROM default by setting specific values to
** XXX_DC2114X_CTRL/DATA.
**
** NOTE: The SROM values can't be over-ridden if the XXX_DC2114X_SERIAL_MODE
**       parameter is set to AUTOSENSE (or if it is set to use the SROM
**       default and the SROM value is AUTOSENSE). In this case these values
**       are ignored and no message is given.
*/
#define XXX_DC2114X_GPR_CTRL  XXX_GPR_DEFAULT
#define XXX_DC2114X_GPR_DATA  XXX_GPR_DEFAULT


/*
** This constant is used to enable/disable PCI priority over EISA.
**
** XXX_TRUE  - PCI has priority over EISA
** XXX_FALSE - EISA has priority over PCI
**
*/

#define XXX_TURBO             XXX_TRUE


/*
** Enable/disable snooze mode.
**    XXX_TRUE  - enable snooze mode
**    XXX_FALSE - disable snooze mode (default)
*/
#define XXX_SNOOZE            XXX_FALSE


#define XXX_UNDEF_USER		0xFF

/* 
** Enable/disable Extended PCI command Memory Write Invalidate (MWI)
**    XXX_TRUE  - enable the use of MWI commnad
**    XXX_FALSE - disable the use of MWI command
**
**    XXX_UNDEF_USER - (default)
*/
#define XXX_MWI				XXX_UNDEF_USER

/* 
** Enable/disable Extended PCI command Memory Read Multiple (MRM)
**    XXX_TRUE  - enable the use of MRM commnad
**    XXX_FALSE - disable the use of MRM command
**
**    XXX_UNDEF_USER - (default)
*/
#define XXX_MRM				XXX_UNDEF_USER

/* 
** Enable/disable Extended PCI command Memory Read Line (MRL)
**    XXX_TRUE  - enable the use of MRL commnad
**    XXX_FALSE - disable the use of MRL command
**
**    XXX_UNDEF_USER - (default)
*/
#define XXX_MRL				XXX_UNDEF_USER






#ifdef XXX3_0
#define XXX_MAX_BOARDS        4
#else
#ifdef XXX2_0
#define XXX_MAX_BOARDS        3
#else
#ifdef XXX1_0
#define XXX_MAX_BOARDS        2
#else
#ifdef XXX_0
#define XXX_MAX_BOARDS        1
#endif
#endif
#endif
#endif







XXX_board_config_t XXX_info[XXX_MAX_BOARDS] =
{
#ifdef XXX_0
   {
   0,                            /* board_num */
   "actn0",                      /* board_id */
   XXX_0_SIOA,                   /* iobase */
   XXX_0_EIOA,                   /* ioend */
   XXX_0_SIOA,                   /* placeholder for cfgbase */
#ifdef XXX_CMAJOR_0
   XXX_CMAJOR_0,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_DC21X4_SERIAL_MODE,       /* DC21X4_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC2114X_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   XXX_DC2114X_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE,                   /* snooze_mode */
   XXX_MWI,						 /* Enable/Disable MWI extended PCI command */
   XXX_MRM,						 /* Enable/Disable MRM extended PCI command */
   XXX_MRL						 /* Enable/Disable MRL extended PCI command */
   }
#endif



#ifdef XXX1_0
   ,{
   1,                            /* board_num */
   "actn1",                      /* board_id */
   XXX1_0_SIOA,                  /* iobase */
   XXX1_0_EIOA,                  /* ioend */
   XXX1_0_SIOA,                  /* placeholder for cfgbase */
#ifdef XXX_CMAJOR_1
   XXX_CMAJOR_1,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_DC21X4_SERIAL_MODE,       /* DC21X4_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC2114X_GPR_CTRL,         /* DC2114X's general purpose register control
                                    value */
   XXX_DC2114X_GPR_DATA,         /* DC2114X's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE,                   /* snooze_mode */
   XXX_MWI,						 /* Enable/Disable MWI extended PCI command */
   XXX_MRM,						 /* Enable/Disable MRM extended PCI command */
   XXX_MRL						 /* Enable/Disable MRL extended PCI command */
   }
#endif





#ifdef XXX2_0
   ,{
   2,                            /* board_num */
   "actn2",                      /* board_id */
   XXX2_0_SIOA,                  /* iobase */
   XXX2_0_EIOA,                  /* ioend */
   XXX2_0_SIOA,                  /* placeholder for cfgbase */
#ifdef XXX_CMAJOR_2
   XXX_CMAJOR_2,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_DC21X4_SERIAL_MODE,       /* DC21X4_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC2114X_GPR_CTRL,         /* DC2114X's general purpose register control
                                    value */
   XXX_DC2114X_GPR_DATA,         /* DC2114X's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE,                   /* snooze_mode */
   XXX_MWI,						 /* Enable/Disable MWI extended PCI command */
   XXX_MRM,						 /* Enable/Disable MRM extended PCI command */
   XXX_MRL						 /* Enable/Disable MRL extended PCI command */
   }
#endif








#ifdef XXX3_0
   ,{
   3,                            /* board_num */
   "actn3",                      /* board_id */
   XXX3_0_SIOA,                  /* iobase */
   XXX3_0_EIOA,                  /* ioend */
   XXX3_0_SIOA,                  /* placeholder for cfgbase */
#ifdef XXX_CMAJOR_3
   XXX_CMAJOR_3,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_DC21X4_SERIAL_MODE,       /* DC21X4_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC2114X_GPR_CTRL,         /* DC2114X's general purpose register control
                                    value */
   XXX_DC2114X_GPR_DATA,         /* DC2114X's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE,                   /* snooze_mode */
   XXX_MWI,						 /* Enable/Disable MWI extended PCI command */
   XXX_MRM,						 /* Enable/Disable MRM extended PCI command */
   XXX_MRL						 /* Enable/Disable MRL extended PCI command */
   }
#endif





};


#ifndef TCP_0
   void *ifstats = (void *)0;
#endif


uint            xxx_hw_accesses = XXX_HW_ACCESSES;
unchar          xxx_debug       = XXX_DEBUG;
uint            xxx_max_boards  = XXX_MAX_BOARDS;
uint            XXX_max_usrs    = XXX_MAX_USRS;
void            *xxx_Boards_table[XXX_MAX_BOARDS];

