/* The following are used for the 802.3 (LLC) implimentation */

#define	MAC_NOT_BOUND	(-1)		/* indication of non-boundedness */
#define	MAC_DEF_SAP	((unsigned long) 0xfffffffe) /* Default 802.3 SAP */
#define	MAC_NETWARE_SAP	((unsigned long) 0x000000ff) /* NetWare SAP */
#define	MAC_MIN_SAP	((short) 0x05dc) /* > indicates ethernet, < 802.3 */
#define MAC_MIN_PKLEN	((long) 46)	/* min packet len for 802.3 */
#define ETHER_IFSPEED	(10*1000000)	/* ethernet interface speed, bits/sec */

/* ioctls for the MAC drivers */

#define MACIOC(x)       	(('M' << 8) | (x))

#define MACIOC_DIAG		MACIOC(1)	/* Set MAC diagnostics */
#define MACIOC_UNITSEL		MACIOC(2)	/* MAC unit select */
#define MACIOC_SETMCA		MACIOC(3)	/* Multicast set */
#define MACIOC_DELMCA		MACIOC(4)	/* Multicast delete */
#define MACIOC_CLRMCA		MACIOC(5)	/* Flush multicast table */
#define MACIOC_GETMCA		MACIOC(6)	/* Get multicast table */
#define MACIOC_GETIFSTAT	MACIOC(7)	/* Dump BSD statistics */
#define MACIOC_GETADDR		MACIOC(8)	/* Get MAC address */
#define MACIOC_SETADDR		MACIOC(9)	/* Set MAC address */
#define MACIOC_GETSTAT		MACIOC(10)	/* Get MAC statistics */
#define MACIOC_PROMISC		MACIOC(11)	/* Set Promiscuous Reception */
#define MACIOC_GETRADDR		MACIOC(12)	/* Get factory MAC Address */
#define MACIOC_CLRSTAT		MACIOC(13)	/* Clear MAC statistics */
#define MACIOC_GETMCSIZ		MACIOC(14)	/* Get multicast table size */
#define MACIOC_HWDEPEND		MACIOC(15)	/* Hardware dependent */

#define MACIOC_LOCALSTAT	MACIOC(254)	/* dump statistics */

/* statistics structure (for the MACIOC_GETSTAT ioctl) */

typedef struct mac_stats {
	unsigned long mac_frame_xmit;	/* Frames Transmitted */
	unsigned long mac_bcast_xmit;	/* Broadcast Frames Transmitted */
	unsigned long mac_mcast_xmit;	/* Multicast Frames Transmitted */
	unsigned long mac_lbolt_xmit;	/* Frames Transmitted per Second */
	unsigned long mac_frame_recv;	/* Frames Received */
	unsigned long mac_bcast_recv;	/* Broadcast Frames Received */
	unsigned long mac_mcast_recv;	/* Multicast Frames Received */
	unsigned long mac_lbolt_recv;	/* Frames Received per Second */
	unsigned long mac_frame_def;	/* Frames Deferred */
	unsigned long mac_collisions;	/* Total Collisions */
	unsigned long mac_frame_coll;	/* Frames Involved in a Collision */
	unsigned long mac_oframe_coll;	/* Out of Frame Collisions */
	unsigned long mac_xs_coll;	/* Dropped Due To Excess Collisions */
	unsigned long mac_frame_nosr;	/* Dropped Due To Lack of STREAMS */
	unsigned long mac_no_resource;	/* Dropped Due To Lack of Resources */
	unsigned long mac_badsum;	/* Bad Checksum Received */
	unsigned long mac_align;	/* Bad Alignment Received */
	unsigned long mac_badlen;	/* Bad Length Received */
	unsigned long mac_badsap;	/* Bad SAP Received */
	unsigned long mac_mcast_rjct;	/* Multicast Frames Rejected */
	unsigned long mac_carrier;	/* Errors Due To Lost Carrier */
	unsigned long mac_badcts;	/* Errors Due To Lost CTS */
	unsigned long mac_baddma;	/* Errors Due To Over/Under Runs */
	unsigned long mac_timeouts;	/* Device Timeouts */
	unsigned long mac_intr;		/* Device Interrupts */
	unsigned long mac_spur_intr;	/* Spurious Interrupts */
	unsigned long mac_ioctets;	/* received octets */
	unsigned long mac_ooctets;	/* transmitted octets */
	unsigned long mac_ifspeed;	/* net interface speed in bits/sec */
	unsigned long mac_reserved[1];	/* Reserved */
} mac_stats_t;
