/*
** Copyright (C) 1991, 1992 by
** Digital Equipment Corporation, Maynard, Mass.
**
** This software is furnished under a license and may be used and copied
** only  in  accordance  with  the  terms  of such  license and with the
** inclusion of the above copyright notice. This software or  any  other
** copies thereof may not be provided or otherwise made available to any
** other person. No title to and ownership of  the  software  is  hereby
** transferred.
**
** The information in this software is subject to change without  notice
** and  should  not be  construed  as  a commitment by Digital Equipment
** Corporation.
**
** Digital assumes no responsibility for the use or  reliability  of its
** software on equipment which is not supplied by Digital.
**
*/



#define XXX_LEVEL_0                      DCE_LEVEL_0
#define XXX_LEVEL_1                      DCE_LEVEL_1
#define XXX_LEVEL_2                      DCE_LEVEL_2
#define XXX_LEVEL_3                      DCE_LEVEL_3
#define XXX_USE_PCI_BIOS                 DCE_USE_PCI_BIOS
#define XXX_USE_PCI_MECHANISM1           DCE_USE_PCI_MECHANISM1
#define XXX_USE_PCI_MECHANISM2           DCE_USE_PCI_MECHANISM2
#define XXX_HW_accesses                  DCE_HW_accesses
#define XXX_TP                           DCE_TP
#define XXX_BNC                          DCE_BNC
#define XXX_AUI                          DCE_AUI
#define XXX_100TX                        DCE_100TX
#define XXX_TP_FDX                       DCE_TP_FDX
#define XXX_100TX_FDX                    DCE_100TX_FDX
#define XXX_100T4                        DCE_100T4
#define XXX_100FX                        DCE_100FX
#define XXX_100FX_FDX                    DCE_100FX_FDX
#define XXX_MAX_MEDIA_TABLE              DCE_MAX_MEDIA_TABLE
#define XXX_media_types_t                DCE_media_types_t
#define XXX_PBL_0                        DCE_PBL_0
#define XXX_PBL_1                        DCE_PBL_1
#define XXX_PBL_2                        DCE_PBL_2
#define XXX_PBL_4                        DCE_PBL_4
#define XXX_PBL_8                        DCE_PBL_8
#define XXX_PBL_16                       DCE_PBL_16
#define XXX_PBL_32                       DCE_PBL_32
#define XXX_PBL_DEFAULT                  DCE_PBL_DEFAULT
#define XXX_burst_length_t               DCE_burst_length_t
#define XXX_CACHE_ILLEGAL                DCE_CACHE_ILLEGAL
#define XXX_CACHE_8                      DCE_CACHE_8
#define XXX_CACHE_16                     DCE_CACHE_16
#define XXX_CACHE_32                     DCE_CACHE_32
#define XXX_CACHE_DEFAULT                DCE_CACHE_DEFAULT
#define XXX_cache_alignment_t            DCE_cache_alignment_t
#define XXX_10MB_THRESHOLD_72            DCE_10MB_THRESHOLD_72
#define XXX_10MB_THRESHOLD_96            DCE_10MB_THRESHOLD_96
#define XXX_10MB_THRESHOLD_128           DCE_10MB_THRESHOLD_128
#define XXX_10MB_THRESHOLD_160           DCE_10MB_THRESHOLD_160
#define XXX_10MB_threshold_t             DCE_10MB_threshold_t
#define XXX_SW_CRC_ALWAYS                DCE_SW_CRC_ALWAYS
#define XXX_SW_CRC_NEVER                 DCE_SW_CRC_NEVER
#define XXX_crc_calc_t                   DCE_crc_calc_t
#define xxx_turbo                        dce_turbo
#define XXX_board_config_t               DCE_board_config_t
#define XXX_info                         DCE_info
#ifdef  DCE3_0
#define XXX3_0                           DCE3_0
#define XXX3_0_VECT                      DCE3_0_VECT
#define XXX3_0_SIOA                      DCE3_0_SIOA
#define XXX3_0_EIOA                      DCE3_0_EIOA
#ifdef DCE_CMAJOR_3
#define XXX_CMAJOR_3                     DCE_CMAJOR_3
#endif
#endif
#ifdef  DCE2_0
#define XXX2_0                           DCE2_0
#define XXX2_0_VECT                      DCE2_0_VECT
#define XXX2_0_SIOA                      DCE2_0_SIOA
#define XXX2_0_EIOA                      DCE2_0_EIOA
#ifdef  DCE_CMAJOR_2
#define XXX_CMAJOR_2                     DCE_CMAJOR_2
#endif
#endif
#ifdef  DCE1_0
#define XXX1_0                           DCE1_0
#define XXX1_0_VECT                      DCE1_0_VECT
#define XXX1_0_SIOA                      DCE1_0_SIOA
#define XXX1_0_EIOA                      DCE1_0_EIOA
#ifdef  DCE_CMAJOR_1
#define XXX_CMAJOR_1                     DCE_CMAJOR_1
#endif
#endif
#ifdef  DCE_0
#define XXX_0                            DCE_0
#define XXX_0_VECT                       DCE_0_VECT
#define XXX_0_SIOA                       DCE_0_SIOA
#define XXX_0_EIOA                       DCE_0_EIOA
#ifdef DCE_CMAJOR_0
#define XXX_CMAJOR_0                     DCE_CMAJOR_0
#endif
#endif
#define xxx_hw_accesses                  dce_hw_accesses
#define xxx_debug                        dce_debug
#define xxx_max_boards                   dce_max_boards
#define XXX_max_usrs                     DCE_max_usrs
#define xxx_Boards_table                 dce_Boards_table
#define xxxinit                          dceinit
#define xxxintr                          dceintr
#define xxx1intr                         dce1intr
#define xxx2intr                         dce2intr
#define xxx3intr                         dce3intr
#define xxxpoll                          dcepoll
#define xxx1poll                         dce1poll
#define xxx2poll                         dce2poll
#define xxx3poll                         dce3poll
#define xxxhalt                          dcehalt
#define xxx_start_adapter                dce_start_adapter
#define xxx_stop_adapter                 dce_stop_adapter
#define xxx_broken_adapter               dce_broken_adapter
#define xxx_init_cntrs                   dce_init_cntrs
#define xxx_init_sia_regs                dce_init_sia_regs
#define xxx_initialize_gep_registers     dce_initialize_gep_registers
#define xxx_ptok                         dce_ptok
#define xxx_ktop                         dce_ktop
#define xxx_turbo_saturn_bit_save        dce_turbo_saturn_bit_save
#define xxx_turbo_saturn_bit_clr_cntr    dce_turbo_saturn_bit_clr_cntr
#define xxx_saturn_pci_handle            dce_saturn_pci_handle
#define xxxpoll_disabled                 dcepoll_disabled
#define xxx_crctable                     dce_crctable
#define xxx_macioc_setmca                dce_macioc_setmca
#define xxx_macioc_delmca                dce_macioc_delmca
#define xxx_macioc_clrmca                dce_macioc_clrmca
#define xxx_macioc_getmca                dce_macioc_getmca
#define xxx_macioc_getaddr               dce_macioc_getaddr
#define xxx_macioc_setaddr               dce_macioc_setaddr
#define xxx_macioc_promisc               dce_macioc_promisc
#define xxx_macioc_getraddr              dce_macioc_getraddr
#define xxx_macioc_getmcsiz              dce_macioc_getmcsiz
#define xxx_handle_rx_filter_mode        dce_handle_rx_filter_mode
#define xxx_update_csr6                  dce_update_csr6
#define xxx_create_setupacket            dce_create_setupacket
#define xxx_poll_on_setupacket           dce_poll_on_setupacket
#define xxx_find_addr_in_board_table     dce_find_addr_in_board_table
#define xxx_setupacket_handler           dce_setupacket_handler
#define xxx_compare_addrs                dce_compare_addrs
#define xxx_dl_unitdata_req              dce_dl_unitdata_req
#define xxx_process_rx_pkts              dce_process_rx_pkts
#define xxx_alloc_rx_bufs                dce_alloc_rx_bufs
#define xxx_bufcall_rx_bufs              dce_bufcall_rx_bufs
#define xxx_proc_and_free_tx_bufs        dce_proc_and_free_tx_bufs
#define xxx_check_ioctl_message          dce_check_ioctl_message
#define xxx_iocblk_ack                   dce_iocblk_ack
#define xxx_unbind                       dce_unbind
#define xxx_flush_handler                dce_flush_handler
#define xxx_ioctl_handler                dce_ioctl_handler
#define xxx_proto_pcproto_handler        dce_proto_pcproto_handler
#define xxx_mac_hwfail_ind               dce_mac_hwfail_ind
#define xxx_check_pci_bios               dce_check_pci_bios
#define xxx_pci_find_dev_using_bios      dce_pci_find_dev_using_bios
#define xxx_pci_find_class_using_bios    dce_pci_find_class_using_bios
#define xxx_pci_read_config_dword        dce_pci_read_config_dword
#define xxx_pci_write_config_dword       dce_pci_write_config_dword
#define xxx_post_sia_init_delay          dce_post_sia_init_delay
#define xxx_get_bus_type                 dce_get_bus_type
#define xxx_check_pci_bus                dce_check_pci_bus
#define xxx_post_reset_delay             dce_post_reset_delay
#define xxx_parse_srom                   dce_parse_srom
#define xxx_calculate_checksum           dce_calculate_checksum
#define xxx_check_if_board_in_system     dce_check_if_board_in_system
#define xxx_init_board                   dce_init_board
#define xxx_handle_pci_turbo             dce_handle_pci_turbo
#define xxx_autosense_intr_handler       dce_autosense_intr_handler
#define xxx_dc21041_dynamic_autosense    dce_dc21041_dynamic_autosense
#define xxx_dc21140_dynamic_autosense    dce_dc21140_dynamic_autosense
#define xxx_autodetection                dce_autodetection
#define xxx_free_rx_resources            dce_free_rx_resources
#define xxx_free_tx_resources            dce_free_tx_resources
#define xxx_alloc_rx_list                dce_alloc_rx_list
#define xxx_alloc_tx_list                dce_alloc_tx_list
#define xxx_alloc_setup_buf              dce_alloc_setup_buf
#define xxx_alloc_dummy_pkt              dce_alloc_dummy_pkt
#define xxx_init_eisa_regs               dce_init_eisa_regs
#define xxx_init_config_reg_vals         dce_init_config_reg_vals
#define xxx_init_config_regs_map         dce_init_config_regs_map
#define xxx_init_regs_map                dce_init_regs_map
#define xxx_init_ctrl_reg_vals           dce_init_ctrl_reg_vals
#define xxx_config_read_dword            dce_config_read_dword
#define xxx_config_write_dword           dce_config_write_dword
#define xxx_pci_find_device              dce_pci_find_device
#define XXX_100MB_THRESHOLD_128          DCE_100MB_THRESHOLD_128 
#define XXX_100MB_THRESHOLD_256          DCE_100MB_THRESHOLD_256 
#define XXX_100MB_THRESHOLD_512          DCE_100MB_THRESHOLD_512 
#define XXX_100MB_THRESHOLD_1024         DCE_100MB_THRESHOLD_1024 
#define XXX_100MB_THRESHOLD_FULL         DCE_100MB_THRESHOLD_FULL 
#define XXX_100MB_threshold_t            DCE_100MB_threshold_t 
#define xxx_mii_phy_init                 dce_mii_phy_init
#define xxx_mii_phy_get_capabilities     dce_mii_phy_get_capabilities
#define xxx_mii_phy_set_connection_type  dce_mii_phy_set_connection_type
#define xxx_mii_phy_get_connection_type  dce_mii_phy_get_connection_type
#define xxx_mii_phy_get_connection_status dce_mii_phy_get_connection_status
#define xxx_mii_phy_admin_control        dce_mii_phy_admin_control
#define xxx_mii_phy_admin_status         dce_mii_phy_admin_status
#define xxx_init_phy_struc_entries       dce_init_phy_struc_entries
#define xxx_convert_media_type_to_nway_local_ability dce_convert_media_type_to_nway_local_ability
#define xxx_mii_gen_init                 dce_mii_gen_init
#define xxx_mii_gen_get_capabilities     dce_mii_gen_get_capabilities
#define xxx_mii_gen_set_connection       dce_mii_gen_set_connection
#define xxx_mii_gen_get_connection_status dce_mii_gen_get_connection_status
#define xxx_mii_gen_get_connection_status dce_mii_gen_get_connection_status
#define xxx_mii_gen_admin_status         dce_mii_gen_admin_status
#define xxx_mii_gen_admin_control        dce_mii_gen_admin_control
#define xxx_phy_init                     dce_phy_init
#define xxx_set_connection               dce_set_connection
#define xxx_mii_autosense                dce_mii_autosense 
#define xxx_dynamic_mii_autosense        dce_dynamic_mii_autosense 






#define XXX_TRUE     1
#define XXX_FALSE    0


/* 
** DS21x4 debug's level
*/

typedef enum
    {
    XXX_LEVEL_0,
    XXX_LEVEL_1,
    XXX_LEVEL_2,
    XXX_LEVEL_3
    } XXX_debug_level;


/*
** DS21x4 HW accesses
*/

typedef enum
    {
    XXX_USE_PCI_BIOS,
    XXX_USE_PCI_MECHANISM1,
    XXX_USE_PCI_MECHANISM2
    } XXX_HW_accesses;


/*
** Media types for DS21040, DS21041 and DS21140
*/

typedef enum 
    {
    XXX_TP, 
    XXX_BNC,
    XXX_AUI, 
    XXX_100TX,
    XXX_TP_FDX,
    XXX_100TX_FDX,
    XXX_100T4,
    XXX_100FX,
    XXX_100FX_FDX,
    XXX_MAX_MEDIA_TABLE
    } XXX_media_types_t;


#define XXX_NWAY           0x100
#define XXX_FULL_DUPLEX    0x200
#define XXX_LINK_DISABLE   0x400
#define XXX_AUTOSENSE      0x800


/*
** DS21X4 - SIA/serial modes
*/

#define XXX_TP_FULL_DUPLEX              (XXX_TP_FDX | XXX_FULL_DUPLEX)


/*
** DS2104x - added SIA modes
*/

#define XXX_TP_LINK_DISABLE             (XXX_TP | XXX_LINK_DISABLE)
#define XXX_DC2104X_DEF_SERIAL_MODE     0xFFFE


/*
** DS21140 - added serial modes
*/

#define XXX_100TX_FULL_DUPLEX          (XXX_100TX_FDX | XXX_FULL_DUPLEX)
#define XXX_100FX_FULL_DUPLEX          (XXX_100FX_FDX | XXX_FULL_DUPLEX)
#define XXX_DC21140_DEF_SERIAL_MODE     0xFFFE




/*
** Burst Length
*/

typedef enum 
    {
    XXX_PBL_0  = 0,
    XXX_PBL_1  = 1,
    XXX_PBL_2  = 2,
    XXX_PBL_4  = 4,
    XXX_PBL_8  = 8,
    XXX_PBL_16 = 16,
    XXX_PBL_32 = 32,
    XXX_PBL_DEFAULT = 0xFF 
    } XXX_burst_length_t;


/*
** Cache Alignment
*/

typedef enum 
    {
    XXX_CACHE_ILLEGAL = 0,
    XXX_CACHE_8 = 1,
    XXX_CACHE_16 = 2,
    XXX_CACHE_32 = 3,
    XXX_CACHE_DEFAULT = 0xFF 
    } XXX_cache_alignment_t;

/*
** TX FIFO Threshold for 10MB
*/

typedef enum 
    {
    XXX_10MB_THRESHOLD_72 = 0,
    XXX_10MB_THRESHOLD_96,
    XXX_10MB_THRESHOLD_128,       
    XXX_10MB_THRESHOLD_160      
    } XXX_10MB_threshold_t;


/*
** TX FIFO Threshold for 100MB
*/

typedef enum 
    {
    XXX_100MB_THRESHOLD_128 = 0,
    XXX_100MB_THRESHOLD_256,
    XXX_100MB_THRESHOLD_512,       
    XXX_100MB_THRESHOLD_1024,
    XXX_100MB_THRESHOLD_FULL = 0xFFFF
    } XXX_100MB_threshold_t;


#define XXX_NULL_PCI_HANDLER     0

/* 
** HW/SW CRC calculation
*/

typedef enum 
    {
    XXX_SW_CRC_ALWAYS = 0,
    XXX_SW_CRC_NEVER
    } XXX_crc_calc_t;


/* 
** DS21140's general purpose register - use the default vale
*/

#define XXX_GPR_DEFAULT      0xFFFF


typedef struct 
   {
   ulong                     board_num;
   char                      *board_id;
   uint                      vector;
   ulong                     iobase;
   ulong                     ioend;
   ulong                     cfgbase;
   uint                      major_num;
   uint                      rx_bufs_to_post;
   uint                      rx_pkts_queued_thresh_hi;
   uint                      rx_pkts_queued_thresh_lo;
   ushort                    DC2104x_sia_mode;
   ushort                    DC21140_serial_mode;
   uint                      bus_arbitration;
   XXX_burst_length_t        burst_length;
   XXX_cache_alignment_t     cache_alignment;       
   uint                      pass_bad_frames;
   uint                      backoff_cntr;
   XXX_10MB_threshold_t      threshold;
   XXX_100MB_threshold_t     threshold_100;
   uint                      parity_error_response;
   uint                      latency_timer;
   uint                      pci_handle;
   XXX_crc_calc_t            crc_calc;
   uint                      dc21140_gpr_ctrl; 
   uint                      dc21140_gpr_data; 
   uint                      xxx_turbo;
   uint                      snooze_mode;
   } XXX_board_config_t;
    
