/*
 * ============================================================================
 *
 * Copyright 1997, Digital Equipment Corporation. All rights reserverd.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of  the  software  is  hereby
 * transferred.
 *
 * The information in this software is subject to change without  notice
 * and  should  not be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use or  reliability  of its
 * software on equipment which is not supplied by Digital.
 *
 * ============================================================================
 *
 *	File:		Space.c
 *
 * ============================================================================
 * 456789/123456789/123456789/123456789/123456789/123456789/123456789/123456789
 * ============================================================================
 */


#ident	"Space.c, Copyright 1997, Digital Equipment Corporation. All rights reserverd."
#ident	"$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/* 
 * =============================================================================
 * Note: The EtherWORKS Turbo PCI 10 driver supports up to a maximum
 * of four (4) adapters per system
 * =============================================================================
 *
 * =============================================================================
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  DE500 board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 * =============================================================================
 */
 
#define	DE450_N_SAPS		8

/* 
 * =============================================================================
 * The follwing define is used to configure the media interface.   
 * 
 *   	1 - Have adapter auto detect connected cable
 *   	2 - Use TP connector, Half duplex mode
 *   	3 - Use TP connector, Full duplex mode
 *   	4 - Use BNC connector    (ignored by DE450-TA)
 *   	5 - Use AUI connector	 (ignored by DE450-TA)
 *
 * =============================================================================
 */

#define DE450_MEDIA_CONFIG_0   1
#define DE450_MEDIA_CONFIG_1   1 
#define DE450_MEDIA_CONFIG_2   1 
#define DE450_MEDIA_CONFIG_3   1 

/* 
 * =============================================================================
 * Set the following define to the max dma burst size the driver should use
 * The legal values are: 1,2,4,8,16
 * =============================================================================
 */ 

#define DE450_BURST_SIZE_0   16 
#define DE450_BURST_SIZE_1   16 
#define DE450_BURST_SIZE_2   16 
#define DE450_BURST_SIZE_3   16 

/*
 * =============================================================================
 * ============================ N O T I C E ====================================
 * =============================================================================
 *  The following values are set by the kernel build utilities and 
 *  should not be modified
 * =============================================================================
 */

int		de450_max_saps     		= DE450_N_SAPS;
int		de450_cmajor       		= DE450_CMAJOR_0;

int		de450_media_config[4] = {DE450_MEDIA_CONFIG_0, 
							 	 DE450_MEDIA_CONFIG_1, 
								 DE450_MEDIA_CONFIG_2,
								 DE450_MEDIA_CONFIG_3};

int		de450_burst_config[4] = {DE450_BURST_SIZE_0, 
								 DE450_BURST_SIZE_1, 
								 DE450_BURST_SIZE_2,
								 DE450_BURST_SIZE_3};
