/*---------------------------------------------------------------------------*/
//       Author : hiyohiyo
//         Mail : hiyohiyo@crystalmark.info
//          Web : https://crystalmark.info/
//      License : MIT License
/*---------------------------------------------------------------------------*/

#include "stdafx.h"

#include <windows.h>
#include <stdio.h>

#include <mmsystem.h>
#pragma comment(lib,"winmm.lib")

#define SEQ_READ   0
#define RND_READ  1
#define SEQ_WRITE  2
#define RND_WRITE 3

#define DISK_TEST_MAX_BUFFER_SIZE  1024*1024
#define DISK_TEST_TIME             6*1000

TCHAR testFilePath[MAX_PATH];

/** Reference 
Xorshift RNGs
George Marsaglia
The Florida State University
http://www.jstatsoft.org/v08/i14/paper
*/
unsigned long xor128()
{
	static unsigned long x=123456789,y=362436069,z=521288629,w=88675123;
	unsigned long t;
	t=(x^(x<<11));x=y;y=z;z=w; return( w=(w^(w>>19))^(t^(t>>8)) );
}

int SequentialRead(DWORD testSize)
{
	DWORD start = 0;
	DWORD finish = 0;
	DWORD count = 0;
	DWORD readSize = 0;
	DWORD bufferSize = DISK_TEST_MAX_BUFFER_SIZE;
	DWORD loop = testSize * 1024 * 1024 / bufferSize;
	BOOL  result = FALSE;
	char* buffer = NULL;

	buffer = (char*)VirtualAlloc(NULL, bufferSize, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
	if(buffer == NULL)
	{
		return 0;
	}

	HANDLE hFile = ::CreateFile(testFilePath, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL|FILE_FLAG_NO_BUFFERING|FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if(hFile == INVALID_HANDLE_VALUE)
	{
		return 0;
	}

	start = timeGetTime();

	do
	{
		for(DWORD i = 0; i < loop; i++)
		{
			result = ReadFile(hFile, buffer, bufferSize, &readSize, NULL);
			if(result)
			{
				count++;
			}
			else
			{
				CloseHandle(hFile);
				return 0;
			}
		}
		SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	}while(timeGetTime() - start < DISK_TEST_TIME);

	CloseHandle(hFile);
	finish = timeGetTime();
	VirtualFree(buffer, 0, MEM_RELEASE);

/*	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)((count * 4 * 10.0) / ((double)(finish - start) / (double)(DISK_TEST_TIME))));
	MessageBox(NULL, str, _T(""), MB_OK);


	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)((count * 1024 * 10) / ((finish - start) / 1000.0)));
	MessageBox(NULL, str, _T(""), MB_OK);
*/
	return (int)((count * 1024 * 10) / ((finish - start) / 1000.0));
//	return count * 1000;
}

int SequentialWrite(DWORD testSize)
{
	DWORD start = 0;
	DWORD finish = 0;
	DWORD count = 0;
	DWORD writeSize = 0;
	DWORD bufferSize = DISK_TEST_MAX_BUFFER_SIZE;
	DWORD loop = testSize * 1024 * 1024 / bufferSize;
	BOOL  result = FALSE;
	char* buffer = NULL;

	buffer = (char*)VirtualAlloc(NULL, bufferSize, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
	if(buffer == NULL)
	{
		return 0;
	}

	// Compatible with DiskSpd
	for (DWORD i = 0; i < bufferSize; i++)
	{
		buffer[i] = (char) (rand() % 256);
	}

	HANDLE hFile = ::CreateFile(testFilePath, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL|FILE_FLAG_NO_BUFFERING|FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if(hFile == INVALID_HANDLE_VALUE)
	{
		return 0;
	}

	start = timeGetTime();

	do
	{
		for(DWORD i = 0; i < loop; i++)
		{
			result = WriteFile(hFile, buffer, bufferSize, &writeSize, NULL);
			if(result)
			{
				FlushFileBuffers(hFile);
				count++;
			}
			else
			{
				CloseHandle(hFile);
				return 0;
			}
		}
		SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	}while(timeGetTime() - start < DISK_TEST_TIME);
	FlushFileBuffers(hFile);
	CloseHandle(hFile);

	finish = timeGetTime();
	VirtualFree(buffer, 0, MEM_RELEASE);
/*
	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)((count * 4 * 10.0) / ((double)(finish - start) / (double)(DISK_TEST_TIME))));
	MessageBox(NULL, str, _T(""), MB_OK);
*/
	return (int)((count * 1024 * 10.0) / ((finish - start) / 1000.0));
//	return count * 1000;
}

int RandomRead(DWORD testSize)
{
	DWORD start = 0;
	DWORD finish = 0;
	DWORD count = 0;
	DWORD readSize = 0;
	DWORD bufferSize = 4 * 1024;
	DWORD loop = 160;
	DWORD split = testSize * 1024 * 1024 / bufferSize;
	BOOL  result = FALSE;
	char* buffer = NULL;

	buffer = (char*)VirtualAlloc(NULL, bufferSize, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
	if(buffer == NULL)
	{
		return 0;
	}

	start = timeGetTime();
	do
	{
		HANDLE hFile = ::CreateFile(testFilePath, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL|FILE_FLAG_NO_BUFFERING
			|FILE_FLAG_RANDOM_ACCESS
			, NULL);

		if(hFile == INVALID_HANDLE_VALUE)
		{
			return 0;
		}

		for(DWORD i = 0; i < loop; i++)
		{
			SetFilePointer(hFile, (xor128() % split) * bufferSize, NULL, FILE_BEGIN);
			result = ReadFile(hFile, buffer, bufferSize, &readSize, NULL);
			if(result)
			{
				count++;
			}
			else
			{
				CloseHandle(hFile);
				return 0;
			}
		}
		CloseHandle(hFile);
		SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	}while(timeGetTime() - start < DISK_TEST_TIME);

	finish = timeGetTime();
	VirtualFree(buffer, 0, MEM_RELEASE);

/*	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)((count * 4 * 10.0) / ((double)(finish - start) / (double)(DISK_TEST_TIME))));
	MessageBox(NULL, str, _T(""), MB_OK);


	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)(count * (testSize * 10.0) / ((double)(finish - start) / (double)(DISK_TEST_TIME))));
	MessageBox(NULL, str, _T(""), MB_OK);
*/
	return (int)((count * 4 * 10.0) / ((finish - start) / 1000.0));
//	return count * 1000;
}

int RandomWrite(DWORD testSize)
{
	DWORD start = 0;
	DWORD finish = 0;
	DWORD count = 0;
	DWORD writeSize = 0;
	DWORD bufferSize = 4 * 1024;
	DWORD loop = 160;
	DWORD split = testSize * 1024 * 1024 / bufferSize;
	BOOL  result = FALSE;
	char* buffer = NULL;

	buffer = (char*)VirtualAlloc(NULL, bufferSize, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
	if(buffer == NULL)
	{
		return 0;
	}

	// Compatible with DiskSpd
	for (DWORD i = 0; i < bufferSize; i++)
	{
		buffer[i] = (char) (rand() % 256);
	}

	HANDLE hFile = ::CreateFile(testFilePath, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL|FILE_FLAG_NO_BUFFERING|FILE_FLAG_RANDOM_ACCESS, NULL);

	if(hFile == INVALID_HANDLE_VALUE)
	{
		return 0;
	}

	start = timeGetTime();

	do
	{
		for(DWORD i = 0; i < loop; i++)
		{
			SetFilePointer(hFile, (xor128() % split) * bufferSize, NULL, FILE_BEGIN);
			result = WriteFile(hFile, buffer, bufferSize, &writeSize, NULL);
			if(result)
			{
				FlushFileBuffers(hFile);
				count++;
			}
			else
			{
				CloseHandle(hFile);
				return 0;
			}
		}
	}while(timeGetTime() - start < DISK_TEST_TIME);
	FlushFileBuffers(hFile);
	CloseHandle(hFile);

	finish = timeGetTime();
	VirtualFree(buffer, 0, MEM_RELEASE);
/*
	TCHAR str[256];
	wsprintf(str, _T("c=%d, t=%d, l=%d, f=%d, s=%d, score=%d"), count, testSize, loop, finish, start, 
		(int)((count * 4 * 10.0) / ((double)(finish - start) / (double)(DISK_TEST_TIME))));
	MessageBox(NULL, str, _T(""), MB_OK);
*/
	return (int)((count * 4 * 10.0) / ((finish - start) / 1000.0));
//	return count * 1000;
}

/// PID
int _tmain(int argc, _TCHAR* argv[])
{
	/// for CrystalDiskMark
	int score = 0;
	DWORD testId = 0;
	DWORD testSize = 0;

	/*	
	TCHAR text[256];
	_stprintf(text, _T("%d %s %s"), argc, argv[0], argv[1]); 
	MessageBox(NULL, text, text, MB_OK);
*/

	if(argc == 4)
	{
//		pid = _tstoi(argv[0]);
		testId = _tstoi(argv[1]);
		testSize = _tstoi(argv[2]);
		_stprintf(testFilePath, argv[3]);
	}
	else
	{
		return 0;
	}

	switch(testId)
	{
	case SEQ_READ:  score = SequentialRead(testSize); break;
	case RND_READ:  score = RandomRead(testSize); break;
	case SEQ_WRITE: score = SequentialWrite(testSize); break;
	case RND_WRITE: score = RandomWrite(testSize); break;
	}

	return score;
	/*
	double averageLatency = 0.0;

	/// for CrystalDiskMark
	CHAR name[32];
	sprintf(name, "CrystalDiskMark%08X", pid);
	DWORD size = 8;

	HANDLE hSharedMemory = CreateFileMapping(INVALID_HANDLE_VALUE, NULL, PAGE_READWRITE, NULL, size, name);
	if (hSharedMemory != NULL)
	{
		double* pMemory = (double*)MapViewOfFile(hSharedMemory, FILE_MAP_ALL_ACCESS, NULL, NULL, size);
		if (pMemory != NULL)
		{
			*pMemory = averageLatency;
			UnmapViewOfFile(pMemory);
			CloseHandle(hSharedMemory);
		}
	}
	// fprintf(stderr, "%f", averageLatency);
	*/
}

