/*---------------------------------------------------------------------------*/
//       Author : hiyohiyo
//         Mail : hiyohiyo@crystalmark.info
//          Web : https://crystalmark.info/
//      License : MIT License
/*---------------------------------------------------------------------------*/

#pragma once

#include "AboutDlg.h"
#include "FontSelectionDlg.h"

#include "DialogFx.h"
#include "MainDialogFx.h"
#include "CrystalMarkDlg.h"

class CCrystalMarkRetroDlg : public CCrystalMarkDlg
{
public:
	CCrystalMarkRetroDlg(CWnd* pParent = NULL);
	~CCrystalMarkRetroDlg();

	// Virtual Function
	virtual CStringA GetRegisterUrl();
	virtual void SaveText(CString fileName);
	virtual void SetControlFont();
	virtual void Tweet();
	virtual void UpdateScore();
	virtual void UpdateDialogSize();

	// Benchmark Client Version
	CString m_CMRCPUVersion;
	CString m_DiskSpdVersion;
	CString m_CMRGDIVersion;
	CString m_CMROGLVersion;

	// HiyoGL
	__int64 m_Scene1Lines;
	__int64 m_Scene2Polygons;
	CString m_OpenGLVersion;
	CString m_OpenGLVendor;
	CString m_OpenGLRenderer;

	// CrystalDiskMark 8.0 compatible
	CString m_ValueTestSize;
	CString m_ValueTestDrive;
	CString m_TestDriveInfo;
	CString m_TestTargetPath;
	long m_TestDriveLetter;

	int m_IndexTestCount;

	int m_BenchType[2];
	int m_BenchSize[2];
	int m_BenchQueues[2];
	int m_BenchThreads[2];
	int m_IntervalTime;
	int m_MeasureTime;

	int m_TestData;
	int m_Profile;
	int m_Benchmark;
};


