/////////////////////////////////////////////////////////////////////////////
// Generate SHLWAPI.DLL functions with GitHub Copilot
/////////////////////////////////////////////////////////////////////////////

#include <windows.h>

LPSTR WINAPI PathFindExtensionA(const char* path)
{
	const char* p = path;
	const char* ext = NULL;
	while (*p)
	{
		if (*p == '.')
		{
			ext = p;
		}
		else if (*p == '\\' || *p == '/')
		{
			ext = NULL;
		}
		p = CharNextA(p);
	}
	if (ext)
	{
		return (LPSTR)ext;
	}
	return (LPSTR)p;
}

LPWSTR WINAPI PathFindExtensionW(const WCHAR* path)
{
	const WCHAR* p = path;
	const WCHAR* ext = NULL;
	while (*p)
	{
		if (*p == '.')
		{
			ext = p;
		}
		else if (*p == '\\' || *p == '/')
		{
			ext = NULL;
		}
		p++;
	}
	if (ext)
	{
		return (LPWSTR)ext;
	}
	return (LPWSTR)p;
}

char* WINAPI PathFindFileNameA(const char* path)
{
	const char* p = path;
	const char* name = NULL;
	while (*p)
	{
		if (*p == '\\' || *p == '/')
		{
			name = p + 1;
		}
		p = CharNextA(p);
	}
	if (name)
	{
		return (char*)name;
	}
	return (char*)path;
}

WCHAR* WINAPI PathFindFileNameW(const WCHAR* path)
{
	const WCHAR* p = path;
	const WCHAR* name = NULL;
	while (*p)
	{
		if (*p == '\\' || *p == '/')
		{
			name = p + 1;
		}
		p++;
	}
	if (name)
	{
		return (WCHAR*)name;
	}
	return (WCHAR*)path;
}

BOOL WINAPI PathIsUNCA(const char* path)
{
	if (path[0] == '\\' && path[1] == '\\')
	{
		return TRUE;
	}
	return FALSE;
}

BOOL WINAPI PathIsUNCW(const WCHAR* path)
{
	if (path[0] == '\\' && path[1] == '\\')
	{
		return TRUE;
	}
	return FALSE;
}

BOOL WINAPI PathIsRootA(const char* path)
{
	if (path[0] && path[1] == ':' && path[2] == '\\' && path[3] == 0)
	{
		return TRUE;
	}
	return FALSE;
}

BOOL WINAPI PathIsRootW(const WCHAR* path)
{
	if (path[0] && path[1] == ':' && path[2] == '\\' && path[3] == 0)
	{
		return TRUE;
	}
	return FALSE;
}

BOOL WINAPI PathRemoveFileSpecA(char* path)
{
	char* filespec = path;
	BOOL modified = FALSE;
	
	if (!path || !*path) { return FALSE; }
	if (*path == '\\') { filespec = ++path; }
	if (*path == '\\') { filespec = ++path; }

	while (*path)
	{
		if (*path == '\\')
		{
			filespec = path;
		}
		else if (*path == ':')
		{
			filespec = ++path;
			if (*path == '\\') { filespec++; }
		}
		path = CharNextA(path);
	}

	if (*filespec)
	{
		*filespec = '\0';
		modified = TRUE;
	}

	return modified;
}

BOOL WINAPI PathRemoveFileSpecW(WCHAR* path)
{
	WCHAR* filespec = path;
	BOOL modified = FALSE;

	if (!path || !*path){ return FALSE; }
	if (*path == '\\'){ filespec = ++path; }
	if (*path == '\\'){ filespec = ++path; }

	while (*path)
	{
		if (*path == '\\')
		{
			filespec = path;
		}
		else if (*path == ':')
		{
			filespec = ++path;
			if (*path == '\\') { filespec++; }
		}
		path++;
	}

	if (*filespec)
	{
		*filespec = '\0';
		modified = TRUE;
	}

	return modified;
}

BOOL WINAPI PathStripToRootA(char* path)
{
	if (path[0] && path[1] == ':' && path[2] == '\\' && path[3] == 0)
	{
		return TRUE;
	}
	return FALSE;
}

BOOL WINAPI PathStripToRootW(WCHAR* path)
{
	if (path[0] && path[1] == ':' && path[2] == '\\' && path[3] == 0)
	{
		return TRUE;
	}
	return FALSE;
}

void WINAPI PathRemoveExtensionA(char* path)
{
	char* ext = PathFindExtensionA(path);
	if (ext)
	{
		*ext = '\0';
	}
}

void WINAPI PathRemoveExtensionW(WCHAR* path)
{
	WCHAR* ext = PathFindExtensionW(path);
	if (ext)
	{
		*ext = '\0';
	}
}