var gCommonDialogParam = 
  window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
function showControls()
{
  var nTextBoxes = gCommonDialogParam.GetInt(3);
  if (nTextBoxes == 2) {
    if (gCommonDialogParam.GetInt(4) == 1) {
      initTextbox("password1", 4, 6, false);
      initTextbox("password2", 5, 7, false);
    }
    else {
      initTextbox("login", 4, 6, false);
      initTextbox("password1", 5, 7, false);
    }
  } else if (nTextBoxes == 1) {
    if (gCommonDialogParam.GetInt(4) == 1)
      initTextbox("password1", -1, 6, true);
    else
      initTextbox("login", 4, 6, true);
  }
}
function setLabelForNode(aNode, aLabel, aIsLabelFlag)
{
  var accessKey = null;
  if (/ *\(\&([^&])\)(:)?$/.test(aLabel)) {
    aLabel = RegExp.leftContext + RegExp.$2;
    accessKey = RegExp.$1;
  } else if (/^(.*[^&])?\&(([^&]).*$)/.test(aLabel)) {
    aLabel = RegExp.$1 + RegExp.$2;
    accessKey = RegExp.$3;
  }
  aLabel = aLabel.replace(/\&\&/g, "&");
  if (aIsLabelFlag) {    // Set text for <label> element
    aNode.setAttribute("value", aLabel);
  } else {    // Set text for other xul elements
    aNode.label = aLabel;
  }
  if (accessKey)
    aNode.accessKey = accessKey;
}
function commonDialogOnLoad()
{
  if (/Mac/.test(navigator.platform)) {
    var titleString = gCommonDialogParam.GetString(12);
    if (/^\w+:\/\/\w/.test(titleString)) {
      setElementText("info.title", titleString, true);
      unHideElementById("info.title"); // Show URI inside dialog.
    }
  }
  else {
    document.title = gCommonDialogParam.GetString(12);
  }
  var nButtons = gCommonDialogParam.GetInt(2);
  var dialog = document.documentElement;
  switch (nButtons) {
    case 1:
      dialog.getButton("cancel").hidden = true;
      break;
    case 4:
      dialog.getButton("extra2").hidden = false;
    case 3:
      dialog.getButton("extra1").hidden = false;
  }
  var messageText = gCommonDialogParam.GetString(0);
  var messageParent = document.getElementById("info.box");
  var messageParagraphs = messageText.split("\n");
  for (var i = 0; i < messageParagraphs.length; i++) {
    var descriptionNode = document.createElement("description");
    var text = document.createTextNode(messageParagraphs[i]);
    descriptionNode.appendChild(text);
    messageParent.appendChild(descriptionNode);
  }
  setElementText("info.header", gCommonDialogParam.GetString(3), true);
  var iconElement = document.getElementById("info.icon");
  var iconClass = gCommonDialogParam.GetString(2);
  if (!iconClass)
    iconClass = "message-icon";
  iconElement.setAttribute("class", iconElement.getAttribute("class") + " " + iconClass);
  switch (nButtons) {
    case 4:
      setLabelForNode(document.documentElement.getButton("extra2"), gCommonDialogParam.GetString(11));
    case 3:
      setLabelForNode(document.documentElement.getButton("extra1"), gCommonDialogParam.GetString(10));
    default:
    case 2:
      var string = gCommonDialogParam.GetString(9);
      if (string)
        setLabelForNode(document.documentElement.getButton("cancel"), string);
    case 1:
      string = gCommonDialogParam.GetString(8);
      if (string)
        setLabelForNode(document.documentElement.getButton("accept"), string);
      break;
  }
  gCommonDialogParam.SetInt(0, 1); 
  setCheckbox(gCommonDialogParam.GetString(1), gCommonDialogParam.GetInt(1));
  if (gCommonDialogParam.GetInt(3) == 0) // If no text fields
  {
    var dlgButtons = ['accept', 'cancel', 'extra1', 'extra2'];
    var dButton = dlgButtons[gCommonDialogParam.GetInt(5)];
    document.documentElement.defaultButton = dButton;
    if (!/Mac/.test(navigator.platform))
      document.documentElement.getButton(dButton).focus();
  }
  if (gCommonDialogParam.GetInt(6) != 0) // delay button enable
  {
    var delayInterval = 2000;
    try {
      var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                  .getService(Components.interfaces.nsIPrefBranch);
      delayInterval = prefs.getIntPref("security.dialog_enable_delay");
    } catch (e) {}
    document.documentElement.getButton("accept").disabled = true;
    document.documentElement.getButton("extra1").disabled = true;
    document.documentElement.getButton("extra2").disabled = true;
    setTimeout(commonDialogReenableButtons, delayInterval);
    addEventListener("blur", commonDialogBlur, false);
    addEventListener("focus", commonDialogFocus, false);
  }
  getAttention();
}
var gDelayExpired = false;
var gBlurred = false;
function commonDialogBlur(aEvent)
{
  if (aEvent.target != document)
    return;
  gBlurred = true;
  document.documentElement.getButton("accept").disabled = true;
  document.documentElement.getButton("extra1").disabled = true;
  document.documentElement.getButton("extra2").disabled = true;
}
function commonDialogFocus(aEvent)
{
  if (aEvent.target != document)
    return;
  gBlurred = false;
  if (gDelayExpired) {
    var script = "document.documentElement.getButton('accept').disabled = false; ";
    script += "document.documentElement.getButton('extra1').disabled = false; ";
    script += "document.documentElement.getButton('extra2').disabled = false;";
    setTimeout(script, 1000);
  }
}
function commonDialogReenableButtons()
{
  if (!gBlurred) {
    document.documentElement.getButton("accept").disabled = false;
    document.documentElement.getButton("extra1").disabled = false;
    document.documentElement.getButton("extra2").disabled = false;
  }
  gDelayExpired = true;
}
function initTextbox(aName, aLabelIndex, aValueIndex, aAlwaysLabel)
{
  unHideElementById(aName+"Container");
  var label = aLabelIndex < 0 ? "" : gCommonDialogParam.GetString(aLabelIndex);
  if (label || aAlwaysLabel && !label)
    setElementText(aName+"Label", label);
  var value = aValueIndex < 0 ? "" : gCommonDialogParam.GetString(aValueIndex);
  var textbox = document.getElementById(aName + "Textbox");
  textbox.setAttribute("value", value);
}
function setElementText(aElementID, aValue, aChildNodeFlag)
{
  var element = document.getElementById(aElementID);
  if (!aChildNodeFlag && element) {
    setLabelForNode(element, aValue, true);
  } else if (aChildNodeFlag && element) {
    element.appendChild(document.createTextNode(aValue));
  }
}
function setCheckbox(aChkMsg, aChkValue)
{
  if (aChkMsg) {
    document.getElementById("checkboxContainer").removeAttribute("collapsed");
    var checkboxElement = document.getElementById("checkbox");
    setLabelForNode(checkboxElement, aChkMsg);
    checkboxElement.checked = aChkValue > 0;
  }
}
function unHideElementById(aElementID)
{
  var element = document.getElementById(aElementID);
  element.hidden = false;
}
function hideElementById(aElementID)
{
  var element = document.getElementById(aElementID)
  element.hidden = true;
}
function isVisible(aElementId)
{
  return document.getElementById(aElementId).hasAttribute("hidden");
}
function onCheckboxClick(aCheckboxElement)
{
  gCommonDialogParam.SetInt(1, aCheckboxElement.checked);
}
function commonDialogOnAccept()
{
  gCommonDialogParam.SetInt(0, 0); // say that ok was pressed
  var numTextBoxes = gCommonDialogParam.GetInt(3);
  var textboxIsPassword1 = gCommonDialogParam.GetInt(4) == 1;
  if (numTextBoxes >= 1) {
    var editField1;
    if (textboxIsPassword1)
      editField1 = document.getElementById("password1Textbox");
    else
      editField1 = document.getElementById("loginTextbox");
    gCommonDialogParam.SetString(6, editField1.value);
  }
  if (numTextBoxes == 2) {
    var editField2;
    if (textboxIsPassword1)
      editField2 = document.getElementById("password2Textbox");
    else
      editField2 = document.getElementById("password1Textbox");
    gCommonDialogParam.SetString(7, editField2.value);
  }
}
function commonDialogOnExtra1()
{
  gCommonDialogParam.SetInt(0, 2);
  window.close();
}
function commonDialogOnExtra2()
{
  gCommonDialogParam.SetInt(0, 3);
  window.close();
}
