/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function promptDelete 
  ( eDialogTitle, eIconClass, eMsg, eTitleMessage, eButton0Text, 
    eButton1Text, eButton2Text , eButton3Text, eDefaultButton  )
{




  const nsIDialogParamBlock = Components.interfaces.nsIDialogParamBlock;
  const nsDialogParamBlock = "@mozilla.org/embedcomp/dialogparam;1";

//  const eIconClasses = new Array("question-icon", "alert-icon", "message-icon");

  var params = Components.classes["@mozilla.org/embedcomp/dialogparam;1"].createInstance(Components.interfaces.nsIDialogParamBlock);

  params.SetString(0,  eMsg);                         //eMsg
  //params.SetString(1,  'eCheckboxMsg');                 //eCheckboxMsg
  params.SetString(2,  eIconClass);             //eIconClass
  params.SetString(3,  eTitleMessage);                //eTitleMessage

  //params.SetString(4,  'eEditfield1Msg');               //eEditfield1Msg
  //params.SetString(5,  'eEditfield2Msg');               //eEditfield2Msg
  //params.SetString(6,  'eEditfield1Value');             //eEditfield1Value
  //params.SetString(7,  'eEditfield2Value');             //eTitleMessage

  //arrange buttons
  //please note that the button layout is
  //    [Button3] [Button0] [Button2] [Button1]
  params.SetString(8,  eButton0Text);                 //eButton0Text
  params.SetString(9,  eButton1Text);                 //eButton1Text
  params.SetString(10, eButton2Text);                 //eButton2Text
  params.SetString(11, eButton3Text);                 //eButton3Text
  //title
  params.SetString(12, eDialogTitle);                 //eDialogTitle
  
  
  
  //enum {eButtonPressed=0, eCheckboxState=1, eNumberButtons=2,
  //eNumberEditfields=3, eEditField1Password=4, eDefaultButton=5,
  //eDelayButtonEnable=6}
  //params.SetInt(0, 1);   //eButtonPressed (this one is really only used with getInt() from js to get the number of the button clicked
  params.SetInt(1, 0);   //eCheckboxState (0 - unchecked, 1 - checked ) 
  params.SetInt(2, 4);   //eNumberButtons  (maximum number of buttons: 1-4)
  params.SetInt(3, 0);   //eNumberEditfields ( 0 - no textfield, 1 - one normal textfield, 2 - one normal textfield and one password field )
  params.SetInt(4, 0);   //eEditField1Password ( 0 - none of the textfields are password fields, 1 - all shown textfields are password fields )
  params.SetInt(5, 1);   //eDefaultButton ( values 0-3, corresponding to button number, Bug: when set to 2 button 3 gets highlighted )
  params.SetInt(6, 0);   //eDelayButtonEnable (if set to 1 does a time dealy for Button1)
  
  window.openDialog("chrome://global/content/commonDialog.xul", "", "chrome,centerscreen,modal", params);
  
  return ( params.GetInt(0) );   //eButtonPressed ( get the number of the button pressed )
  //params.GetInt(1);   //eCheckboxState (get the state of the checkbox (0 - unchecked, 1 - checked )  )
  
}