 /* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Mozilla.org.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Author(s): Michael Ryabushkin
 *
 * ***** END LICENSE BLOCK ***** */

/*----------------------
 Contains some of the code is from Mozilla original Cookie Editor
 ----------------------*/

var prefs;
var delconf = "addneditcookies.displaydeleteconfirmation"



//==============================
function LoadPrefs()
{
	prefs = Components.classes["@mozilla.org/preferences-service;1"].
                getService(Components.interfaces.nsIPrefBranch);

	document.getElementById("delconf").setAttribute("checked",DeleteConfirmation());
}
//==============================


//==============================
function SavePrefs()
{
	//delete confirmation
	prefs.setBoolPref(delconf,document.getElementById("delconf").checked);	

	window.close();
}
//==============================



//==============================
function DeleteConfirmation()
{
                
	var delconf_pref = false;
  
  if (prefs.getPrefType(delconf) == prefs.PREF_BOOL)
  {
    delconf_pref = prefs.getBoolPref(delconf);
  }
  else
  {
  	prefs.setBoolPref(delconf,false);	
  	return false;
  }
  
  return delconf_pref;
  
}
//==============================

//==============================
function GetBoolPrefValue(key) {  return prefs.getBoolPref(key);}
//==============================